/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductSettings;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductSettingsItem;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.function.Function;

public class CommonRailwayHelper {
    private static RailwayProductSettings getRailwayProductSettings() {
        return SystemHelper.searchSystemSettings(RailwayProductSettings.class).stream().findFirst().orElse(null);
    }

    public static EntityReference<Organization> getSupplier(GdsName gds) {
        return CommonRailwayHelper.getGdsItemValue(gds, RailwayProductSettingsItem::getSupplier);
    }

    public static EntityReference<Organization> getBlankOwner(GdsName gds) {
        return CommonRailwayHelper.getGdsItemValue(gds, RailwayProductSettingsItem::getBlankOwner);
    }

    private static EntityReference<Organization> getGdsItemValue(GdsName gds, Function<RailwayProductSettingsItem, EntityReference<Organization>> getValue) {
        RailwayProductSettings settings = CommonRailwayHelper.getRailwayProductSettings();
        if (settings == null) {
            return null;
        }
        return settings.getItems().stream().filter(item -> MiscUtil.equals((Object)item.getGds(), (Object)gds)).map(getValue).findFirst().orElse(null);
    }

    public static String getBlankOwnerCode(GdsName gds) {
        EntityReference<Organization> blankOwnerRef = CommonRailwayHelper.getBlankOwner(gds);
        EntityContainer blankOwnerCtr = EntityStorage.get().resolve(blankOwnerRef);
        return blankOwnerCtr == null ? null : ((Organization)blankOwnerCtr.getEntity()).getCode();
    }
}

