/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductIndex;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Arrays;
import java.util.List;

public class RailwayProductDupesHelper {
    public static SearchQuery createSearchQuery(RailwayProduct product, Traveller traveller, SearchCriterion ... addCriterions) throws Exception {
        RailwaySegment segment = (RailwaySegment)CollectionUtil.head((Iterable)product.getSegments());
        Reservation reservation = product.getReservation();
        String routeLine = RailwayProductHelper.getRouteString(product);
        SearchQuery searchQuery = new SearchQuery();
        List searchQueryCriterions = searchQuery.getCriteria().getCriterions();
        searchQueryCriterions.add(SearchCriterion.eq((String)RailwayProductIndex.Property.nextProductUid.name(), null));
        searchQueryCriterions.add(SearchCriterion.eq((String)RailwayProductIndex.Property.subagency.name(), (Object)reservation.getSubagency().getUid()));
        searchQueryCriterions.add(SearchCriterion.contains((String)RailwayProductIndex.Property.trainNumbers.name(), (Object)segment.getTrainNumber()));
        searchQueryCriterions.add(SearchCriterion.eq((String)RailwayProductIndex.Property.departureDate.name(), (Object)segment.getDepartureDate()));
        searchQueryCriterions.add(SearchCriterion.eq((String)RailwayProductIndex.Property.routeLine.name(), (Object)routeLine));
        searchQueryCriterions.add(SearchCriterion.contains((String)RailwayProductIndex.Property.travellerDocNumbers.name(), (Object)traveller.getPassport().getNumber()));
        searchQueryCriterions.addAll(Arrays.asList(addCriterions));
        return searchQuery;
    }
}

