/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Contractor;
import com.gridnine.xtrip.common.model.booking.CurrencyRate;
import com.gridnine.xtrip.common.model.booking.CurrencyRateType;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.CommissionProperties;
import com.gridnine.xtrip.common.model.booking.commission.FeeProperties;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayMcoProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProductFop;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.booking.railway.RailwayTax;
import com.gridnine.xtrip.common.model.booking.railway.ReservedSeat;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.OnCreateFopListener;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractRelationType;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.model.profile.PredefinedSalesChainType;
import com.gridnine.xtrip.common.model.profile.SalesChainDescription;
import com.gridnine.xtrip.common.model.system.CardVendor;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.ProductFopCategory;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayStationDictionaryHelper;
import com.gridnine.xtrip.common.railway.model.localization.routeLine.RailLocalizer;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.PersonalName;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class RailwayProductHelper {
    private static final String STATION_SEPARATOR = "-";
    private static final String ROUTE_SEPARATOR = " / ";
    private static final String UNKNOWN_STATION = "?";
    private static final String PASSENGER_SEPARATOR = " / ";
    private static final String UNKNOWN_PASSENGER = "?";
    private static final String UNKNOWN_SCN = "?";
    private static final String NAME_SEPARATOR = " ";
    private static final Map<VatBasisType, List<MiscUtil.Pair<Date, Double>>> rusVatRates = new HashMap<VatBasisType, List<MiscUtil.Pair<Date, Double>>>();
    private static final Map<VatBasisType, List<MiscUtil.Pair<Date, Double>>> kzVatRates = new HashMap<VatBasisType, List<MiscUtil.Pair<Date, Double>>>();

    private static Map<VatBasisType, List<MiscUtil.Pair<Date, Double>>> getVatRates() {
        if (SystemHelper.isKazakhInstallation()) {
            return kzVatRates;
        }
        return rusVatRates;
    }

    public static double getVatRate(VatBasisType type, Date date) {
        return (Double)RailwayProductHelper.getVatRates().get(type).stream().reduce(new MiscUtil.Pair(null, (Object)MiscUtil.guarded((BigDecimal)DictHelper.getDefaultVat((Date)date)).doubleValue()), (reduce, item) -> MiscUtil.compare((Date)((Date)item.getFirst()), (Date)((Date)reduce.getFirst())) >= 0 && MiscUtil.compare((Date)((Date)item.getFirst()), (Date)date) <= 0 ? item : reduce).getSecond();
    }

    public static BigDecimal calculateVat(BigDecimal total, double rate) {
        return total.multiply(BigDecimal.valueOf(rate)).divide(BigDecimal.valueOf(100L).add(BigDecimal.valueOf(rate)), 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal calculateSegmentsFare(Collection<RailwaySegment> segments) {
        BigDecimal segmentsFare = null;
        for (RailwaySegment segment : segments) {
            if (segment.getEquivalentFare() == null) continue;
            segmentsFare = segmentsFare != null ? segmentsFare.add(segment.getEquivalentFare()) : segment.getEquivalentFare();
        }
        return segmentsFare;
    }

    public static BigDecimal calculateSegmentsVat(Collection<RailwaySegment> segments) {
        BigDecimal segmentsVat = null;
        for (RailwaySegment segment : segments) {
            if (segment.getEquivalentVAT() == null) continue;
            segmentsVat = segmentsVat != null ? segmentsVat.add(segment.getEquivalentVAT()) : segment.getEquivalentVAT();
        }
        return segmentsVat;
    }

    public static BigDecimal calculateSegmentsFare(RailwayProduct product) {
        return RailwayProductHelper.calculateSegmentsFare(product.getSegments());
    }

    public static BigDecimal calculateSegmentsVat(RailwayProduct product) {
        return RailwayProductHelper.calculateSegmentsVat(product.getSegments());
    }

    public static BigDecimal calculateReservedSeatsFare(Collection<ReservedSeat> reservedSeats) {
        BigDecimal reservedSeatsFare = null;
        for (ReservedSeat reservedSeat : reservedSeats) {
            reservedSeatsFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{reservedSeatsFare, MiscUtil.sub((BigDecimal)reservedSeat.getEquivalentFare(), (BigDecimal[])new BigDecimal[]{reservedSeat.getEquivalentDeduction()})});
        }
        return reservedSeatsFare;
    }

    public static BigDecimal calculateReservedSeatsVat(Collection<ReservedSeat> reservedSeats) {
        BigDecimal reservedSeatsVat = null;
        for (ReservedSeat reservedSeat : reservedSeats) {
            reservedSeatsVat = MiscUtil.sum((BigDecimal[])new BigDecimal[]{reservedSeatsVat, MiscUtil.sub((BigDecimal)reservedSeat.getEquivalentVAT(), (BigDecimal[])new BigDecimal[]{reservedSeat.getEquivalentDeductionVAT()})});
        }
        return reservedSeatsVat;
    }

    public static BigDecimal calculateReservedSeatsFare(RailwayProduct product) {
        return RailwayProductHelper.calculateReservedSeatsFare(product.getReservedSeats());
    }

    public static BigDecimal calculateReservedSeatsVat(RailwayProduct product) {
        return RailwayProductHelper.calculateReservedSeatsVat(product.getReservedSeats());
    }

    public static BigDecimal calculateTaxesFare(Collection<RailwayTax> taxes) {
        BigDecimal taxesAmount = null;
        for (RailwayTax tax : taxes) {
            if (tax.getEquivalentFare() == null) continue;
            taxesAmount = taxesAmount != null ? taxesAmount.add(tax.getEquivalentFare()) : tax.getEquivalentFare();
        }
        return taxesAmount;
    }

    public static BigDecimal calculateTaxesVat(Collection<RailwayTax> taxes) {
        BigDecimal taxesVat = null;
        for (RailwayTax tax : taxes) {
            if (tax.getEquivalentVAT() == null) continue;
            taxesVat = taxesVat != null ? taxesVat.add(tax.getEquivalentVAT()) : tax.getEquivalentVAT();
        }
        return taxesVat;
    }

    public static BigDecimal calculateTaxesFare(RailwayProduct product) {
        return RailwayProductHelper.calculateTaxesFare(product.getTaxes());
    }

    public static BigDecimal calculateTaxesVat(RailwayProduct product) {
        return RailwayProductHelper.calculateTaxesVat(product.getTaxes());
    }

    public static BigDecimal calculateTotalEquivalentFare(RailwayProduct product) {
        BigDecimal penalty;
        BigDecimal totalTaxesFare;
        BigDecimal serviceEquivalentFare;
        BigDecimal totalEquivalentFare = null;
        BigDecimal tariffEquivalentFare = product.getEquivalentFare();
        if (tariffEquivalentFare != null) {
            totalEquivalentFare = tariffEquivalentFare;
        }
        if ((serviceEquivalentFare = product.getServiceFare()) != null) {
            BigDecimal bigDecimal = totalEquivalentFare = totalEquivalentFare == null ? serviceEquivalentFare : totalEquivalentFare.add(serviceEquivalentFare);
        }
        if ((totalTaxesFare = RailwayProductHelper.calculateTaxesFare(product)) != null) {
            BigDecimal bigDecimal = totalEquivalentFare = totalEquivalentFare == null ? totalTaxesFare : totalEquivalentFare.add(totalTaxesFare);
        }
        if ((penalty = product.getPenalty()) != null) {
            totalEquivalentFare = totalEquivalentFare == null ? penalty.negate() : totalEquivalentFare.subtract(penalty);
        }
        return totalEquivalentFare;
    }

    public static BigDecimal calculateTotalEquivalentVat(RailwayProduct product) {
        BigDecimal penaltyVat;
        BigDecimal serviceEquivalentVat;
        BigDecimal totalEquivalentVat = null;
        BigDecimal tariffEquivalentVat = product.getEquivalentVAT();
        if (tariffEquivalentVat != null) {
            totalEquivalentVat = tariffEquivalentVat;
        }
        if ((serviceEquivalentVat = product.getServiceVAT()) != null) {
            BigDecimal bigDecimal = totalEquivalentVat = totalEquivalentVat == null ? serviceEquivalentVat : totalEquivalentVat.add(serviceEquivalentVat);
        }
        if ((penaltyVat = product.getPenaltyVAT()) != null) {
            totalEquivalentVat = totalEquivalentVat == null ? penaltyVat.negate() : totalEquivalentVat.subtract(penaltyVat);
        }
        return totalEquivalentVat;
    }

    public static BigDecimal calculateFOPsValue(Collection<RailwayProductFop> fops, boolean includeFeeFops) {
        BigDecimal fopsValue = null;
        for (RailwayProductFop fop : fops) {
            if (!includeFeeFops && !fop.getCommissions().isEmpty() || fop.getAmount() == null || fop.getAmount().getValue() == null) continue;
            fopsValue = fopsValue != null ? fopsValue.add(fop.getAmount().getValue()) : fop.getAmount().getValue();
        }
        return fopsValue;
    }

    public static BigDecimal calculateVendorFOPsValue(RailwayProduct product, boolean includeFeeFops) {
        return RailwayProductHelper.calculateFOPsValue(RailwayProductHelper.getVendorFops(product), includeFeeFops);
    }

    public static BigDecimal calculateClientFOPsValue(RailwayProduct product, boolean includeFeeFops) {
        return RailwayProductHelper.calculateFOPsValue(RailwayProductHelper.getClientFops(product), includeFeeFops);
    }

    public static BigDecimal calculateSubagentFOPsValue(RailwayProduct product, boolean includeFeeFops) {
        return RailwayProductHelper.calculateFOPsValue(RailwayProductHelper.getSubagentFops(product, false), includeFeeFops);
    }

    public static BigDecimal calculateCommissionValue(Collection<GeneralProductCommission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> cls, GeneralProductHelper.CommissionType commissionType) throws Exception {
        BigDecimal commissionValue = null;
        block5: for (GeneralProductCommission commision : commissions) {
            if (contractType == null || commision.getContractType() != contractType || commision.getEquivalentAmount() == null || cls != null && (commision.getCommissionProperties() != null && !cls.getName().equals(commision.getCommissionProperties().getType().getName()) || commision.getCommissionProperties() == null && !CommissionProperties.class.getName().equals(cls.getName()))) continue;
            if (commision.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commision.getCommissionProperties().getType().getName())) {
                EntityContainer ctr = EntityStorage.get().resolve(commision.getCommissionProperties());
                switch (commissionType) {
                    case STANDARD: {
                        if (ctr == null || !((CommissionProperties)ctr.getEntity()).isBspCommission() && !((CommissionProperties)ctr.getEntity()).isBonus()) break;
                        continue block5;
                    }
                    case BSP: {
                        if (ctr != null && ((CommissionProperties)ctr.getEntity()).isBspCommission()) break;
                        continue block5;
                    }
                    case BONUS: {
                        if (ctr != null && ((CommissionProperties)ctr.getEntity()).isBonus()) break;
                        continue block5;
                    }
                }
            }
            commissionValue = commissionValue != null ? commissionValue.add(commision.getEquivalentAmount()) : commision.getEquivalentAmount();
        }
        return commissionValue;
    }

    public static Double calculateCommissionRate(Collection<GeneralProductCommission> commissions, ContractType contractType, Class<? extends BaseCommissionProperties> cls, GeneralProductHelper.CommissionType commissionType) throws Exception {
        block5: for (GeneralProductCommission commission : commissions) {
            if (contractType == null || commission.getContractType() != contractType || commission.getRate() == null || cls != null && (commission.getCommissionProperties() != null && !cls.getName().equals(commission.getCommissionProperties().getType().getName()) || commission.getCommissionProperties() == null && !CommissionProperties.class.getName().equals(cls.getName()))) continue;
            if (commission.getCommissionProperties() != null && CommissionProperties.class.getName().equals(commission.getCommissionProperties().getType().getName())) {
                EntityContainer ctr = EntityStorage.get().resolve(commission.getCommissionProperties());
                switch (commissionType) {
                    case STANDARD: {
                        if (ctr == null || !((CommissionProperties)ctr.getEntity()).isBspCommission() && !((CommissionProperties)ctr.getEntity()).isBonus()) break;
                        continue block5;
                    }
                    case BSP: {
                        if (ctr != null && ((CommissionProperties)ctr.getEntity()).isBspCommission()) break;
                        continue block5;
                    }
                    case BONUS: {
                        if (ctr != null && ((CommissionProperties)ctr.getEntity()).isBonus()) break;
                        continue block5;
                    }
                }
            }
            return commission.getRate();
        }
        return null;
    }

    public static BigDecimal calculateTotalEquivalentFop(Collection<RailwayProductFop> fops, String equivalentCurrencyCode, CurrencyRateType currencyRateType, Date date, EntityReference<Organization> supplier) {
        BigDecimal totalEquivalentFop = null;
        Collection<Money> totalFops = RailwayProductHelper.calculateTotalFops(fops);
        for (Money money : totalFops) {
            BigDecimal amount = money.getValue();
            String currency = money.getCurrency();
            if (!TextUtil.isSame((String)currency, (String)equivalentCurrencyCode)) {
                CurrencyRate currencyRate = DictHelper.findCurrencyRate((String)currency, (Date)date, (CurrencyRateType)currencyRateType, null, supplier);
                if (currencyRate == null) continue;
                amount = amount.multiply(BigDecimal.valueOf(currencyRate.getRate()));
            }
            totalEquivalentFop = totalEquivalentFop != null ? totalEquivalentFop.add(amount) : amount;
        }
        return totalEquivalentFop;
    }

    public static Collection<Money> calculateTotalFops(Collection<RailwayProductFop> fops) {
        HashMap<String, Money> totalFops = new HashMap<String, Money>();
        for (RailwayProductFop fop : fops) {
            if (fop.getAmount() == null) continue;
            BigDecimal amount = fop.getAmount().getValue();
            String currency = fop.getAmount().getCurrency();
            if (amount == null || currency == null) continue;
            Money money = (Money)totalFops.get(currency);
            if (money == null) {
                money = new Money();
                totalFops.put(currency, money);
                money.setValue(amount);
                money.setCurrency(currency);
                continue;
            }
            money.setValue(money.getValue().add(amount));
        }
        return totalFops.values();
    }

    public static boolean isHasVat(RailwayProduct product) {
        if (product == null || RailwayProductHelper.isSuburbanTrain(product)) {
            return false;
        }
        RailwayProduct sellProduct = product;
        if (product.getStatus() == ProductStatus.REFUND && (sellProduct = product.getPreviousProduct()) == null) {
            sellProduct = product;
        }
        return RailwayProductHelper.getTransportationType(sellProduct) == TransportationType.DOMESTIC;
    }

    public static boolean isHasPenaltyVat(RailwayProduct product) {
        return !SystemHelper.isKazakhInstallation() && !RailwayProductHelper.isSuburbanTrain(product) || RailwayProductHelper.isHasVat(product);
    }

    private static boolean isSuburbanTrain(RailwayProduct product) {
        return product.getSegments().stream().anyMatch(it -> RailwayProductHelper.isSuburbanTrainNumber(it.getTrainNumber()));
    }

    private static boolean isSuburbanTrainNumber(String trainNumber) {
        if (TextUtil.isBlank((String)trainNumber)) {
            return false;
        }
        try {
            int tn = Integer.parseInt(trainNumber);
            return tn > 7000 && tn < 8000;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getShortNameString(RailwayProduct product) {
        StringBuilder productName = new StringBuilder();
        productName.append("\u0416/\u0414 \u0411\u0438\u043b\u0435\u0442");
        String systemNumberPrefix = product.getSystemNumberPrefix();
        String systemNumber = product.getSystemNumber();
        ProductStatus status = product.getStatus();
        if (systemNumberPrefix != null || systemNumber != null) {
            productName.append(NAME_SEPARATOR);
            if (systemNumberPrefix != null) {
                productName.append(systemNumberPrefix);
            }
            if (systemNumber != null) {
                productName.append(systemNumber);
            }
        }
        if (status != null) {
            productName.append(NAME_SEPARATOR);
            productName.append(status);
        }
        return productName.toString();
    }

    public static String getNameString(RailwayProduct product) {
        return RailwayProductHelper.getShortNameString(product) + NAME_SEPARATOR + RailwayProductHelper.getTravellersString(product, ", ");
    }

    public static String getShortRouteString(RailwayProduct product) {
        return RailwayProductHelper.getRouteString(product.getSegments(), true);
    }

    public static String getRouteString(RailwayProduct product) {
        return RailwayProductHelper.getRouteString(product.getSegments(), false);
    }

    public static String getRouteString(List<RailwaySegment> segments, boolean isShort) {
        StringBuilder routeString = new StringBuilder();
        String lastStationCode = null;
        DictionaryCache cache = DictionaryCache.get();
        for (RailwaySegment segment : segments) {
            String departureStationName = "?";
            String arriveStationName = "?";
            String departureStationCode = null;
            String arriveStationCode = null;
            RailwayStation departureStation = null;
            RailwayStation arriveStation = null;
            if (segment != null) {
                departureStation = (RailwayStation)cache.resolveReference(segment.getDepartureStation());
                arriveStation = (RailwayStation)cache.resolveReference(segment.getArriveStation());
            }
            if (departureStation != null) {
                departureStationName = isShort ? RailwayStationDictionaryHelper.getAnyShortName(departureStation) : departureStation.toString();
                departureStationCode = departureStation.getCode();
            }
            if (arriveStation != null) {
                arriveStationName = isShort ? RailwayStationDictionaryHelper.getAnyShortName(arriveStation) : arriveStation.toString();
                arriveStationCode = arriveStation.getCode();
            }
            if (routeString.length() == 0) {
                routeString.append(departureStationName);
            } else if (!TextUtil.isSame(lastStationCode, (String)departureStationCode)) {
                routeString.append(" / ");
                routeString.append(departureStationName);
            }
            if (!TextUtil.isSame((String)departureStationCode, (String)arriveStationCode)) {
                routeString.append(STATION_SEPARATOR);
                routeString.append(arriveStationName);
            }
            lastStationCode = arriveStationCode;
        }
        return routeString.toString();
    }

    public static String getRouteDescription(RailwayProduct product) {
        StringBuilder result = new StringBuilder();
        boolean first = true;
        for (RailwaySegment seg : product.getSegments()) {
            if (seg == null) continue;
            if (first) {
                first = false;
            } else {
                result.append(", ");
            }
            if (TextUtil.nonBlank((String)seg.getTrainNumber())) {
                result.append(seg.getTrainNumber());
            }
            result.append(NAME_SEPARATOR);
            RailwayStation departureStation = (RailwayStation)DictionaryCache.get().resolveReference(seg.getDepartureStation());
            if (departureStation != null) {
                result.append(departureStation);
            }
            result.append(" - ");
            RailwayStation arrivalStation = (RailwayStation)DictionaryCache.get().resolveReference(seg.getArriveStation());
            if (arrivalStation != null) {
                result.append(arrivalStation);
            }
            result.append(NAME_SEPARATOR);
            SimpleDateFormat f = new SimpleDateFormat("dd.MM.yyyy HH:mm");
            if (seg.getDepartureDate() != null) {
                result.append(f.format(seg.getDepartureDate()));
            }
            result.append(" - ");
            if (seg.getArriveDate() == null) continue;
            result.append(f.format(seg.getArriveDate()));
        }
        return result.toString();
    }

    public static RailwayStationReference getRailwayStationReference(DictionaryReference<RailwayStation> reference) {
        RailwayStation station = (RailwayStation)DictionaryCache.get().resolveReference(reference);
        if (station != null) {
            return station.toReference();
        }
        if (reference != null) {
            return new RailwayStationReference(reference.getCode());
        }
        return new RailwayStationReference("?");
    }

    public static List<String> getTravellersNames(RailwayProduct product) {
        return RailwayProductHelper.getTravellersNames(product.getPassengers());
    }

    public static List<String> getTravellersNames(List<Traveller> travellers) {
        ArrayList<String> passengerNames = new ArrayList<String>();
        for (Traveller passenger : travellers) {
            String passengerName = "?";
            if (passenger != null) {
                if (passenger.getPassport() != null && !TextUtil.isBlank((String)TextUtil.buildFullName((PersonalName)passenger.getPassport()))) {
                    passengerName = TextUtil.buildFullName((PersonalName)passenger.getPassport());
                } else if (!TextUtil.isBlank((String)passenger.getName())) {
                    passengerName = passenger.getName();
                }
            }
            passengerNames.add(passengerName);
        }
        return passengerNames;
    }

    public static String getTravellersString(RailwayProduct product, String separator) {
        return RailwayProductHelper.getTravellersString(product.getPassengers(), separator);
    }

    public static String getTravellersString(List<Traveller> travellers, String separator) {
        return RailwayProductHelper.getTravellersNames(travellers).stream().collect(Collectors.joining(TextUtil.isBlank((String)separator) ? " / " : separator));
    }

    public static String getDepartureDateString(RailwayProduct product) {
        if (product.getSegments().isEmpty()) {
            return "?";
        }
        Date departureDate = ((RailwaySegment)product.getSegments().get(0)).getDepartureDate();
        if (departureDate == null) {
            return "?";
        }
        return LocaleManager.get().getCurrentLocaleData().getDateFormat().format(departureDate);
    }

    public static Date getFirstDepartureDate(RailwayProduct product) {
        if (product.getSegments().isEmpty()) {
            return null;
        }
        return ((RailwaySegment)product.getSegments().get(0)).getDepartureDate();
    }

    public static Date getFirstLocalDepartureDate(RailwayProduct product) {
        if (product.getSegments().isEmpty()) {
            return null;
        }
        return ((RailwaySegment)product.getSegments().get(0)).getLocalDepartureDate();
    }

    public static Date getLastArrivalDate(RailwayProduct product) {
        List segments = product.getSegments();
        if (segments.isEmpty()) {
            return null;
        }
        return ((RailwaySegment)segments.get(segments.size() - 1)).getArriveDate();
    }

    public static List<String> getSCNs(RailwayProduct product) {
        ArrayList<String> scns = new ArrayList<String>();
        scns.add(product.getScn() != null ? product.getScn() : "?");
        for (ReservedSeat reservedSeat : product.getReservedSeats()) {
            String scn = "?";
            if (reservedSeat != null && reservedSeat.getScn() != null) {
                scn = reservedSeat.getScn();
            }
            scns.add(scn);
        }
        return scns;
    }

    public static TransportationType getTransportationType(DictionaryReference<RailwayStation> departureStation, DictionaryReference<RailwayStation> arriveStation) {
        RailwaySegment segment = new RailwaySegment();
        segment.setDepartureStation(departureStation);
        segment.setArriveStation(arriveStation);
        return RailwayProductHelper.getTransportationType(Collections.singletonList(segment));
    }

    public static TransportationType getTransportationType(RailwayProduct product) {
        if (product == null) {
            return null;
        }
        return RailwayProductHelper.getTransportationType(product.getSegments());
    }

    public static TransportationType getTransportationType(List<RailwaySegment> segments) {
        boolean domestic = false;
        boolean international = false;
        for (RailwaySegment segment : segments) {
            DictionaryReference departureLocation = segment.getDepartureStation();
            DictionaryReference arriveLocation = segment.getArriveStation();
            Country departureCountry = RailwayProductDictionaryHelper.getCountry((DictionaryReference<RailwayStation>)departureLocation);
            Country arriveCountry = RailwayProductDictionaryHelper.getCountry((DictionaryReference<RailwayStation>)arriveLocation);
            if (arriveCountry == null || departureCountry == null) continue;
            if (departureCountry.isDomestic() && arriveCountry.isDomestic()) {
                domestic = true;
                continue;
            }
            international = true;
        }
        if (domestic && international) {
            return TransportationType.COMBINED;
        }
        if (domestic) {
            return TransportationType.DOMESTIC;
        }
        if (international) {
            return TransportationType.INTERNATIONAL;
        }
        return TransportationType.NONE;
    }

    public static ServiceLocationType getServiceLocationType(RailwayProduct product) {
        return RailwayProductHelper.getTransportationType(product) == TransportationType.DOMESTIC ? ServiceLocationType.DOMESTIC : ServiceLocationType.INTERNATIONAL;
    }

    public static String getTicketSeries(RailwayProduct product) {
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(product.getBlankType());
        String ticketSeries = blankType != null ? blankType.getName() : product.getSystemNumber();
        return ticketSeries;
    }

    public static RailwayProduct clone(RailwayProduct product) throws Exception {
        RailwayProduct clone = new RailwayProduct();
        RailwayProductHelper.copy(product, clone, true);
        return clone;
    }

    public static RailwayProduct clone(RailwayProduct product, boolean keepReservation) throws Exception {
        RailwayProduct clone = new RailwayProduct();
        RailwayProductHelper.copy(product, clone, keepReservation);
        return clone;
    }

    public static void copy(RailwayProduct source, RailwayProduct target, boolean keepReservation) throws Exception {
        if (source == null || target == null) {
            return;
        }
        RailwayProduct sourcePrevProduct = source.getPreviousProduct();
        RailwayProduct sourceNextProduct = source.getNextProduct();
        RailwayProduct targetPrevProduct = target.getPreviousProduct();
        RailwayProduct targetNextProduct = target.getNextProduct();
        List targetRelatedProducts = target.getRelatedProducts();
        source.setPreviousProduct(null);
        source.setNextProduct(null);
        Reservation reservation = source.getReservation();
        ArrayList travellers = new ArrayList(source.getPassengers());
        ArrayList passengerTypes = new ArrayList(source.getPassengerTypes());
        source.setReservation(null);
        source.getPassengers().clear();
        source.getPassengerTypes().clear();
        ArrayList relatedProducts = new ArrayList(source.getRelatedProducts());
        source.getRelatedProducts().clear();
        EntityReference agent = source.getCashier();
        EntityReference salesPoint = source.getSalesPoint();
        EntityReference<Organization> subagency = RailwayProductHelper.getSubagency(source);
        EntityReference<Organization> agency = RailwayProductHelper.getAgency(source);
        EntityReference<Organization> supplier = RailwayProductHelper.getSupplier((BaseProduct)source);
        HashSet excludedUids = new HashSet();
        travellers.forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData sourceStatisticalData = source.getStatisticalData();
        if (sourceStatisticalData != null) {
            sourceStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        StatisticalData targetStatisticalData = (StatisticalData)XCloneHelper.clone((XCloneable)source.getStatisticalData(), (boolean)true, excludedUids);
        source.setStatisticalData(null);
        XCloneModelHelper.copy((BaseEntity)source, (BaseEntity)target, (boolean)true);
        source.getRelatedProducts().addAll(relatedProducts);
        target.setReservation(reservation);
        source.setReservation(reservation);
        target.getPassengers().addAll(travellers);
        source.getPassengers().addAll(travellers);
        target.getPassengerTypes().addAll(passengerTypes);
        source.getPassengerTypes().addAll(passengerTypes);
        source.setPreviousProduct(sourcePrevProduct);
        source.setNextProduct(sourceNextProduct);
        source.setStatisticalData(sourceStatisticalData);
        if (keepReservation && source.getReservation() != null && !source.getReservation().getProducts().contains(target)) {
            source.getReservation().getProducts().add(target);
        }
        target.setPreviousProduct(targetPrevProduct);
        target.setNextProduct(targetNextProduct);
        target.setStatisticalData(targetStatisticalData);
        target.getRelatedProducts().clear();
        target.getRelatedProducts().addAll(targetRelatedProducts);
        target.setIssueDate(source.getIssueDate());
        target.setSystemNumber(source.getSystemNumber());
        target.setCashier(agent);
        target.setSalesPoint(salesPoint);
        RailwayProductHelper.setSubagency((BaseTicketProduct)target, subagency);
        RailwayProductHelper.setAgency((BaseTicketProduct)target, agency);
        RailwayProductHelper.setSupplier((BaseTicketProduct)target, supplier);
        List<RailwayProductFop> targetClientFops = RailwayProductHelper.getClientFops(target);
        List<RailwayProductFop> sourceClientFops = RailwayProductHelper.getClientFops(source);
        for (int i = 0; i < targetClientFops.size(); ++i) {
            targetClientFops.get(i).setAgent(sourceClientFops.get(i).getAgent());
        }
        List<RailwayProductFop> targetVendorFops = RailwayProductHelper.getVendorFops(target);
        List<RailwayProductFop> sourceVendorFops = RailwayProductHelper.getVendorFops(source);
        for (int i = 0; i < targetVendorFops.size(); ++i) {
            targetVendorFops.get(i).setAgent(sourceVendorFops.get(i).getAgent());
        }
        target.getShipments().clear();
        target.getPrepaymentDocuments().clear();
        target.getFopDetalizations().clear();
    }

    public static List<RailwayMcoProduct> getMcoByRelatedProduct(RailwayProduct product) {
        return BookingStreamHelper.getProductsStream((Reservation)product.getReservation(), RailwayMcoProduct.class).filter(mco -> mco.getRelatedProducts().contains(product)).collect(Collectors.toList());
    }

    public static RailwayMcoProduct buildRailwayMcoProduct(RailwayProduct product, boolean keepReservation) throws Exception {
        RailwayMcoProduct result = new RailwayMcoProduct();
        if (keepReservation) {
            BookingHelper.addProduct((Reservation)product.getReservation(), (BaseProduct)result);
        }
        result.setIssueDate(new Date());
        result.setBlankOwnerRef(product.getBlankOwnerRef());
        result.setBlankType(product.getBlankType());
        result.setBranch(product.getBranch());
        result.setEticket(product.isEticket());
        result.setGdsCurrency(product.getGdsCurrency());
        result.setProvider(product.getProvider());
        result.setTicketType(product.getTicketType());
        result.setValidatorCode(product.getValidatorCode());
        result.setValidatorRef(product.getValidatorRef());
        result.getSegments().addAll(XCloneHelper.cloneList((List)product.getSegments()));
        result.getPassengers().addAll(product.getPassengers());
        result.getPassengerTypes().addAll(product.getPassengerTypes());
        result.getRelatedProducts().add(product);
        result.setSalesPoint(product.getSalesPoint());
        RailwayProductHelper.setSubagency((BaseTicketProduct)result, RailwayProductHelper.getSubagency(product));
        RailwayProductHelper.setAgency((BaseTicketProduct)result, RailwayProductHelper.getAgency(product));
        RailwayProductHelper.setSupplier((BaseTicketProduct)result, RailwayProductHelper.getSupplier((BaseProduct)product));
        result.setSalesChain(RailwayProductHelper.getSalesChain((BaseProduct)product));
        return result;
    }

    public static CardVendor getCreditCardVendor(Collection<RailwayProductFop> fops) {
        for (RailwayProductFop fop : fops) {
            if (fop.getCard() == null || fop.getCard().getVendor() == null) continue;
            return fop.getCard().getVendor();
        }
        return null;
    }

    public static boolean isServiceFop(RailwayProductFop fop) {
        boolean hasNotHiddenFee = false;
        for (GeneralProductCommission comm : fop.getCommissions()) {
            EntityContainer ctr = EntityStorage.get().resolve(comm.getCommissionProperties());
            if (ctr == null || !(ctr.getEntity() instanceof FeeProperties)) {
                hasNotHiddenFee = true;
                break;
            }
            FeeProperties feeProp = (FeeProperties)ctr.getEntity();
            if (feeProp.isHidden()) continue;
            hasNotHiddenFee = true;
        }
        return !hasNotHiddenFee;
    }

    public static FopType getFopType(RailwayProductFop fop) {
        FopType fopType = null;
        if (RailwayProductHelper.isServiceFop(fop)) {
            fopType = FopType.PRODUCT;
        } else {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (fopType == null && commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && GeneralProductHelper.serviceFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.SERVICE;
                }
                if (commission.getCommissionProperties() != null && commission.getCommissionProperties().getType() != null && GeneralProductHelper.paymentFeePropertyTypes.contains(commission.getCommissionProperties().getType())) {
                    fopType = FopType.PAYMENT;
                    break;
                }
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !GeneralProductHelper.discountDiscountPropertyTypes.contains(commission.getCommissionProperties().getType())) continue;
                fopType = FopType.DISCOUNT;
                break;
            }
        }
        return fopType;
    }

    public static void updateFops(RailwayProduct product) {
        RailwayProductHelper.updateProductFops(product, false);
        RailwayProductHelper.updateFeeFops(product);
        RailwayProductHelper.updateDiscountFops(product);
    }

    public static void updateFops(RailwayProduct product, boolean addZeroProductFop) {
        RailwayProductHelper.updateProductFops(product, addZeroProductFop);
        RailwayProductHelper.updateFeeFops(product);
        RailwayProductHelper.updateDiscountFops(product);
    }

    public static void updateProductFops(RailwayProduct product) {
        RailwayProductHelper.updateProductFops(product, false);
    }

    public static void updateProductFops(RailwayProduct product, boolean addZeroFop) {
        boolean isFareFopsRelevant = RailwayProductHelper.isFareFopsRelevant(product);
        GeneralProductHelper.RelationData last = new GeneralProductHelper.RelationData((BaseProduct)product);
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(product)) {
            boolean exchange;
            GeneralProductHelper.updateServiceData((BaseProduct)product, (BaseContractRelationData)relation, (GeneralProductHelper.RelationData)last);
            last = new GeneralProductHelper.RelationData((BaseContractRelationData)relation, last);
            if (!isFareFopsRelevant) {
                relation.getFops().removeIf(f -> GeneralProductHelper.productFopTypes.contains(RailwayProductHelper.getFopType(f)));
                continue;
            }
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            BigDecimal totalEquivalentFare = relation.getServiceData().getTotalPrice();
            List fops = relation.getFops();
            for (RailwayProductFop fop : RailwayProductHelper.filterFopsByFopTypes(fops, GeneralProductHelper.productFopTypes)) {
                if (fop.getAmount() == null) {
                    Money money = new Money();
                    money.setValue(BigDecimal.ZERO);
                    money.setCurrency(currency);
                    fop.setAmount(money);
                    continue;
                }
                if (fop.getAmount().getValue() == null) {
                    fop.getAmount().setValue(BigDecimal.ZERO);
                }
                if (fop.getAmount().getCurrency() != null) continue;
                fop.getAmount().setCurrency(currency);
            }
            Collection<RailwayProductFop> ticketPaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.TICKET), null, null);
            fops.removeAll(ticketPaymentTypeFops);
            HashSet<PaymentType> allPaymentTypesExceptTicket = new HashSet<PaymentType>(Arrays.asList(PaymentType.values()));
            allPaymentTypesExceptTicket.remove(PaymentType.TICKET);
            boolean bl = exchange = product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.EXCHANGE;
            if (exchange) {
                RailwayProductContractRelationData prevRelation = RailwayProductHelper.findContractRelation(RailwayProductHelper.getContractRelations(product.getPreviousProduct()), (EntityReference<ContractRelationDescription>)relation.getDescription());
                Collection<RailwayProductFop> filteredVendorFops = RailwayProductHelper.filterFops(prevRelation != null ? prevRelation.getFops() : null, GeneralProductHelper.productFopTypes, null, null, null);
                Iterator<RailwayProductFop> filteredVendorTotalEquivalentFop = MiscUtil.minimum((BigDecimal[])new BigDecimal[]{RailwayProductHelper.calculateTotalEquivalentFop(filteredVendorFops, currency, FinanceHelper.getCurrencyRateType((String)currency), product.getPreviousProduct().getIssueDate(), (EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)product.getPreviousProduct())), totalEquivalentFare});
                if (ticketPaymentTypeFops.isEmpty()) {
                    RailwayProductFop ticketPaymentTypeVendorFop = RailwayProductHelper.createFop(product, PaymentType.TICKET, filteredVendorTotalEquivalentFop, currency, contractType);
                    fops.add(ticketPaymentTypeVendorFop);
                } else {
                    Money money = new Money();
                    money.setValue(filteredVendorTotalEquivalentFop);
                    money.setCurrency(currency);
                    RailwayProductFop ticketPaymentTypeVendorFop = ticketPaymentTypeFops.iterator().next();
                    ticketPaymentTypeVendorFop.setAmount(money);
                    fops.add(ticketPaymentTypeVendorFop);
                }
            }
            Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.hiddenCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (RailwayProductFop productFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> productCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : productFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission productCommission = (GeneralProductCommission)CollectionUtil.find((Iterable)commissions, (String)fopCommission.getUid());
                    if (productCommission == null) continue;
                    productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), MiscUtil.negate((BigDecimal)productCommission.getEquivalentAmount())}));
                    if (productFop.getAmount().getValue() != null && productFop.getAmount().getValue().compareTo(BigDecimal.ZERO) < 0) {
                        productFop.getAmount().setValue(BigDecimal.ZERO);
                    }
                    productCommissions.add(productCommission);
                }
                productFop.getCommissions().clear();
                productFop.getCommissions().addAll(productCommissions);
            }
            RailwayProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.productFopTypes, currency, contractType, null);
            for (RailwayProductFop productFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)productFop.getCommissions());
                productFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{productFop.getAmount().getValue(), commissionsEquivalentValue}));
            }
            BigDecimal difference = totalEquivalentFare;
            Collection<RailwayProductFop> productFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, null, null, null);
            BigDecimal totalEquivalentFopValue = RailwayProductHelper.calculateTotalEquivalentFop(productFops, currency, FinanceHelper.getCurrencyRateType((String)currency), product.getIssueDate(), (EntityReference<Organization>)GeneralProductHelper.getSupplier((BaseProduct)product));
            if ((difference = MiscUtil.sum((BigDecimal[])new BigDecimal[]{difference, MiscUtil.negate((BigDecimal)(totalEquivalentFopValue = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalEquivalentFopValue, MiscUtil.negate((BigDecimal)RailwayProductHelper.calculateHiddenFeesEquivalentValue(productFops))})))})).compareTo(BigDecimal.ZERO) == 0 && !RailwayProductHelper.filterFopsByPaymentTypes(productFops, allPaymentTypesExceptTicket).isEmpty()) continue;
            Collection<RailwayProductFop> cashPaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.CASH), Collections.singleton(currency), null);
            if (!cashPaymentTypeFops.isEmpty()) {
                RailwayProductFop cashPaymentTypeFop = cashPaymentTypeFops.iterator().next();
                cashPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{cashPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<RailwayProductFop> invoicePaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, Collections.singleton(PaymentType.INVOICE), Collections.singleton(currency), null);
            if (!invoicePaymentTypeFops.isEmpty()) {
                RailwayProductFop invoicePaymentTypeFop = invoicePaymentTypeFops.iterator().next();
                invoicePaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{invoicePaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            Collection<RailwayProductFop> anyPaymentTypeFops = RailwayProductHelper.filterFops(fops, GeneralProductHelper.productFopTypes, allPaymentTypesExceptTicket, Collections.singleton(currency), null);
            if (!anyPaymentTypeFops.isEmpty()) {
                RailwayProductFop anyPaymentTypeFop = anyPaymentTypeFops.iterator().next();
                anyPaymentTypeFop.getAmount().setValue(MiscUtil.sum((BigDecimal[])new BigDecimal[]{anyPaymentTypeFop.getAmount().getValue(), difference}));
                continue;
            }
            RailwayProductFop cashPaymentTypeFop = RailwayProductHelper.createFop(product, PaymentType.CASH, difference, currency, contractType);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static void updateFeeFops(RailwayProduct product) {
        boolean separateSupplierFees = false;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null) {
            EntityContainer customerCtr = EntityStorage.get().resolve(product.getReservation().getBookingFile().getCustomerProfile());
            separateSupplierFees = customerCtr != null && ((Organization)customerCtr.getEntity()).isSeparateSupplierFees();
        }
        RailwayProductContractRelationData prevRelation = null;
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(product)) {
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.feePropertyTypes, null, (Set)GeneralProductHelper.standardCommissionCategories);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (RailwayProductFop feeFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> feeCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : feeFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission feeCommission = (GeneralProductCommission)CollectionUtil.find((Iterable)commissions, (String)fopCommission.getUid());
                    if (feeCommission == null) continue;
                    feeCommissions.add(feeCommission);
                }
                if (feeCommissions.isEmpty()) {
                    fops.remove(feeFop);
                    continue;
                }
                feeFop.getCommissions().clear();
                feeFop.getCommissions().addAll(feeCommissions);
            }
            if (separateSupplierFees && prevRelation != null && !unusedCommissions.isEmpty()) {
                List prevCommissions = prevRelation.getCommissions();
                List<GeneralProductCommission> addUnusedCommissions = unusedCommissions.stream().filter(c -> GeneralProductHelper.isSupplierFee((GeneralProductCommission)c, (Collection)prevCommissions)).collect(Collectors.toList());
                unusedCommissions.removeAll(addUnusedCommissions);
                RailwayProductHelper.distributeCommissionsToFops(product, fops, addUnusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes, currency, contractType, prevRelation.getCommissions());
            }
            RailwayProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.serviceFeePropertyTypes, GeneralProductHelper.serviceFeeFopTypes, currency, contractType, separateSupplierFees && prevRelation != null ? prevRelation.getCommissions() : null);
            prevRelation = relation;
            RailwayProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.paymentFeePropertyTypes, GeneralProductHelper.paymentFeeFopTypes, currency, contractType, null);
            for (RailwayProductFop feeFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.feeFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)feeFop.getCommissions());
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(currency);
                feeFop.setAmount(money);
            }
        }
    }

    public static void updateDiscountFops(RailwayProduct product) {
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(product)) {
            String currency = relation.getGeneralData().getCurrency() != null ? relation.getGeneralData().getCurrency().getCode() : DictHelper.getLocalCurrency();
            ContractType contractType = GeneralProductHelper.getContractType((EntityReference)relation.getDescription());
            List fops = relation.getFops();
            Collection commissions = GeneralProductHelper.filterCommissions((Collection)relation.getCommissions(), (Set)GeneralProductHelper.discountPropertyTypes, null, null);
            ArrayList<GeneralProductCommission> unusedCommissions = new ArrayList<GeneralProductCommission>(commissions);
            for (RailwayProductFop discountFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                ArrayList<GeneralProductCommission> discountCommissions = new ArrayList<GeneralProductCommission>();
                for (GeneralProductCommission fopCommission : discountFop.getCommissions()) {
                    if (!unusedCommissions.contains(fopCommission)) continue;
                    unusedCommissions.remove(fopCommission);
                    GeneralProductCommission discountCommission = (GeneralProductCommission)CollectionUtil.find((Iterable)commissions, (String)fopCommission.getUid());
                    if (discountCommission == null) continue;
                    discountCommissions.add(discountCommission);
                }
                if (discountCommissions.isEmpty()) {
                    fops.remove(discountFop);
                    continue;
                }
                discountFop.getCommissions().clear();
                discountFop.getCommissions().addAll(discountCommissions);
            }
            RailwayProductHelper.distributeCommissionsToFops(product, fops, unusedCommissions, GeneralProductHelper.discountDiscountPropertyTypes, GeneralProductHelper.discountFopTypes, currency, contractType, null);
            for (RailwayProductFop discountFop : RailwayProductHelper.filterFops(fops, GeneralProductHelper.discountFopTypes, null, null, null)) {
                BigDecimal commissionsEquivalentValue = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)discountFop.getCommissions());
                commissionsEquivalentValue = MiscUtil.negate((BigDecimal)commissionsEquivalentValue);
                Money money = new Money();
                money.setValue(commissionsEquivalentValue);
                money.setCurrency(currency);
                discountFop.setAmount(money);
            }
        }
    }

    private static void distributeCommissionsToFops(RailwayProduct product, Collection<RailwayProductFop> fops, Collection<GeneralProductCommission> commissions, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, String currency, ContractType contractType, Collection<GeneralProductCommission> prevCommissions) {
        Collection filteredCommissions = GeneralProductHelper.filterCommissions(commissions, commissionProperties, null, null);
        if (filteredCommissions.isEmpty()) {
            return;
        }
        boolean done = RailwayProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.CASH), commissionProperties, fopTypes, currency, prevCommissions);
        if (!done) {
            done = RailwayProductHelper.distributeCommissionsToFops(fops, filteredCommissions, Collections.singleton(PaymentType.INVOICE), commissionProperties, fopTypes, currency, prevCommissions);
        }
        if (!done) {
            done = RailwayProductHelper.distributeCommissionsToFops(fops, filteredCommissions, null, commissionProperties, fopTypes, currency, prevCommissions);
        }
        if (!done) {
            RailwayProductFop cashPaymentTypeFop = RailwayProductHelper.createFop(product, PaymentType.CASH, BigDecimal.ZERO, currency, contractType);
            cashPaymentTypeFop.getCommissions().addAll(filteredCommissions);
            fops.add(cashPaymentTypeFop);
        }
    }

    private static boolean distributeCommissionsToFops(Collection<RailwayProductFop> fops, Collection<GeneralProductCommission> commissions, Set<PaymentType> paymentTypes, Set<Class<? extends BaseCommissionProperties>> commissionProperties, Set<FopType> fopTypes, String currency, Collection<GeneralProductCommission> prevCommissions) {
        Collection<RailwayProductFop> filteredFops = RailwayProductHelper.filterFops(fops, fopTypes, paymentTypes, Collections.singleton(currency), null);
        if (filteredFops.size() > 0) {
            RailwayProductFop filteredFop;
            if (null == prevCommissions) {
                filteredFop = filteredFops.iterator().next();
            } else {
                boolean supplierFee = !commissions.isEmpty() && GeneralProductHelper.isSupplierFee((GeneralProductCommission)commissions.iterator().next(), prevCommissions);
                filteredFop = filteredFops.stream().filter(f -> (!f.getCommissions().isEmpty() && GeneralProductHelper.isSupplierFee((GeneralProductCommission)((GeneralProductCommission)f.getCommissions().get(0)), (Collection)prevCommissions)) == supplierFee).findFirst().orElse(null);
                if (null == filteredFop) {
                    return false;
                }
            }
            filteredFop.getCommissions().addAll(commissions);
            return true;
        }
        return false;
    }

    private static RailwayProductFop createFop(RailwayProduct product, PaymentType paymentType, BigDecimal amount, String currency, ContractType contractType) {
        RailwayProductFop fop = new RailwayProductFop();
        fop.setType(paymentType);
        Money money = new Money();
        money.setValue(amount);
        money.setCurrency(currency);
        fop.setAmount(money);
        OnCreateFopListener.fire((BaseProduct)product, (Fop)fop, (ContractType)contractType);
        return fop;
    }

    public static BigDecimal calculateHiddenFeesEquivalentValue(Collection<RailwayProductFop> fops) {
        BigDecimal result = BigDecimal.ZERO;
        for (RailwayProductFop fop : fops) {
            result = result.add(GeneralProductHelper.calculateHiddenFeesEquivalentValue((Collection)fop.getCommissions()));
        }
        return result;
    }

    public static Collection<RailwayProductFop> filterFops(Collection<RailwayProductFop> fops, Set<FopType> fopTypes, Set<PaymentType> paymentTypes, Set<String> currencies, Set<Class<? extends BaseCommissionProperties>> properties) {
        return RailwayProductHelper.filterFopsByFopTypes(RailwayProductHelper.filterFopsByPaymentTypes(RailwayProductHelper.filterFopsByCurrencies(RailwayProductHelper.filterFopsByCommissionProperties(fops, properties), currencies), paymentTypes), fopTypes);
    }

    public static BigDecimal calculateCommissionsEquivalentValue(Collection<GeneralProductCommission> commissions) {
        BigDecimal value = null;
        for (GeneralProductCommission commission : commissions) {
            if (commission.getEquivalentAmount() == null) continue;
            value = value != null ? value.add(commission.getEquivalentAmount()) : commission.getEquivalentAmount();
        }
        return value;
    }

    private static Collection<RailwayProductFop> filterFopsByFopTypes(Collection<RailwayProductFop> fops, Set<FopType> fopTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (fopTypes == null) {
            return new ArrayList<RailwayProductFop>(fops);
        }
        ArrayList<RailwayProductFop> filteredFops = new ArrayList<RailwayProductFop>();
        for (RailwayProductFop fop : fops) {
            FopType fopType = RailwayProductHelper.getFopType(fop);
            if (!fopTypes.contains(fopType)) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<RailwayProductFop> filterFopsByPaymentTypes(Collection<RailwayProductFop> fops, Set<PaymentType> paymentTypes) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (paymentTypes == null) {
            return new ArrayList<RailwayProductFop>(fops);
        }
        ArrayList<RailwayProductFop> filteredFops = new ArrayList<RailwayProductFop>();
        for (RailwayProductFop fop : fops) {
            if (fop.getType() == null || !paymentTypes.contains(fop.getType())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<RailwayProductFop> filterFopsByCurrencies(Collection<RailwayProductFop> fops, Set<String> currencies) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (currencies == null) {
            return new ArrayList<RailwayProductFop>(fops);
        }
        ArrayList<RailwayProductFop> filteredFops = new ArrayList<RailwayProductFop>();
        for (RailwayProductFop fop : fops) {
            if (fop.getAmount() == null || fop.getAmount().getCurrency() == null || !currencies.contains(fop.getAmount().getCurrency())) continue;
            filteredFops.add(fop);
        }
        return filteredFops;
    }

    private static Collection<RailwayProductFop> filterFopsByCommissionProperties(Collection<RailwayProductFop> fops, Set<Class<? extends BaseCommissionProperties>> properties) {
        if (fops == null) {
            return Collections.emptyList();
        }
        if (properties == null) {
            return new ArrayList<RailwayProductFop>(fops);
        }
        ArrayList<RailwayProductFop> filteredFops = new ArrayList<RailwayProductFop>();
        block0: for (RailwayProductFop fop : fops) {
            for (GeneralProductCommission commission : fop.getCommissions()) {
                if (commission.getCommissionProperties() == null || commission.getCommissionProperties().getType() == null || !properties.contains(commission.getCommissionProperties().getType())) continue;
                filteredFops.add(fop);
                continue block0;
            }
        }
        return filteredFops;
    }

    public static List<GeneralProductFop> toGeneralProductFops(List<RailwayProductFop> fops) {
        ArrayList<GeneralProductFop> result = new ArrayList<GeneralProductFop>();
        for (RailwayProductFop fop : fops) {
            result.add(RailwayProductHelper.toGeneralProductFop(fop));
        }
        return result;
    }

    public static GeneralProductFop toGeneralProductFop(RailwayProductFop fop) {
        GeneralProductFop generalProductFop = new GeneralProductFop();
        generalProductFop.setUid(fop.getUid());
        generalProductFop.setType(fop.getType());
        generalProductFop.setCard(fop.getCard());
        generalProductFop.setPassengerStatus(fop.getPassengerStatus());
        generalProductFop.setRelatedTicketNumber(fop.getRelatedTicketNumber());
        generalProductFop.setEquivalentAmount(fop.getAmount() != null ? fop.getAmount().getValue() : null);
        generalProductFop.setOperationDate(fop.getOperationDate());
        generalProductFop.setAgent(fop.getAgent());
        generalProductFop.setRefused(fop.isRefused());
        generalProductFop.setPayer(fop.getPayer());
        generalProductFop.getCommissions().clear();
        for (GeneralProductCommission commission : fop.getCommissions()) {
            generalProductFop.getCommissions().add(GeneralProductHelper.toGeneralProductCommission((GeneralProductCommission)commission));
        }
        return generalProductFop;
    }

    public static GeneralProductTax toGeneralProductTax(RailwayTax tax) {
        GeneralProductTax generalProductTax = new GeneralProductTax();
        generalProductTax.setUid(tax.getUid());
        generalProductTax.setCode(tax.getCode());
        generalProductTax.setAmount(tax.getFare());
        generalProductTax.setEquivalentAmount(tax.getEquivalentFare());
        return generalProductTax;
    }

    public static void updateTax(List<RailwayTax> taxes, GeneralProductTax generalProductTax) {
        RailwayTax tax = (RailwayTax)BookingHelper.findEntityByUid(taxes, (String)generalProductTax.getUid());
        if (tax == null) {
            tax = new RailwayTax();
            taxes.add(tax);
        }
        tax.setUid(generalProductTax.getUid());
        tax.setCode(generalProductTax.getCode());
        tax.setFare(generalProductTax.getAmount());
        tax.setEquivalentFare(generalProductTax.getEquivalentAmount());
    }

    public static int getSeatsCount(RailwayProduct prod) {
        int seatsCount = 0;
        for (RailwaySegment segment : prod.getSegments()) {
            int size = segment.getPlaces().size();
            if (size <= seatsCount) continue;
            seatsCount = size;
        }
        return seatsCount;
    }

    public static SalesChain getSalesChain(BaseProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    private static void updateRelationFromOldFields(RailwayProduct prod, RailwayProductContractRelationData relation) {
        relation.getCommissions().clear();
        relation.getFops().clear();
        switch (GeneralProductHelper.getContractType((EntityReference)relation.getDescription())) {
            case VENDOR: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection((BaseProduct)prod, (ContractType)ContractType.VENDOR));
                relation.getFops().addAll(RailwayProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR));
                break;
            }
            case SUBAGENCY: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection((BaseProduct)prod, (ContractType)ContractType.SUBAGENCY));
                relation.getFops().addAll(RailwayProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY));
                break;
            }
            case CLIENT: {
                relation.getCommissions().addAll(GeneralProductHelper.getUnmodifiableCommissionsFromOldSourceByReflection((BaseProduct)prod, (ContractType)ContractType.CLIENT));
                relation.getFops().addAll(RailwayProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT));
            }
        }
    }

    public static List<RailwayProductFop> getFopsFromOldSource(RailwayProduct prod, ContractType contractType) {
        String propertyName = null;
        switch (contractType) {
            case VENDOR: {
                propertyName = "vendorFops";
                break;
            }
            case SUBAGENCY: {
                propertyName = "subagentFops";
                break;
            }
            case CLIENT: {
                propertyName = "clientFops";
            }
        }
        return (List)prod.getValue(propertyName);
    }

    public static RailwayProductContractRelationData getClientContractRelation(RailwayProduct prod) {
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.CLIENT) continue;
            return relation;
        }
        throw new IllegalStateException("client contract relation is absent in product");
    }

    public static List<RailwayProductContractRelationData> getContractRelations(RailwayProduct prod) {
        List originalRelations = (List)prod.getValue("contractRelations");
        SalesChain salesChain = RailwayProductHelper.getSalesChain((BaseProduct)prod);
        ArrayList<RailwayProductContractRelationData> subresult = new ArrayList<RailwayProductContractRelationData>();
        ArrayList toDelete = new ArrayList(originalRelations);
        boolean modified = false;
        for (EntityReference item : ((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getContractRelations()) {
            RailwayProductContractRelationData relation = RailwayProductHelper.findContractRelation((List<RailwayProductContractRelationData>)originalRelations, (EntityReference<ContractRelationDescription>)item);
            if (relation != null) {
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            PredefinedContractRelationType predefinedType = ((ContractRelationDescription)EntityStorage.get().resolve(item).getEntity()).getPredefinedType();
            if ((predefinedType == PredefinedContractRelationType.AGENCY_TO_CLIENT || predefinedType == PredefinedContractRelationType.SUBAGENCY_TO_CLIENT) && (relation = RailwayProductHelper.findContractRelation((List<RailwayProductContractRelationData>)originalRelations, ContractType.CLIENT)) != null) {
                relation.setDescription(item);
                subresult.add(relation);
                toDelete.remove(relation);
                continue;
            }
            relation = new RailwayProductContractRelationData();
            relation.setDescription(item);
            RailwayProductHelper.updateRelationFromOldFields(prod, relation);
            subresult.add(relation);
            modified = true;
        }
        if (modified || !toDelete.isEmpty()) {
            originalRelations.clear();
            originalRelations.addAll(subresult);
            GeneralProductHelper.getCommissionsFromOldSourceByReflection((BaseProduct)prod).clear();
            RailwayProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR).clear();
            RailwayProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY).clear();
            RailwayProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT).clear();
        }
        return originalRelations;
    }

    public static List<GeneralProductContractRelationData> getUnmodifiableContractRelations(RailwayProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).getUnmodifiableContractRelations((BaseProduct)product);
    }

    public static RailwayProductContractRelationData findContractRelation(List<RailwayProductContractRelationData> relations, EntityReference<ContractRelationDescription> descr) {
        for (RailwayProductContractRelationData relation : relations) {
            if (!descr.equals((Object)relation.getDescription())) continue;
            return relation;
        }
        return null;
    }

    public static RailwayProductContractRelationData findContractRelation(List<RailwayProductContractRelationData> relations, ContractType ct) {
        for (RailwayProductContractRelationData relation : relations) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ct) continue;
            return relation;
        }
        return null;
    }

    public static List<GeneralProductCommission> getUnmodifiableCommissions(RailwayProduct product, ContractType contractType) {
        ArrayList<GeneralProductCommission> filteredCommissions = new ArrayList<GeneralProductCommission>();
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(product)) {
            if (contractType != null && GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != contractType) continue;
            filteredCommissions.addAll(relation.getCommissions());
        }
        return filteredCommissions;
    }

    public static RailwayProductContractRelationData getVendorContractRelation(RailwayProduct prod) {
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.VENDOR) continue;
            return relation;
        }
        throw new IllegalStateException("vendor contract relation is absent in product");
    }

    public static List<RailwayProductFop> getVendorFops(RailwayProduct prod) {
        return RailwayProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<RailwayProductFop> getSubagentFops(RailwayProduct prod, boolean autoUpdateSalesChain) {
        RailwayProductContractRelationData relation = RailwayProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<RailwayProductFop> getClientFops(RailwayProduct prod) {
        return RailwayProductHelper.getClientContractRelation(prod).getFops();
    }

    public static RailwayProductContractRelationData getSubagentContractRelation(RailwayProduct prod, boolean autoUpdateSalesChain) {
        for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(prod)) {
            if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.SUBAGENCY) continue;
            return relation;
        }
        SalesChain salesChain = RailwayProductHelper.getSalesChain((BaseProduct)prod);
        if (GeneralProductHelper.isOwnPredefinedSalesChainType((PredefinedSalesChainType)((SalesChainDescription)EntityStorage.get().resolve(salesChain.getDescription()).getEntity()).getPredefinedType())) {
            if (!autoUpdateSalesChain) {
                return null;
            }
            salesChain.setDescription(GeneralProductHelper.getPredefinedDescription((PredefinedSalesChainType)PredefinedSalesChainType.SUBAGENT, (EntityReference)salesChain.getDescription()));
            Contractor contractor = new Contractor();
            contractor.setDescription(GeneralProductHelper.findPredefinedContractorDescription((PredefinedContractorType)PredefinedContractorType.SUBAGENCY));
            contractor.setContractor(GeneralProductHelper.getContractor((SalesChain)salesChain, (PredefinedContractorType)PredefinedContractorType.AGENCY));
            List lst = salesChain.getContractors();
            lst.add(lst.size() - 1, contractor);
            for (RailwayProductContractRelationData relation : RailwayProductHelper.getContractRelations(prod)) {
                if (GeneralProductHelper.getContractType((EntityReference)relation.getDescription()) != ContractType.SUBAGENCY) continue;
                return relation;
            }
        }
        throw new IllegalStateException("subagent contract relation is absent in product");
    }

    public static EntityReference<Organization> getSupplier(BaseProduct prod) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayProductHelper.getSalesChain(prod), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
    }

    public static void setSupplier(BaseTicketProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor((SalesChain)RailwayProductHelper.getSalesChain((BaseProduct)prod), (PredefinedContractorType)PredefinedContractorType.SUPPLIER, value);
    }

    public static EntityReference<Organization> getAgency(RailwayProduct prod) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayProductHelper.getSalesChain((BaseProduct)prod), (PredefinedContractorType)PredefinedContractorType.AGENCY);
    }

    public static void setAgency(BaseTicketProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor((SalesChain)RailwayProductHelper.getSalesChain((BaseProduct)prod), (PredefinedContractorType)PredefinedContractorType.AGENCY, value);
    }

    public static EntityReference<Organization> getSubagency(RailwayProduct prod) {
        return GeneralProductHelper.getContractor((SalesChain)RailwayProductHelper.getSalesChain((BaseProduct)prod), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
    }

    public static void setSubagency(BaseTicketProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor((SalesChain)RailwayProductHelper.getSalesChain((BaseProduct)prod), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, value);
    }

    public static void clearCommissions(RailwayProduct prod) {
        GeneralProductHelper.getCommissionsFromOldSourceByReflection((BaseProduct)prod).clear();
        for (RailwayProductContractRelationData item : RailwayProductHelper.getContractRelations(prod)) {
            item.getCommissions().clear();
        }
    }

    public static void clearFops(RailwayProduct prod) {
        RailwayProductHelper.getFopsFromOldSource(prod, ContractType.VENDOR).clear();
        RailwayProductHelper.getFopsFromOldSource(prod, ContractType.SUBAGENCY).clear();
        RailwayProductHelper.getFopsFromOldSource(prod, ContractType.CLIENT).clear();
        for (RailwayProductContractRelationData item : RailwayProductHelper.getContractRelations(prod)) {
            item.getFops().clear();
        }
    }

    public static boolean isFareFopsRelevant(RailwayProduct product) {
        return GeneralProductHelper.getHandler((BaseProduct)product).isFareFopsRelevant((BaseProduct)product);
    }

    public static String getCodeRouteLine(Stream<RailwaySegment> stream) {
        if (stream == null) {
            return null;
        }
        ArrayList route = new ArrayList();
        MiscUtil.Value last = new MiscUtil.Value();
        stream.filter(Objects::nonNull).forEach(railwaySegment -> {
            RailwayStationReference departure = RailwayProductHelper.getRailwayStationReference((DictionaryReference<RailwayStation>)railwaySegment.getDepartureStation());
            RailwayStationReference arrive = RailwayProductHelper.getRailwayStationReference((DictionaryReference<RailwayStation>)railwaySegment.getArriveStation());
            if (CollectionUtil.isEmpty((Collection)route)) {
                route.add(departure);
                last.setValue((Object)departure);
            }
            if (!TextUtil.isSame((String)((RailwayStationReference)last.getValue()).getCode(), (String)departure.getCode())) {
                ((RailwayStationReference)last.getValue()).setCode(String.format("%s%s%s", ((RailwayStationReference)last.getValue()).getCode(), "~", departure.getCode()));
            }
            route.add(arrive);
            last.setValue((Object)arrive);
        });
        return RailLocalizer.get().encode(route);
    }

    public static void changeFopsPaymentTypes(List<RailwayProductFop> fops, PaymentType newPaymentType, boolean updateOnlyFeeFops) {
        if (updateOnlyFeeFops) {
            fops.stream().filter(fop -> !RailwayProductHelper.isServiceFop(fop)).forEach(fop -> fop.setType(newPaymentType));
        } else {
            fops.stream().filter(RailwayProductHelper::isServiceFop).forEach(fop -> fop.setType(newPaymentType));
        }
    }

    public static Predicate<RailwayProduct> status(ProductStatus status) {
        return railwayProduct -> railwayProduct.getStatus() == status;
    }

    public static boolean removeProduct(RailwayProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(RailwayProduct product, BaseProduct relatedProduct) {
        product.getRelatedProducts().remove(relatedProduct);
        return true;
    }

    public static Stream<RailwayProduct> getRailwayProductStream(Reservation reservation) {
        return reservation.getProducts().stream().filter(bp -> bp instanceof RailwayProduct).map(bp -> (RailwayProduct)bp);
    }

    public static String getCities(RailwayProduct product, Locale locale) {
        return RailwayProductHelper.getCities(product.getSegments(), locale);
    }

    public static String getCities(Collection<RailwaySegment> segments, Locale locale) {
        StringBuilder locations = new StringBuilder();
        DictionaryReference previousArriveStation = null;
        boolean first = true;
        for (RailwaySegment segment : segments) {
            DictionaryReference departureStation = segment.getDepartureStation();
            DictionaryReference arriveStation = segment.getArriveStation();
            if (first) {
                locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureStation)).map(item -> item.toString(locale)).orElse("?"));
                first = false;
            } else if (!MiscUtil.equals(previousArriveStation, (Object)departureStation)) {
                locations.append(" / ");
                locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureStation)).map(item -> item.toString(locale)).orElse("?"));
            }
            locations.append(" - ");
            locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(arriveStation)).map(item -> item.toString(locale)).orElse("?"));
            previousArriveStation = arriveStation;
        }
        return locations.length() > 0 ? locations.toString() : null;
    }

    public static String getCountries(RailwayProduct product, Locale locale) {
        return RailwayProductHelper.getCountries(product.getSegments(), locale);
    }

    public static String getCountries(Collection<RailwaySegment> segments, Locale locale) {
        StringBuilder countries = new StringBuilder();
        DictionaryReference previousArriveCountry = null;
        boolean first = true;
        for (RailwaySegment segment : segments) {
            DictionaryReference departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(segment.getDepartureStation())).map(RailwayStation::getCountry).orElse(null);
            DictionaryReference arriveCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(segment.getArriveStation())).map(RailwayStation::getCountry).orElse(null);
            if (first) {
                countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureCountry)).map(item -> item.toString(locale)).orElse("?"));
                first = false;
            } else if (!MiscUtil.equals(previousArriveCountry, (Object)departureCountry)) {
                countries.append(" / ");
                countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureCountry)).map(item -> item.toString(locale)).orElse("?"));
            }
            countries.append(" - ");
            countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(arriveCountry)).map(item -> item.toString(locale)).orElse("?"));
            previousArriveCountry = arriveCountry;
        }
        return countries.length() > 0 ? countries.toString() : null;
    }

    public static DictionaryReference<PassengerType> getPassengerType(RailwayProduct product, Traveller traveller) {
        if (traveller == null) {
            return null;
        }
        return product.getPassengerTypes().stream().filter(p -> MiscUtil.equals((Object)p.getTraveller(), (Object)traveller)).map(PassengerTypeReference::getPassengerType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static List<DictionaryReference<PassengerType>> getPassengerTypes(RailwayProduct product) {
        return product.getPassengers().stream().map(passenger -> RailwayProductHelper.getPassengerType(product, passenger)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Deprecated
    public static DictionaryReference<PassengerType> getMainPassengerType(RailwayProduct product) {
        LinkedHashSet<DictionaryReference<PassengerType>> passengerTypes = new LinkedHashSet<DictionaryReference<PassengerType>>(RailwayProductHelper.getPassengerTypes(product));
        return RailwayProductHelper.getPassengerTypeDictionaryReference(passengerTypes);
    }

    public static DictionaryReference<PassengerType> getPassengerTypeDictionaryReference(Set<DictionaryReference<PassengerType>> passengerTypes) {
        if (passengerTypes.size() < 2) {
            return (DictionaryReference)CollectionUtil.head(passengerTypes);
        }
        DictionaryReference adultType = passengerTypes.stream().filter(DictHelper::isAdultPassengerType).findFirst().orElse(null);
        if (adultType != null) {
            return adultType;
        }
        DictionaryReference childType = passengerTypes.stream().filter(DictHelper::isChildPassengerType).findFirst().orElse(null);
        if (childType != null) {
            return childType;
        }
        DictionaryReference infantType = passengerTypes.stream().filter(DictHelper::isInfantPassengerType).findFirst().orElse(null);
        if (infantType != null) {
            return infantType;
        }
        return (DictionaryReference)CollectionUtil.head(passengerTypes);
    }

    public static void setPassengerType(RailwayProduct product, Traveller traveller, DictionaryReference<PassengerType> passengerType) {
        if (product == null || traveller == null) {
            return;
        }
        product.getPassengerTypes().removeIf(passengerTypeReference -> traveller.equals((Object)passengerTypeReference.getTraveller()));
        if (passengerType == null) {
            return;
        }
        PassengerTypeReference passengerTypeReference2 = new PassengerTypeReference();
        passengerTypeReference2.setTraveller(traveller);
        passengerTypeReference2.setPassengerType(passengerType);
        product.getPassengerTypes().add(passengerTypeReference2);
    }

    public static BigDecimal getDeduction(RailwayProduct product) {
        return product.getReservedSeats().stream().map(ReservedSeat::getEquivalentDeduction).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
    }

    public static BigDecimal getDeductionVat(RailwayProduct product) {
        return product.getReservedSeats().stream().map(ReservedSeat::getEquivalentDeductionVAT).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(null);
    }

    public static ProductFopCategory getProductFopCategory(RailwayProductFop productFop) {
        if (!RailwayProductHelper.isServiceFop(productFop)) {
            for (GeneralProductCommission commission : productFop.getCommissions()) {
                if (commission.getCommissionProperties() == null) continue;
                Class type = commission.getCommissionProperties().getType();
                if (GeneralProductHelper.paymentFeePropertyTypes.contains(type)) {
                    return ProductFopCategory.PAYMENT_FEE;
                }
                if (!GeneralProductHelper.discountPropertyTypes.contains(type)) continue;
                return ProductFopCategory.DISCOUNT;
            }
            return ProductFopCategory.SERVICE_FEE;
        }
        return ProductFopCategory.PRODUCT;
    }

    static {
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        for (VatBasisType type : VatBasisType.values()) {
            rusVatRates.put(type, new ArrayList());
            kzVatRates.put(type, new ArrayList());
        }
        rusVatRates.get(VatBasisType.FARE).add((MiscUtil.Pair<Date, Double>)new MiscUtil.Pair((Object)MiscUtil.toDate((LocalDate)LocalDate.parse("2000-01-01", format)), (Object)18.0));
        rusVatRates.get(VatBasisType.FARE).add((MiscUtil.Pair<Date, Double>)new MiscUtil.Pair((Object)MiscUtil.toDate((LocalDate)LocalDate.parse("2016-01-01", format)), (Object)10.0));
        rusVatRates.get(VatBasisType.FARE).add((MiscUtil.Pair<Date, Double>)new MiscUtil.Pair((Object)MiscUtil.toDate((LocalDate)LocalDate.parse("2017-01-01", format)), (Object)0.0));
        rusVatRates.get(VatBasisType.SERVICE).add((MiscUtil.Pair<Date, Double>)new MiscUtil.Pair((Object)MiscUtil.toDate((LocalDate)LocalDate.parse("2000-01-01", format)), (Object)18.0));
        rusVatRates.get(VatBasisType.SERVICE).add((MiscUtil.Pair<Date, Double>)new MiscUtil.Pair((Object)MiscUtil.toDate((LocalDate)LocalDate.parse("2019-01-01", format)), (Object)20.0));
    }
}

