/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.helpers;

import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwayReferenceMCO;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.util.MiscUtil;

public final class RailwayReferenceMcoHelper {
    public static RailwayReferenceMCO findReferenceMco(RailwayProduct product) {
        if (product == null || product.getReservation() == null || product.getReservation().getBookingFile() == null) {
            return null;
        }
        BookingFile bookingFile = product.getReservation().getBookingFile();
        for (Reservation reservation : bookingFile.getReservations()) {
            for (BaseProduct baseProduct : reservation.getProducts()) {
                RailwayReferenceMCO referenceMco;
                if (!(baseProduct instanceof RailwayReferenceMCO) || (referenceMco = (RailwayReferenceMCO)baseProduct).getRelatedProduct() == null || !referenceMco.getRelatedProduct().getUid().equals(product.getUid())) continue;
                return referenceMco;
            }
        }
        return null;
    }

    public static String getTicketSeries(RailwayReferenceMCO mco) {
        String ticketSeries = null;
        BlankType blankType = (BlankType)DictionaryCache.get().resolveReference(mco.getBlankType());
        ticketSeries = blankType != null ? blankType.getName() : mco.getSystemNumber();
        return ticketSeries;
    }

    public static boolean removeProduct(RailwayReferenceMCO product) {
        product.getReservation().getProducts().remove(product);
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(RailwayReferenceMCO product, BaseProduct relatedProduct) {
        if (MiscUtil.equals((Object)product.getRelatedProduct(), (Object)relatedProduct)) {
            product.setRelatedProduct(null);
        }
        return true;
    }
}

