/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.localization.routeLine;

import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.localization.routeLine.CodeType;
import com.gridnine.xtrip.common.model.localization.routeLine.DictionaryReferenseLocalizer;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Locale;
import java.util.StringTokenizer;

public class RailLocalizer
extends DictionaryReferenseLocalizer<RailwayStation> {
    public static RailLocalizer get() {
        return Holder.INSTANCE;
    }

    public CodeType getCodeType() {
        return CodeType.RAIL;
    }

    public Class<RailwayStation> getDictonaryCls() {
        return RailwayStation.class;
    }

    public String localize(String code, Locale locale) {
        if (TextUtil.isBlank((String)code)) {
            return code;
        }
        StringTokenizer tokenizer = new StringTokenizer(code, "~");
        StringBuilder res = new StringBuilder();
        while (tokenizer.hasMoreTokens()) {
            if (res.length() > 0) {
                res.append(';');
            }
            res.append(super.localize(tokenizer.nextToken(), locale));
        }
        return res.toString();
    }

    private static class Holder {
        private static final RailLocalizer INSTANCE = new RailLocalizer();

        private Holder() {
        }
    }
}

