/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.model.validation;

import com.gridnine.xtrip.common.model.booking.ValidationMessageCategory;
import com.gridnine.xtrip.common.model.booking.ValidationMessageSeverity;
import com.gridnine.xtrip.common.model.validation.ValidationMessageType;
import com.gridnine.xtrip.common.railway.l10n.Messages;

public enum RailwayValidationMessageType implements ValidationMessageType
{
    RPI_BLANK_OWNER_IS_EMPTY(1, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, "ValidationHelper_Message_BlankOwnerIsEmpty", null),
    RPI_PRODUCT_STATUS_UNDEFINED(2, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, "ValidationHelper_Message_ProductStatusUndefined", null),
    RPI_BLANK_IS_EMPTY(3, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, "ValidationHelper_Message_BlankTypeIsEmpty", null),
    RPI_BLANK_TYPE_HAS_WRONG_VALUE(4, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, "ValidationHelper_Message_BlankTypeHasWrongValue", null),
    RPI_DUPLICATE_PRODUCT(5, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, "ValidationHelper_Message_DuplicateProduct", null),
    RPI_VALIDATOR_NOT_FOUND(6, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_6, null),
    RPI_MORE_THAN_ONE_VALIDATOR(7, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_7, null),
    RPI_AGENCY_DOESNT_MATCH_VALIDATOR_CODE(8, ValidationMessageSeverity.WARNING, ValidationMessageCategory.OTHER, "ValidationHelper_Message_AgencyDoesntMatchValidatorCode", null),
    RPI_SUBAGENCY_DOESNT_MATCH_VALIDATOR_CODE(9, ValidationMessageSeverity.WARNING, ValidationMessageCategory.OTHER, "ValidationHelper_Message_SubagencyDoesntMatchValidatorCode", null),
    RPI_SALES_POINT_DOESNT_MATCH_VALIDATOR_CODE(10, ValidationMessageSeverity.WARNING, ValidationMessageCategory.OTHER, "ValidationHelper_Message_SalesPointDoesntMatchValidatorCode", null),
    RPI_VALIDATOR_NOT_DEFINED(11, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_11, null),
    RPI_TICKET_EQU_FARE_NOT_EQUALS_SUM_RESERVED(12, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_12, null),
    RPI_TICKET_EQU_FARE_NOT_EQUALS_SUM_TOTAL(13, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_13, null),
    RPI_TICKET_EQU_VAT_NOT_EQUALS_SUM_VAT(14, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_14, null),
    RPI_TICKET_EQU_FARE_NOT_EQUALS_VENDOR_FOP(15, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_15, null),
    RPI_TICKET_EQU_FARE_NOT_EQUALS_CLIENT_FOP(16, ValidationMessageSeverity.USER_ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_16, null),
    RPI_TICKET_EQU_FARE_NOT_EQUALS_SUBAGENT_FOP(17, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_17, null),
    RRMCOI_ASSIGNED_TICKET_NOT_DEFINED(18, Messages.RailwayValidationMessageType_18),
    RPI_CARRIER_IN_SEGMENT_IS_EMPTY(19, ValidationMessageSeverity.USER_ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_19, null),
    RPI_CARRIER_IN_SEGMENT_HAS_WRONG_VALUE(20, ValidationMessageSeverity.USER_ERROR, ValidationMessageCategory.OTHER, Messages.RailwayValidationMessageType_20, null);

    private ValidationMessageSeverity defaultSeverety;
    private ValidationMessageCategory category;
    private String messageKey;
    private String details;
    private Integer number;
    private String errorCode;
    private static final String PREFIX = "RLW-";

    private RailwayValidationMessageType(Integer number, ValidationMessageSeverity defaultSeverety, ValidationMessageCategory category, String messageKey, String details) {
        this.defaultSeverety = defaultSeverety;
        this.category = category;
        this.messageKey = messageKey;
        this.details = details;
        this.number = number;
        this.errorCode = PREFIX + number;
    }

    private RailwayValidationMessageType(Integer number, ValidationMessageSeverity defaultSeverety, String messageKey) {
        this(number, defaultSeverety, ValidationMessageCategory.OTHER, messageKey, null);
    }

    private RailwayValidationMessageType(Integer number, ValidationMessageSeverity defaultSeverety, ValidationMessageCategory category, String messageKey) {
        this(number, defaultSeverety, category, messageKey, null);
    }

    private RailwayValidationMessageType(Integer number, String messageKey) {
        this(number, ValidationMessageSeverity.ERROR, ValidationMessageCategory.OTHER, messageKey, null);
    }

    public String getId() {
        return this.name();
    }

    public ValidationMessageCategory getCategory() {
        return this.category;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public ValidationMessageSeverity getDefaultSeverity() {
        return this.defaultSeverety;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getPrefix() {
        return PREFIX;
    }

    public Integer getNumber() {
        return this.number;
    }
}

