/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.parsers.helpers;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.parsers.helpers.ProductParserHelper;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchContext;
import com.gridnine.xtrip.common.parsers.helpers.ProductSearchResult;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import java.util.Date;

public class RailwayProductParserHelper {
    private static final int PNR_DAYS_THRESHOLD = 90;
    public static final ProductParserHelper.ProductParserHandler<RailwayProduct> handler = new ProductParserHelper.ProductParserHandler<RailwayProduct>(){

        public RailwayProduct createProduct() {
            return new RailwayProduct();
        }

        public int getThreshold() {
            return 90;
        }

        public void setSystemNumber(RailwayProduct product, String systemNumber) {
            product.setSystemNumber(systemNumber);
        }

        public void setIssueDate(RailwayProduct product, Date issueDate) {
            product.setIssueDate(issueDate);
        }

        public void setStatus(RailwayProduct product, ProductStatus status) {
            product.setStatus(status);
        }

        public void setTicketType(RailwayProduct product, TicketType ticketType) {
            product.setTicketType(ticketType);
        }

        public void setProductCategory(RailwayProduct product, ProductCategory productCategory) {
        }

        public void setBlankOwner(RailwayProduct product, EntityReference<Organization> blankOwner) {
            product.setBlankOwnerRef(blankOwner);
        }

        public void setSupplier(RailwayProduct product, EntityReference<Organization> supplier) {
            RailwayProductHelper.setSupplier((BaseTicketProduct)product, supplier);
        }

        public void setAgency(RailwayProduct product, EntityReference<Organization> agency) {
            RailwayProductHelper.setAgency((BaseTicketProduct)product, agency);
        }

        public void setSubagency(RailwayProduct product, EntityReference<Organization> subagency) {
            RailwayProductHelper.setSubagency((BaseTicketProduct)product, subagency);
        }

        public void setPreviousProduct(RailwayProduct product, RailwayProduct previousProduct) {
            product.setPreviousProduct(previousProduct);
        }

        public void setNextProduct(RailwayProduct product, RailwayProduct nextProduct) {
            product.setNextProduct(nextProduct);
        }

        public void addRelatedProduct(RailwayProduct product, BaseProduct relatedProduct) {
            if (relatedProduct instanceof RailwayProduct) {
                product.getRelatedProducts().add((RailwayProduct)relatedProduct);
            }
        }
    };

    public static ProductSearchResult searchProductSell(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductSell((ProductSearchContext)context, handler);
    }

    public static ProductSearchResult searchProductRefund(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductRefund((ProductSearchContext)context, handler);
    }

    public static ProductSearchResult searchProductVoid(ProductSearchContext context) throws Exception {
        return ProductParserHelper.searchProductVoid((ProductSearchContext)context, handler);
    }

    public static ProductSearchContext.ProductCreateResult createProduct(ProductStatus status, String systemNumber) {
        return ProductParserHelper.createProduct((ProductStatus)status, (String)systemNumber, null, handler);
    }
}

