/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.railway.reports.render.salesreports.spgd;

import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.railway.parsers.SPGDArchiveExchangeDocument;
import com.gridnine.xtrip.common.railway.parsers.TransactionType;
import com.gridnine.xtrip.common.railway.parsers.helpers.RailwayProductParsersHelper;
import com.gridnine.xtrip.common.railway.reports.model.BaseReportTicket;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class SPGDDivergenceReportTicket
extends BaseReportTicket {
    private static final long serialVersionUID = -4096136113764906631L;
    public static final String BATCH_IS_SPGD = "batch_is_spgd";
    public static final String DATA_CODE_SPGD = "\u0422\u041a\u041f";
    public static final String DATA_CODE_AVS = "\u0410\u0412\u0421";
    private String dataCode;
    private Integer segmentNumber;
    private TransactionType transactionType;
    private Date avsPeriodEnd;
    private PaymentType paymentType;
    private String validatingCarrier;
    private String segmentCarrier;
    private BigDecimal equivalentFare;
    private BigDecimal penalty;
    private BigDecimal taxAgs;
    private BigDecimal taxTch;

    public SPGDDivergenceReportTicket(RailwayProduct product, List<Message> messages) {
        this.dataCode = DATA_CODE_AVS;
        this.systemNumber = product.getSystemNumber();
        this.issueDate = product.getIssueDate();
        this.segmentNumber = 1;
        Airline airline = DictHelper.findAirlineByNumber((String)product.getCarrierNumber());
        if (airline != null) {
            this.validatingCarrier = airline.getCode();
        }
        this.transactionType = RailwayProductParsersHelper.getTransactionType(product.getStatus());
        this.equivalentFare = product.getEquivalentFare();
        if (this.equivalentFare == null) {
            this.equivalentFare = BigDecimal.ZERO;
        }
        this.equivalentFare = MiscUtil.sum((BigDecimal[])new BigDecimal[]{this.equivalentFare, product.getStatus() == ProductStatus.REFUND ? MiscUtil.negate((BigDecimal)product.getPenalty()) : product.getPenalty()});
        try {
            this.taxTch = GeneralProductHelper.calculateCommissionsEquivalentValue((Collection)GeneralProductHelper.filterCommissions(RailwayProductHelper.getUnmodifiableCommissions(product, ContractType.VENDOR), (Set)GeneralProductHelper.serviceFeePropertyTypes, null, null));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.taxTch == null) {
            this.taxTch = BigDecimal.ZERO;
        }
        if (this.transactionType != null && this.transactionType == TransactionType.REFUND) {
            if (this.equivalentFare != null) {
                this.equivalentFare = this.equivalentFare.negate();
            }
            if (this.taxTch != null) {
                this.taxTch = this.taxTch.negate();
            }
        }
    }

    public SPGDDivergenceReportTicket(SPGDArchiveExchangeDocument document, List<Message> messages) {
        this.dataCode = DATA_CODE_SPGD;
        this.systemNumber = document.getSystemNumber();
        this.issueDate = document.getIssueDate();
        this.segmentNumber = 1;
        this.validatingCarrier = document.getCarrierCode();
        this.transactionType = document.getTransactionType();
        this.equivalentFare = document.getEquivalentFare();
        this.taxTch = document.getTchFee();
        if (this.transactionType != null && this.transactionType == TransactionType.REFUND) {
            if (this.equivalentFare != null) {
                this.equivalentFare = this.equivalentFare.negate();
            }
            if (this.taxTch != null) {
                this.taxTch = this.taxTch.negate();
            }
        }
    }

    public String getDataCode() {
        return this.dataCode;
    }

    protected void setDataCode(String dataCode) {
        this.dataCode = dataCode;
    }

    public Integer getSegmentNumber() {
        return this.segmentNumber;
    }

    protected void setSegmentNumber(Integer segmentNumber) {
        this.segmentNumber = segmentNumber;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    protected void setSegmentNumber(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public Date getAVSPeriodEnd() {
        return this.avsPeriodEnd;
    }

    protected void setAVSPeriodEnd(Date avsPeriodEnd) {
        this.avsPeriodEnd = avsPeriodEnd;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    protected void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public String getValidatingCarrier() {
        return this.validatingCarrier;
    }

    protected void setValidatingCarrier(String validatingCarrier) {
        this.validatingCarrier = validatingCarrier;
    }

    public String getSegmentCarrier() {
        return this.segmentCarrier;
    }

    protected void setSegmentCarrier(String segmentCarrier) {
        this.segmentCarrier = segmentCarrier;
    }

    public BigDecimal getEquivalentFare() {
        return this.equivalentFare;
    }

    public void setEquivalentFare(BigDecimal equivalentFare) {
        this.equivalentFare = equivalentFare;
    }

    public BigDecimal getPenalty() {
        return this.penalty;
    }

    public void setPenalty(BigDecimal penalty) {
        this.penalty = penalty;
    }

    public BigDecimal getTaxAgs() {
        return this.taxAgs;
    }

    public void setTaxAgs(BigDecimal taxAgs) {
        this.taxAgs = taxAgs;
    }

    public BigDecimal getTaxTch() {
        return this.taxTch;
    }

    public void setTaxTch(BigDecimal taxTch) {
        this.taxTch = taxTch;
    }
}

