/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.transfers;

import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.transfer.TransferHelper;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.BasicDocumentIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransferRefunder {
    private static final Logger log = LoggerFactory.getLogger(TransferRefunder.class);
    private final Transfer transfer;
    private final EntityContainer<BookingFile> bookingFile;

    public TransferRefunder(Transfer transfer, EntityContainer<BookingFile> bookingFile) {
        this.transfer = transfer;
        this.bookingFile = bookingFile;
    }

    private void updateProduct() throws Exception {
        if (this.transfer.getStatus() == ProductStatus.SELL) {
            this.createRefundProduct(this.transfer);
        } else {
            this.transfer.setStatus(ProductStatus.VOID_BOOKING);
        }
    }

    public void process() throws Exception {
        this.updateProduct();
        this.removeTravelDocs();
    }

    private void createRefundProduct(Transfer model) throws Exception {
        Reservation reservation = model.getReservation();
        model.setReservation(null);
        HashSet excludedUids = new HashSet();
        model.getTravellers().forEach(traveller -> excludedUids.add(traveller.getUid()));
        try {
            Transfer refund = (Transfer)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            model.setNextProduct(refund);
            refund.setReservation(reservation);
            refund.setPreviousProduct(model);
            refund.setContractRulesApplied(false);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            refund.setChecked(false);
            this.setFopOperationDate(refund);
            reservation.getProducts().add(refund);
        }
        catch (Throwable t) {
            log.debug(String.format("Error while clone=[%s], stackTrace=[%s]", XSUtil.toString((XSSerializable)model), TextUtil.getExceptionStackTrace((Throwable)t)), t);
            throw t;
        }
        finally {
            model.setReservation(reservation);
        }
    }

    private void setFopOperationDate(Transfer refund) {
        Consumer<GeneralProductFop> setOperationDate = fop -> fop.setOperationDate(new Date());
        TransferHelper.getContractRelations((Transfer)refund).forEach(el -> el.getFops().forEach(setOperationDate));
    }

    private void removeTravelDocs() {
        try {
            this.getProductDocuments(this.bookingFile).stream().filter(index -> this.isMatch((BasicDocumentIndex)index, this.transfer.getUid())).forEach(this::deleteDocument);
        }
        catch (Exception ex) {
            log.error("failed to remove docs", (Throwable)ex);
        }
    }

    private void deleteDocument(BasicDocumentIndex index) {
        EntityStorage.get().delete(index.getSource());
    }

    private boolean isMatch(BasicDocumentIndex index, String productUid) {
        return index.getNavigationKey() != null && index.getNavigationKey().equals(productUid);
    }

    private List<BasicDocumentIndex> getProductDocuments(EntityContainer<BookingFile> etc) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)BasicDocumentIndex.Property.owner.name(), (Object)etc.toReference()));
        return EntityStorage.get().search(BasicDocumentIndex.class, query).getData();
    }
}

