/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.transfers.rules;

import com.gridnine.xtrip.common.gds.model.BaseGdsAccount;
import com.gridnine.xtrip.common.midoffice.helper.CommonHelper;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.common.transfers.rules.TransferParametersPropertiesProvider;
import java.util.HashSet;
import java.util.Set;

public class TransferParametersProperties
implements TransferParametersPropertiesProvider {
    private final String gdsName;
    private final EntityReference<? extends BaseGdsAccount> gdsAccount;
    private final EntityReference<Person> agent;
    private final EntityReference<Organization> client;
    private final Set<String> subagencyCodes = new HashSet<String>();
    private String agencyCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferParametersProperties(GdsName gdsName, EntityReference<? extends BaseGdsAccount> gdsAccount, SalesContext ctx, RuleProxy<?, ?> proxy) {
        proxy.getTracer().traceEnteringMethod(this.getClass(), "ctor()", new String[0]);
        try {
            this.gdsName = gdsName == null ? null : gdsName.name();
            this.gdsAccount = gdsAccount;
            this.agent = ctx.getAgent();
            this.client = ctx.getClient();
            this.agencyCode = CommonHelper.getAgencyCode((SalesContext)ctx);
            RulesHelper.addSubagencyCodes(this.subagencyCodes, (EntityReference)ctx.getSubagency());
        }
        finally {
            proxy.getTracer().traceObject("proxy", (Object)this);
            proxy.getTracer().traceExitingMethod(this.getClass(), "ctor()", new String[0]);
        }
    }

    public EntityReference<Organization> getClient() {
        return this.client;
    }

    public EntityReference<? extends BaseGdsAccount> getGdsAccount() {
        return this.gdsAccount;
    }

    public String getGdsName() {
        return this.gdsName;
    }

    public String getAgencyCode() {
        return this.agencyCode;
    }

    public Set<String> getSubagencyCodes() {
        return this.subagencyCodes;
    }

    public Set<String> getProfileGroups() {
        return null;
    }

    public EntityReference<Person> getAgent() {
        return this.agent;
    }
}

