/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ukraine.model.export.xml;

import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.CommonProductIndex;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.RoomSizeDict;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.handlers.XMLExportHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.ukraine.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class UkraineXMLExportHandler
implements XMLExportHandler {
    private static final Logger log = LoggerFactory.getLogger(UkraineXMLExportHandler.class);
    private static final String ENTITY_ELEMENT_NAME = "entity";
    private static final String UID_ATTRIBUTE_NAME = "uid";
    private static final String TYPE_ATTRIBUTE_NAME = "type";
    private static final String TRANSPORTATION_TYPE_ELEMENT_NAME = "transportationTypeUkraine";
    private static final String ROOM_NAME_ELEMENT_NAME = "roomNameUkraine";

    public String getId() {
        return "ukraineXmlExportHandler";
    }

    public <T extends BaseEntity> void updateDocument(List<T> entities, Document document) throws Exception {
        NodeList nodes = document.getElementsByTagName(ENTITY_ELEMENT_NAME);
        for (int i = 0; i < nodes.getLength(); ++i) {
            String name;
            RoomSizeDict roomSize;
            Room room;
            String type = null;
            String uid = null;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            type = element.getAttribute(TYPE_ATTRIBUTE_NAME);
            uid = element.getAttribute(UID_ATTRIBUTE_NAME);
            if (TextUtil.isBlank((String)type) || TextUtil.isBlank((String)uid)) continue;
            if (type.equals(Product.class.getName())) {
                Product product = (Product)UkraineXMLExportHandler.findProductByUid(entities, Product.class, uid);
                String transportationType = AirProductHelper.getTransportationTypeTitleForXmlReport(product);
                if (transportationType == null) continue;
                Text transportationTypeTextNode = node.getOwnerDocument().createTextNode(transportationType.toString());
                Element transportationTypeElement = node.getOwnerDocument().createElement(TRANSPORTATION_TYPE_ELEMENT_NAME);
                transportationTypeElement.appendChild(transportationTypeTextNode);
                node.appendChild(transportationTypeElement);
                continue;
            }
            if (!type.equals(Room.class.getName()) || (room = UkraineXMLExportHandler.findEntityByUid(entities, Room.class, uid)) == null || TextUtil.isBlank((String)room.getRoomSize()) || (roomSize = (RoomSizeDict)DictionaryCache.get().findByCode(RoomSizeDict.class, room.getRoomSize())) == null || TextUtil.isBlank((String)(name = DictHelper.getTranslation((BaseDictionary)roomSize, (Locale)LocaleHelper.EN_LOCALE, (boolean)false)))) continue;
            Text roomNameTextNode = node.getOwnerDocument().createTextNode(name);
            Element roomNameElement = node.getOwnerDocument().createElement(ROOM_NAME_ELEMENT_NAME);
            roomNameElement.appendChild(roomNameTextNode);
            node.appendChild(roomNameElement);
        }
    }

    private static <T extends BaseEntity, C extends BaseEntity> C findEntityByUid(List<T> entities, Class<C> type, String uid) {
        for (BaseEntity entity : entities) {
            BaseEntity object = EntityStorageHelper.findNestedEntity((BaseEntity)entity, (String)uid, type, new HashSet());
            if (object == null) continue;
            return (C)object;
        }
        return null;
    }

    private static <T extends BaseEntity, C extends BaseProduct> BaseProduct findProductByUid(List<T> entities, Class<C> type, String uid) {
        BaseProduct product = (BaseProduct)UkraineXMLExportHandler.findEntityByUid(entities, type, uid);
        if (product != null) {
            return product;
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"navigationKey", (Object)uid));
        EntityContainer bookingFileContainer = EntityStorage.get().find(CommonProductIndex.class, "navigationKey", (Object)uid);
        if (bookingFileContainer != null) {
            return BookingHelper.findProductByUid((String)uid, (BookingFile)((BookingFile)bookingFileContainer.getEntity()));
        }
        return null;
    }
}

