/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.ukraine.model.rules.standard;

import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.rules.standard.BasicAirTicketPropertiesProvider;
import com.gridnine.xtrip.common.model.rules.standard.RulesHelper;
import com.gridnine.xtrip.common.model.rules.standard.Targets;
import com.gridnine.xtrip.common.model.rules.standard.ValueTypes;
import com.gridnine.xtrip.common.model.ukraine.booking.UkraineTransportationType;
import com.gridnine.xtrip.common.rules.elements.RuleCondition;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.ukraine.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.ukraine.model.rules.standard.Conditions;
import com.gridnine.xtrip.common.ukraine.model.rules.standard.l10n.Messages;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum Properties implements RuleProperty
{
    TRANSPORTATION_TYPE{

        public String getDisplayName() {
            return "\u041e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u0438\u0435 \u043d\u0430 \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435";
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.TRANSPORTATION_UKRAINE.getId(), Conditions.TRANSPORTATION_CIS.getId(), Conditions.TRANSPORTATION_EUROPE.getId(), Conditions.TRANSPORTATION_INTERCONTINANTAL.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder stringBuilder, RuleCondition condition, Object value) {
            if (condition.hasRightSide()) {
                stringBuilder.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleProperty_TRANSPORTATION_TYPE_info1, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString((Object)value)}));
            } else {
                stringBuilder.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleProperty_TRANSPORTATION_TYPE_info2, (Object[])new Object[]{condition.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            BasicAirTicketPropertiesProvider propertiesProvider = (BasicAirTicketPropertiesProvider)propertySet;
            if (Conditions.TRANSPORTATION_UKRAINE.equals(condition)) {
                return RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), AirProductHelper.UKRAINE_FOR_RULES);
            }
            if (Conditions.TRANSPORTATION_CIS.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), AirProductHelper.UKRAINE_FOR_RULES) && RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Collections.singletonList("CIS"));
            }
            if (Conditions.TRANSPORTATION_EUROPE.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Collections.singletonList("CIS")) && (RulesHelper.containsOnly((List)propertiesProvider.getVisitedCities(), Collections.singletonList(String.format("%s-%s", "CIS", "EURO")), (boolean)true) || RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Collections.singletonList("EURO")));
            }
            if (Conditions.TRANSPORTATION_INTERCONTINANTAL.equals(condition)) {
                return !RulesHelper.confinedTo((List)propertiesProvider.getVisitedCities(), Arrays.asList("CIS", "EURO"));
            }
            return true;
        }
    }
    ,
    TRANSPORTATION_TYPE_2{

        public String getDisplayName() {
            return L10n.get((String)Messages.DirectionRestriction);
        }

        @Override
        String[] getConditionIds() {
            return new String[]{Conditions.TRANSPORTATION_DOMESTIC_UA.getId(), Conditions.TRANSPORTATION_SUBREGIONAL.getId(), Conditions.TRANSPORTATION_REGIONAL.getId(), Conditions.TRANSPORTATION_INTERCONTINENTAL.getId()};
        }

        public String getRendererId() {
            return ValueTypes.STRING.name();
        }

        @Override
        String[] getTargetIds() {
            return new String[]{Targets.PRODUCT_COMMISSION.getId()};
        }

        public void buildInfo(StringBuilder stringBuilder, RuleCondition condition, Object value) {
            if (condition.hasRightSide()) {
                stringBuilder.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleProperty_TRANSPORTATION_TYPE_info1, (Object[])new Object[]{condition.getDisplayName(), RulesHelper.toString((Object)value)}));
            } else {
                stringBuilder.append(L10nResourcesManager.getStr((String)com.gridnine.xtrip.common.model.rules.l10n.Messages.RuleProperty_TRANSPORTATION_TYPE_info2, (Object[])new Object[]{condition.getDisplayName()}));
            }
        }

        public boolean match(Object propertySet, RuleCondition condition, Object value) {
            if (!(condition instanceof Conditions)) {
                return true;
            }
            List visitedCities = ((BasicAirTicketPropertiesProvider)propertySet).getVisitedCities();
            UkraineTransportationType transportationType = AirProductHelper.getTransportationType(visitedCities);
            switch ((Conditions)condition) {
                case TRANSPORTATION_DOMESTIC_UA: {
                    return transportationType == UkraineTransportationType.DOMESTIC;
                }
                case TRANSPORTATION_SUBREGIONAL: {
                    return transportationType == UkraineTransportationType.SUBREGIONAL;
                }
                case TRANSPORTATION_REGIONAL: {
                    return transportationType == UkraineTransportationType.REGIONAL;
                }
                case TRANSPORTATION_INTERCONTINENTAL: {
                    return transportationType == UkraineTransportationType.INTERCONTINENTAL;
                }
            }
            throw Xeption.forDeveloper((String)("Unsupported condition type: " + condition), (Object[])new Object[0]);
        }
    };


    public String getId() {
        return this.name();
    }

    abstract String[] getTargetIds();

    abstract String[] getConditionIds();
}

