/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ScheduledTasksMonitor;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.time.FastDateFormat;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.InterruptableJob;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@DisallowConcurrentExecution
public abstract class BaseScheduledTask
implements InterruptableJob {
    protected final transient Logger log = LoggerFactory.getLogger(this.getClass());
    public static final String PREV_FIRE_TIME = "prevFireTime";
    public static final String NEXT_FIRE_TIME = "nextFireTime";
    public static final String DISABLE_SCHEDULED_TASKS_SYSTEM_PROPERTY = "midoffice.disableScheduledTasks";
    protected volatile Properties jobProperties;
    private volatile transient Thread runner;
    private final transient AtomicBoolean stopping = new AtomicBoolean();
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");
    protected final AtomicInteger fails = new AtomicInteger(0);

    protected void configure(Properties properties) throws Exception {
    }

    protected abstract void doJob() throws Exception;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if ("true".equals(System.getProperty(DISABLE_SCHEDULED_TASKS_SYSTEM_PROPERTY)) && !this.isSystem()) {
            return;
        }
        long timing = System.currentTimeMillis();
        this.stopping.set(false);
        this.runner = Thread.currentThread();
        Throwable error = null;
        String threadName = Thread.currentThread().getName();
        Thread.currentThread().setName(String.format("qrtz-task:[%s]-thread:[%s]-start:[%s]", MiscUtil.getSimpleClassName(this.getClass()), Long.toString(Thread.currentThread().getId()), DATE_FORMAT.format(new Date())));
        try {
            this.beforeExecution(context);
            this.jobProperties = new Properties();
            if (context.getMergedJobDataMap() != null) {
                for (Map.Entry entry : context.getMergedJobDataMap().entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    this.jobProperties.put(entry.getKey(), entry.getValue());
                }
            }
            if (context.getPreviousFireTime() != null) {
                this.jobProperties.put(PREV_FIRE_TIME, context.getPreviousFireTime());
            }
            if (context.getNextFireTime() != null) {
                this.jobProperties.put(NEXT_FIRE_TIME, context.getNextFireTime());
            }
            boolean concurrentExecution = this.allowConcurrentExecution();
            this.configure(this.jobProperties);
            String taskName = this.getClass().getName();
            this.log.info("Started scheduled task " + taskName);
            if (concurrentExecution) {
                this.doJob();
            } else {
                String lockName = "task_" + this.getLockName(this.jobProperties) + ".lock";
                this.log.info("lock lockName=" + lockName);
                LockUtil.lock((String)lockName, (long)1L, (TimeUnit)TimeUnit.MINUTES, this::doJob, () -> this.log.info("lock not acquired, lockName=" + lockName));
                this.log.info("unlock lockName=" + lockName);
            }
            this.jobProperties = null;
            this.log.info(taskName + " executed for " + (System.currentTimeMillis() - timing) + " ms.");
            this.log.info(String.format("task executed, next fire time is %1$tF %1$tT", context.getNextFireTime()));
            this.runner = null;
            this.stopping.set(false);
            this.afterExecution(context, timing, error);
            Thread.currentThread().setName(threadName);
        }
        catch (Throwable t) {
            try {
                this.log.error("failed executing scheduled task", t);
                IncidentsLog.reportException((String)String.format("failed executing scheduled task '%s'", context.getJobDetail().getDescription()), (Throwable)t);
                error = t;
                throw new JobExecutionException("task failed", t);
            }
            catch (Throwable throwable) {
                this.runner = null;
                this.stopping.set(false);
                this.afterExecution(context, timing, error);
                Thread.currentThread().setName(threadName);
                throw throwable;
            }
        }
    }

    void afterExecution(JobExecutionContext context, long timing, Throwable error) {
        Metrics.get().timingAndEvent("profiling.scheduler." + Metrics.cleanKeyPart(this.getMetricKey()), timing);
        ScheduledTasksMonitor.executionFinished(context.getJobDetail(), error);
        LogicalStorage.reset();
    }

    void beforeExecution(JobExecutionContext context) throws Exception {
        LogicalStorage.get().authorizeAsSystem();
        ScheduledTasksMonitor.executionStarted(context.getJobDetail());
    }

    protected String getMetricKey() {
        return MiscUtil.getSimpleClassName(this.getClass());
    }

    public void interrupt() {
        this.stopping.set(true);
        if (this.runner != null) {
            this.runner.interrupt();
        }
    }

    public boolean isToBeStopped() {
        return this.stopping.get();
    }

    protected String getParameter(String key) {
        return this.jobProperties.getProperty(key);
    }

    protected int getParameter(String key, int def) {
        String val = this.jobProperties.getProperty(key);
        if (val == null) {
            return def;
        }
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            this.log.error("unable to parse param " + key, (Throwable)e);
            return def;
        }
    }

    protected boolean getParameter(String key, boolean defaultValue) {
        String value = this.jobProperties.getProperty(key);
        return !TextUtil.isBlank((String)value) ? value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") : defaultValue;
    }

    protected String getParameter(String key, String defaultValue) {
        return this.jobProperties.getProperty(key, defaultValue);
    }

    protected void debug(String ... args) {
        if (!this.log.isDebugEnabled()) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : args) {
            sb.append(s);
        }
        this.log.debug(sb.toString());
    }

    protected boolean isSendFailEmail() throws Exception {
        if (this.fails.get() < 1) {
            return true;
        }
        return this.fails() == this.fails.get();
    }

    protected boolean isSystem() {
        return false;
    }

    private int fails() throws Exception {
        AtomicInteger failResult = new AtomicInteger(0);
        LockUtil.lock((String)this.failTag(), () -> {
            TemporalObject temporalObject = this.findTemporalObject();
            if (Objects.isNull(temporalObject)) {
                temporalObject = this.createTemporalObject();
            }
            int alreadyFails = this.toInt(temporalObject.getData()) + 1;
            failResult.set(alreadyFails);
            if (alreadyFails == this.fails.get()) {
                alreadyFails = 0;
            }
            temporalObject.setData(this.toByteArray(alreadyFails));
            temporalObject.setExpired(MiscUtil.addDaysToDate((Date)new Date(), (int)1));
            AssetsStorage.get().save((BaseAsset)temporalObject);
        });
        return failResult.get();
    }

    private TemporalObject createTemporalObject() {
        TemporalObject temporalObject = new TemporalObject();
        temporalObject.setTag(this.failTag());
        temporalObject.setData(this.toByteArray(0));
        return temporalObject;
    }

    private TemporalObject findTemporalObject() {
        SearchQuery searchQuery = new SearchQuery();
        searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)this.failTag()));
        SearchResult searchResult = AssetsStorage.get().search(TemporalObject.class, searchQuery);
        return EntityStorageHelper.isEmpty((SearchResult)searchResult) ? null : (TemporalObject)searchResult.unique();
    }

    private int toInt(byte[] bytes) {
        return ByteBuffer.wrap(bytes).getInt();
    }

    private byte[] toByteArray(int i) {
        return ByteBuffer.allocate(4).putInt(i).array();
    }

    private String failTag() {
        return this.getClass().getName() + ".fail";
    }

    protected String getLockName(Properties properties) {
        return this.getClass().getName();
    }

    protected boolean allowConcurrentExecution() {
        return false;
    }
}

