/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.lockmanager.LocalLockManager;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.quartz.Job;
import org.quartz.JobExecutionContext;

public class BaseScheduledTaskTest
extends TestBase {
    private static volatile int counter = 0;
    private static final Queue<Integer> queue = new ConcurrentLinkedQueue<Integer>();

    @Before
    public void setUp() throws Exception {
        super.setUp();
        Environment.publish(LockManager.class, (Object)new LocalLockManager());
        this.reset();
    }

    @Test
    public void testDisallowConcurrentExecution() throws Exception {
        int threads = 20;
        this.run(false, 20);
        Assert.assertTrue((boolean)this.isSynchronized(20));
        Assert.assertFalse((boolean)this.isNotSynchronized(20));
        this.reset();
        this.run(true, 20);
        Assert.assertTrue((boolean)this.isNotSynchronized(20));
        Assert.assertFalse((boolean)this.isSynchronized(20));
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        this.reset();
    }

    private boolean isSynchronized(int threads) {
        Integer[] expected = (Integer[])IntStream.rangeClosed(1, threads).boxed().toArray(Integer[]::new);
        Integer[] actuals = queue.toArray(new Integer[0]);
        for (int i = 0; i < expected.length && i < actuals.length; ++i) {
            if (expected[i].equals(actuals[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isNotSynchronized(int threads) {
        Map<Integer, List<Integer>> collect = queue.stream().collect(Collectors.groupingBy(i -> i));
        return collect.values().stream().anyMatch(v -> v.size() > 1);
    }

    private void reset() {
        queue.clear();
        counter = 0;
    }

    private void run(boolean allowConcurent, int threads) throws InterruptedException {
        CountDownLatch countDownLatch = new CountDownLatch(1);
        List<Thread> workers = Stream.generate(() -> new TestThread((Job)new TestTask(allowConcurent), countDownLatch)).limit(threads).collect(Collectors.toList());
        workers.forEach(Thread::start);
        countDownLatch.countDown();
        for (Thread worker : workers) {
            worker.join();
        }
    }

    static class TestTask
    extends BaseScheduledTask {
        private final boolean allowConcurent;

        TestTask(boolean allowConcurent) {
            this.allowConcurent = allowConcurent;
        }

        @Override
        protected void doJob() throws Exception {
            int lc = counter;
            Thread.sleep(10L);
            int next = lc + 1;
            queue.offer(next);
            counter = next;
        }

        @Override
        void afterExecution(JobExecutionContext context, long timing, Throwable error) {
        }

        @Override
        void beforeExecution(JobExecutionContext context) {
        }

        @Override
        protected boolean allowConcurrentExecution() {
            return this.allowConcurent;
        }
    }

    static class TestThread
    extends Thread {
        final Job job;
        final CountDownLatch latch;

        TestThread(Job job, CountDownLatch latch) {
            this.job = job;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                this.latch.await();
                this.job.execute((JobExecutionContext)Mockito.mock(JobExecutionContext.class));
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"JobExecutionException", (Throwable)e, (Object[])new Object[0]);
            }
        }
    }
}

