/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.update.UpdateFile;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import org.java.plugin.PluginManager;
import org.java.plugin.boot.Application;
import org.java.plugin.boot.Boot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LicenceHelper {
    private static final Logger log = LoggerFactory.getLogger(LicenceHelper.class);
    private static final String USER_AGENT = "Mozilla/5.0";
    private static final String URL_FOR_IP_1 = "https://api.ipify.org/";
    private static final String URL_FOR_IP_2 = "http://bot.whatismyipaddress.com/";

    public static Date getLastUpdateDate() {
        UpdateIndexFile uif = UpdateIndexFile.get();
        ArrayList<UpdateFile> ufs = new ArrayList<UpdateFile>();
        ufs.addAll(uif.getClientPlugins());
        ufs.addAll(uif.getCommonPlugins());
        ufs.addAll(uif.getServerPlugins());
        ufs.add(uif.getSetupFile());
        Date updateDate = new Date(0L);
        for (UpdateFile uf : ufs) {
            Date modifDate;
            if (uf == null || !(modifDate = uf.getModified()).after(updateDate)) continue;
            updateDate = modifDate;
        }
        return updateDate;
    }

    public static void stopApplication() throws Exception {
        Boot.stopApplication((Application)((Application)PluginManager.lookup(LicenceHelper.class).getPlugin("com.gridnine.xtrip.server")));
        System.out.println("Licence not valid. Contact support service");
    }

    public static InetAddress getIpAddress() {
        InetAddress ip = null;
        try {
            ip = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return ip;
    }

    public static String getIpAddressStr() {
        String ipStr = null;
        try {
            ipStr = LicenceHelper.sendGet(URL_FOR_IP_1);
        }
        catch (Exception e) {
            log.error("", (Throwable)e);
        }
        if (TextUtil.isBlank((String)ipStr)) {
            InetAddress ip;
            try {
                ipStr = LicenceHelper.sendGet(URL_FOR_IP_2);
            }
            catch (Exception e) {
                log.error("", (Throwable)e);
            }
            if (TextUtil.isBlank((String)ipStr) && (ip = LicenceHelper.getIpAddress()) != null) {
                ipStr = ip.getHostAddress();
            }
        }
        return ipStr;
    }

    private static String sendGet(String url) throws Exception {
        String inputLine;
        URL obj = new URL(url);
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("User-Agent", USER_AGENT);
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        return response.toString();
    }

    private LicenceHelper() {
    }
}

