/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.lockmanager.LockManager;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.lockmanager.NamedLock;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.lockmanager.DistributedLockManager;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class LockMonitorTask
extends BaseScheduledTask {
    private String pattern = null;
    private int dead_time = 10;
    private final String PATTERN_KEY = "pattern";
    private final String DEAD_TIME_KEY = "dead-time";
    private static final String LOCK_PATH = "/xtrip/locks/";
    private static final byte[] SIGN = new byte[]{37, 5, 2, 0};

    @Override
    protected void configure(Properties properties) throws Exception {
        super.configure(properties);
        this.pattern = this.getParameter("pattern", null);
        this.dead_time = this.getParameter("dead-time", this.dead_time) * 60 * 1000;
    }

    @Override
    protected void doJob() throws Exception {
        DistributedLockManager lockManager = (DistributedLockManager)LockUtil.getLockManager();
        Method getZooKeeperMethod = lockManager.getClass().getDeclaredMethod("getZooKeeper", new Class[0]);
        getZooKeeperMethod.setAccessible(true);
        ZooKeeper zooKeeper = (ZooKeeper)getZooKeeperMethod.invoke((Object)lockManager, new Object[0]);
        this.processLocks(zooKeeper, LOCK_PATH, lockManager);
    }

    private void processLocks(ZooKeeper zooKeeper, String path, LockManager lockManager) throws Exception {
        List names;
        try {
            names = zooKeeper.getChildren(path, false);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        Pattern p = !TextUtil.isBlank((String)this.pattern) ? Pattern.compile(this.pattern) : null;
        for (String name : names) {
            String lockName = null;
            try {
                Matcher m;
                lockName = LockMonitorTask.getLockName(name);
                this.log.debug("process lock " + lockName);
                if (p != null && !(m = p.matcher(lockName)).matches()) continue;
                String nodePath = (!"/".equals(path) ? path : "") + "/" + name;
                this.processLock(zooKeeper, lockName, nodePath, lockManager);
            }
            catch (Throwable e) {
                this.log.error("error while process lock " + (lockName != null ? lockName : "(null)"), e);
            }
        }
    }

    private void processLock(ZooKeeper zooKeeper, String lockName, String path, LockManager lockManager) throws Exception {
        List names;
        try {
            names = zooKeeper.getChildren(path, false);
        }
        catch (KeeperException.NoNodeException e) {
            return;
        }
        Stat stat = new Stat();
        for (String name : names) {
            if (!name.startsWith("y-")) continue;
            String nodePath = (!"/".equals(path) ? path : "") + "/" + name;
            byte[] nodeData = zooKeeper.getData(nodePath, false, stat);
            Data data = nodeData != null && nodeData.length > 0 ? this.decodeData(nodeData) : null;
            if (null == data || data.date + (long)this.dead_time > System.currentTimeMillis()) continue;
            this.unlock(lockManager, lockName);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unlock(LockManager lockManager, String lockName) throws Exception {
        this.log.warn("dead lock detected " + lockName);
        try (NamedLock lock = lockManager.getLock((Object)lockName);){
            lock.unlock();
        }
    }

    private static String getLockName(String lockName) {
        return lockName.replace("$-", ".").replace("$2", "/").replace("$1", "\\").replace("$$", "$");
    }

    private Data decodeData(byte[] data) {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(data));
            byte[] sign = new byte[SIGN.length];
            if (in.read(sign) != sign.length) {
                return null;
            }
            if (!Arrays.equals(SIGN, sign)) {
                return null;
            }
            Data data2 = new Data();
            data2.date = in.readLong();
            data2.user = in.readUTF();
            data2.operation = in.readUTF();
            return data2;
        }
        catch (IOException e) {
            this.log.warn("error while decode data", (Throwable)e);
            return null;
        }
    }

    protected static class Data {
        public long date;
        public String user;
        public String operation;

        protected Data() {
        }
    }
}

