/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.ScheduledTaskSettings;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.SchedulerRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScheduledTasksMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(ScheduledTasksMonitor.class);
    private static final String TAG = "ScheduledTasksMonitor";
    private static final Counters COUNTERS = new Counters();

    static int getNowRinning() {
        return COUNTERS.getNowRunning();
    }

    static int getErrors() {
        return COUNTERS.getErrors();
    }

    public static void scheduled(final String uid, final ScheduledTaskSettings settings) {
        ScheduledTasksMonitor.doWithLock(uid, new Runnable(){

            @Override
            public void run() {
                MiscUtil.Pair<TemporalObject, ScheduledTaskInfo> pair = ScheduledTasksMonitor.getOrCreate(uid, settings.isLocal() ? Environment.getApplicationId() : "global");
                ScheduledTaskInfo info = (ScheduledTaskInfo)pair.getSecond();
                ScheduledTaskInfo.update(info, settings);
                info.setScheduled(new Date());
                info.setScheduledInstallationId(Environment.getApplicationId());
                ScheduledTasksMonitor.save(pair);
            }
        });
    }

    public static void unscheduled(final String uid, final ScheduledTaskSettings settings) {
        ScheduledTasksMonitor.doWithLock(uid, new Runnable(){

            @Override
            public void run() {
                MiscUtil.Pair<TemporalObject, ScheduledTaskInfo> pair = ScheduledTasksMonitor.getOrCreate(uid, settings.isLocal() ? Environment.getApplicationId() : "global");
                ScheduledTaskInfo info = (ScheduledTaskInfo)pair.getSecond();
                ScheduledTaskInfo.update(info, settings);
                info.setUnscheduled(new Date());
                info.setUnscheduledInstallationId(Environment.getApplicationId());
                ScheduledTasksMonitor.save(pair);
            }
        });
    }

    static void executionStarted(JobDetail jobDetail) {
        COUNTERS.executionStarted();
        final String settingsUid = jobDetail.getKey().getName();
        ScheduledTasksMonitor.doWithLock(settingsUid, new Runnable(){

            @Override
            public void run() {
                EntityContainer ctr = EntityStorage.get().load(ScheduledTaskSettings.class, settingsUid);
                if (ctr == null) {
                    return;
                }
                MiscUtil.Pair<TemporalObject, ScheduledTaskInfo> pair = ScheduledTasksMonitor.getOrCreate(settingsUid, ((ScheduledTaskSettings)ctr.getEntity()).isLocal() ? Environment.getApplicationId() : "global");
                ScheduledTaskInfo info = (ScheduledTaskInfo)pair.getSecond();
                info.setLastExecutionStarted(new Date());
                info.setLastExecutionInstallationId(Environment.getApplicationId());
                ScheduledTasksMonitor.save(pair);
            }
        });
    }

    static void executionFinished(JobDetail jobDetail, final Throwable error) {
        COUNTERS.executionFinished(error != null);
        final String settingsUid = jobDetail.getKey().getName();
        ScheduledTasksMonitor.doWithLock(settingsUid, new Runnable(){

            @Override
            public void run() {
                EntityContainer ctr = EntityStorage.get().load(ScheduledTaskSettings.class, settingsUid);
                if (ctr == null) {
                    return;
                }
                MiscUtil.Pair<TemporalObject, ScheduledTaskInfo> pair = ScheduledTasksMonitor.getOrCreate(settingsUid, ((ScheduledTaskSettings)ctr.getEntity()).isLocal() ? Environment.getApplicationId() : "global");
                ScheduledTaskInfo info = (ScheduledTaskInfo)pair.getSecond();
                info.setLastExecutionFinished(new Date());
                if (error != null) {
                    info.setLastError(error);
                    info.setLastErrorDate(new Date());
                    info.setLastErrorInstallationId(Environment.getApplicationId());
                }
                ScheduledTasksMonitor.save(pair);
            }
        });
    }

    public static ScheduledTaskInfo getTaskInfo(String key) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", (Object)key));
        List data = AssetsStorage.get().search(TemporalObject.class, query).getData();
        if (!data.isEmpty()) {
            try {
                return (ScheduledTaskInfo)new ObjectInputStream(new ByteArrayInputStream(((TemporalObject)data.get(0)).getData())).readObject();
            }
            catch (Exception e) {
                LOG.error("failed deserializing data", (Throwable)e);
            }
        }
        return null;
    }

    public static List<ScheduledTaskInfo> getTasksInfo() {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)TemporalObject.Property.tag.name(), (Object)TAG));
        query.getPreferredProperties().add(TemporalObject.Property.tag.name());
        List uids = AssetsStorage.get().search(TemporalObject.class, query).getData();
        ArrayList<ScheduledTaskInfo> result = new ArrayList<ScheduledTaskInfo>(uids.size());
        for (TemporalObject toUid : uids) {
            try {
                TemporalObject to = (TemporalObject)AssetsStorage.get().load(TemporalObject.class, toUid.getUid());
                if (to == null) continue;
                result.add((ScheduledTaskInfo)new ObjectInputStream(new ByteArrayInputStream(to.getData())).readObject());
            }
            catch (Exception e) {
                LOG.error("failed deserializing data", (Throwable)e);
            }
        }
        return result;
    }

    private static void doWithLock(String key, Runnable task) {
        String lockName = "scheduled-tasks-monitor-" + key;
        try {
            LockUtil.lock((String)lockName, (long)10L, (TimeUnit)TimeUnit.SECONDS, task::run, () -> LOG.warn("failed acquiring lock " + lockName));
        }
        catch (Exception e) {
            LOG.error("failed executing with lock " + lockName, (Throwable)e);
        }
    }

    static String buildKey(String settingsUid, String installationId) {
        return settingsUid + '|' + installationId;
    }

    static MiscUtil.Pair<TemporalObject, ScheduledTaskInfo> getOrCreate(String settingsUid, String installationId) {
        TemporalObject to;
        ScheduledTaskInfo info;
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)"uid", (Object)ScheduledTasksMonitor.buildKey(settingsUid, installationId)));
        List data = AssetsStorage.get().search(TemporalObject.class, query).getData();
        if (data.isEmpty()) {
            info = new ScheduledTaskInfo(settingsUid, installationId);
            to = new TemporalObject(info.getKey());
            to.setTag(TAG);
            to.setReferenceType(ScheduledTaskSettings.class.getName());
            to.setReferenceUid(settingsUid);
        } else {
            to = (TemporalObject)data.get(0);
            try {
                info = (ScheduledTaskInfo)new ObjectInputStream(new ByteArrayInputStream(to.getData())).readObject();
            }
            catch (Exception e) {
                LOG.error("failed deserializing data", (Throwable)e);
                info = new ScheduledTaskInfo(settingsUid, Environment.getApplicationId());
            }
        }
        return new MiscUtil.Pair((Object)to, (Object)info);
    }

    static void save(MiscUtil.Pair<TemporalObject, ScheduledTaskInfo> pair) {
        TemporalObject to = (TemporalObject)pair.getFirst();
        ScheduledTaskInfo taskInfo = (ScheduledTaskInfo)pair.getSecond();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            new ObjectOutputStream(baos).writeObject(taskInfo);
            to.setData(baos.toByteArray());
        }
        catch (Exception e) {
            LOG.error("failed serializing data", (Throwable)e);
            to.setData(new byte[0]);
        }
        Date nextFireTime = Optional.ofNullable(taskInfo.getTrigger()).map(Trigger::getNextFireTime).filter(d -> d.after(new Date())).orElse(MiscUtil.addHoursToDate((Date)new Date(), (int)48));
        to.setExpired(MiscUtil.addHoursToDate((Date)nextFireTime, (int)1));
        AssetsStorage.get().save((BaseAsset)to);
        LOG.debug(String.format("task info updated for %s (%s)", taskInfo.getName(), taskInfo.getSettingsUid()));
    }

    private ScheduledTasksMonitor() {
    }

    private static class Counters {
        private final AtomicLong time = new AtomicLong();
        private final AtomicBoolean flag = new AtomicBoolean();
        private final AtomicInteger nowRunning = new AtomicInteger();
        private final AtomicInteger errors = new AtomicInteger();
        private final AtomicInteger errors2 = new AtomicInteger();

        Counters() {
        }

        void executionStarted() {
            this.roll();
            this.nowRunning.incrementAndGet();
        }

        void executionFinished(boolean withError) {
            this.roll();
            int value = this.nowRunning.decrementAndGet();
            if (value < 0) {
                this.nowRunning.set(0);
            }
            if (withError) {
                this.errors2.incrementAndGet();
            }
        }

        int getNowRunning() {
            this.roll();
            return this.nowRunning.get();
        }

        int getErrors() {
            this.roll();
            return this.errors.get();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void roll() {
            long now = System.currentTimeMillis();
            long d = TimeUnit.MILLISECONDS.toSeconds(now - this.time.get());
            if (d > 120L) {
                if (this.flag.compareAndSet(false, true)) {
                    try {
                        this.time.set(now);
                        this.errors.set(0);
                        this.errors2.set(0);
                    }
                    finally {
                        this.flag.set(false);
                    }
                }
            } else if (d > 60L && this.flag.compareAndSet(false, true)) {
                try {
                    this.time.set(now);
                    this.errors.set(this.errors2.getAndSet(0));
                }
                finally {
                    this.flag.set(false);
                }
            }
        }
    }

    public static class ScheduledTaskInfo
    implements Serializable {
        private static final long serialVersionUID = -398503460080745294L;
        private final String settingsUid;
        private final String installationId;
        private transient ScheduledTaskSettings settings;
        private String name;
        private boolean local;
        private String cron;
        private Long period;
        private String scheduledInstallationId;
        private Date scheduled;
        private String unscheduledInstallationId;
        private Date unscheduled;
        private String lastExecutionInstallationId;
        private Date lastExecutionStarted;
        private Date lastExecutionFinished;
        private String lastErrorInstallationId;
        private Date lastErrorDate;
        private Throwable lastError;

        static void update(ScheduledTaskInfo info, ScheduledTaskSettings settings) {
            info.name = settings.getName();
            info.local = settings.isLocal();
            info.cron = settings.getCron();
            info.period = settings.getPeriod();
        }

        ScheduledTaskInfo(String uid, String instId) {
            this.settingsUid = uid;
            this.installationId = instId;
        }

        public String getKey() {
            return ScheduledTasksMonitor.buildKey(this.settingsUid, this.installationId);
        }

        public String getSettingsUid() {
            return this.settingsUid;
        }

        public String getInstallationId() {
            return this.installationId;
        }

        public ScheduledTaskSettings getSettings() {
            if (this.settings == null) {
                EntityContainer ctr = EntityStorage.get().load(ScheduledTaskSettings.class, this.settingsUid);
                this.settings = ctr == null ? new ScheduledTaskSettings() : (ScheduledTaskSettings)ctr.getEntity();
            }
            return this.settings;
        }

        public Trigger getTrigger() {
            try {
                TriggerKey key = new TriggerKey(this.settingsUid);
                for (Scheduler scheduler : SchedulerRepository.getInstance().lookupAll()) {
                    Trigger trigger = scheduler.getTrigger(key);
                    if (trigger == null) continue;
                    return trigger;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public boolean isLocal() {
            return this.local;
        }

        public String getCron() {
            return this.cron;
        }

        public Long getPeriod() {
            return this.period;
        }

        public String getScheduledInstallationId() {
            return this.scheduledInstallationId;
        }

        void setScheduledInstallationId(String value) {
            this.scheduledInstallationId = value;
        }

        public Date getScheduled() {
            return this.scheduled;
        }

        void setScheduled(Date value) {
            this.scheduled = value;
        }

        public String getUnscheduledInstallationId() {
            return this.unscheduledInstallationId;
        }

        void setUnscheduledInstallationId(String value) {
            this.unscheduledInstallationId = value;
        }

        public Date getUnscheduled() {
            return this.unscheduled;
        }

        void setUnscheduled(Date value) {
            this.unscheduled = value;
        }

        public String getLastExecutionInstallationId() {
            return this.lastExecutionInstallationId;
        }

        void setLastExecutionInstallationId(String value) {
            this.lastExecutionInstallationId = value;
        }

        public Date getLastExecutionStarted() {
            return this.lastExecutionStarted;
        }

        void setLastExecutionStarted(Date value) {
            this.lastExecutionStarted = value;
        }

        public Date getLastExecutionFinished() {
            return this.lastExecutionFinished;
        }

        void setLastExecutionFinished(Date value) {
            this.lastExecutionFinished = value;
        }

        public String getLastErrorInstallationId() {
            return this.lastErrorInstallationId;
        }

        void setLastErrorInstallationId(String value) {
            this.lastErrorInstallationId = value;
        }

        public Date getLastErrorDate() {
            return this.lastErrorDate;
        }

        void setLastErrorDate(Date value) {
            this.lastErrorDate = value;
        }

        public Throwable getLastError() {
            return this.lastError;
        }

        void setLastError(Throwable value) {
            this.lastError = value;
        }
    }
}

