/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.Publisher;
import com.gridnine.xtrip.common.TimeService;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistry;
import com.gridnine.xtrip.common.helper.UniqueSettingsRegistryConfigurator;
import com.gridnine.xtrip.common.jmx.JmxBean;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistryConfigurator;
import com.gridnine.xtrip.common.meta.EnumItemRenamer;
import com.gridnine.xtrip.common.meta.EnumType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.meta.export.ExportMetaRegistry;
import com.gridnine.xtrip.common.meta.export.ExportMetadataProvider;
import com.gridnine.xtrip.common.meta.export.parser.ExportedObjectsMetadataXmlParser;
import com.gridnine.xtrip.common.meta.rest.RestMetaRegistry;
import com.gridnine.xtrip.common.meta.ui.UiMetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheActualStorage;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfiguration;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfigurator;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheData;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheUpdater;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECActualStorage;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfigurator;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECUpdater;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryDataModification;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.IbusManager;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.export.UrlConnectionInfoSettings;
import com.gridnine.xtrip.common.model.net.AuthorizationSettings;
import com.gridnine.xtrip.common.model.net.UpdateServerSettings;
import com.gridnine.xtrip.common.model.profiling.ApplicationProfilingData;
import com.gridnine.xtrip.common.model.profiling.Profiler;
import com.gridnine.xtrip.common.model.profiling.ProfilerState;
import com.gridnine.xtrip.common.model.profiling.ProfilingUtils;
import com.gridnine.xtrip.common.model.standard.helpers.URLConnectionHelper;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.security.acl.helper.AclPermissionsProvider;
import com.gridnine.xtrip.common.security.acl.helper.StandardAclPermissionsProvider;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironmentConfigurator;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.service.impl.ExecutorServiceFacadeImpl;
import com.gridnine.xtrip.common.update.RemoteUpdateHelper;
import com.gridnine.xtrip.common.update.UpdateIndexFile;
import com.gridnine.xtrip.common.usage.IndexUsageHandler;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.DesUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.JpfUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.ReflectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XmlEnumItemRenamer;
import com.gridnine.xtrip.server.Service;
import com.gridnine.xtrip.server.SeverApplicationExtender;
import com.gridnine.xtrip.server.ShutdownCoordinator;
import com.gridnine.xtrip.server.async.AsyncExecutorImpl;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerActualStorage;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerManager;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCache;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCacheCleaner;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCacheUpdater;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsProvider;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheData;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerActualStorage;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerManager;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsCache;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsCacheCleaner;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsCacheUpdater;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsProvider;
import com.gridnine.xtrip.server.configuration.BasicAppConfiguration;
import com.gridnine.xtrip.server.configuration.ServerConfiguration;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageConfigurator;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.common.UsersHelper;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorage;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageConfiguration;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageConfigurator;
import com.gridnine.xtrip.server.db.storage.hibernate.HibernatePhysicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.PhysicalStorage;
import com.gridnine.xtrip.server.db.storage.model.sn.SequenceNumberHelper;
import com.gridnine.xtrip.server.eventbus.EventBus;
import com.gridnine.xtrip.server.eventbus.EventBusConfigurator;
import com.gridnine.xtrip.server.eventbus.simple.SimpleEventBus;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.ibus.impl.standard.StandardIntegrationBusPublisher;
import com.gridnine.xtrip.server.index.usage.ServerIndexUsageHandler;
import com.gridnine.xtrip.server.jms.impl.activemq.JMSActiveMQPublisher;
import com.gridnine.xtrip.server.lockmanager.LockManagerPublisher;
import com.gridnine.xtrip.server.security.acl.handler.StandardAclEntryProvider;
import com.gridnine.xtrip.server.security.acl.helper.AclEntryProvider;
import com.gridnine.xtrip.server.security.acl.helper.AclHelper;
import com.gridnine.xtrip.server.setup.SetupManager;
import com.gridnine.xtrip.server.statistics.Statistics;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import com.gridnine.xtrip.server.tracker.LongRunningOperationsTracker;
import com.gridnine.xtrip.server.update.ServerRemoteUpdateHelper;
import com.gridnine.xtrip.server.update.db.SetupUpdateHelper;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanServer;
import org.java.plugin.PluginManager;
import org.java.plugin.registry.Extension;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerApplication
implements Disposable {
    static final Logger log = LoggerFactory.getLogger(ServerApplication.class);
    private ExtendedProperties configuration;
    private final Map<String, Service> services = new LinkedHashMap<String, Service>();
    private boolean updateMode;
    private boolean cleanupMode;
    private final AtomicBoolean started = new AtomicBoolean();

    public static void registerDictionariesCache() throws Exception {
        if (Environment.isPublished(DictionaryCache.class)) {
            return;
        }
        File cacheDirectory = new File(Environment.getTempFolder(), "dict-cache/");
        cacheDirectory.mkdirs();
        DictionaryCache cache = new DictionaryCache(new DictionaryCache.DataSource(){

            public DictionaryDataModification getModified(Date date, String dictionaryType, Set<String> ignoredDictionaryTypes) throws Exception {
                if (dictionaryType == null) {
                    return new DictionaryDataModification(new Date(), DictionaryStorage.get().loadAll(date, Collections.emptySet()), DictionaryStorage.get().getDeleted(date, Collections.emptySet()), DictionaryStorage.get().getResetTypes(date, Collections.emptySet()));
                }
                Class dict = XHelper.getClass((String)dictionaryType);
                return new DictionaryDataModification(new Date(), DictionaryStorage.get().loadAll(date, dict), DictionaryStorage.get().getDeleted(date, dict), DictionaryStorage.get().getResetTypes(date, dict));
            }

            public String getVersion() throws Exception {
                return LogicalStorage.get().getDbPropertiesStorage().getValue("dicts-version");
            }
        }, cacheDirectory, false);
        Environment.publish(DictionaryCache.class, (Object)cache);
    }

    private static boolean hasArg(String[] args, String arg) {
        if (args == null) {
            return false;
        }
        for (String arg2 : args) {
            if (!arg.equals(arg2)) continue;
            return true;
        }
        return false;
    }

    private static int getArgNo(String[] args, String arg) {
        int result = -1;
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                if (!arg.equals(args[i])) continue;
                return i;
            }
        }
        return result;
    }

    void init(ExtendedProperties config, String[] args) throws Exception {
        log.info("application initializing BEGIN");
        this.configuration = config;
        SeverApplicationExtender extender = null;
        Environment.publish((Object)new ServerConfiguration(config));
        Environment.publish((Object)this.createMetaRegistry());
        this.publishAppConfig();
        Environment.publish((Object)new LongRunningOperationsTracker(config));
        Environment.publish((Object)this.createUniqueSettingsRegistry());
        this.populateSystemProperties(config);
        String extenderClassName = System.getProperty("server-application-extender.className");
        if (!TextUtil.isBlank((String)extenderClassName)) {
            extender = (SeverApplicationExtender)XHelper.getInstance((String)extenderClassName, (Object[])new Object[0]);
        }
        this.createShutdownCoordinator();
        if (ServerApplication.hasArg(args, "update") && this.confirm("Are you sure to update? (y/n)", "Update procedure is aborted. Server will start in normal mode.")) {
            this.updateMode = true;
            this.publishLockManager();
            this.publishExecutorService();
            this.publishTimeService();
            this.publishProfiler(config);
            this.publishJMS(config.getSubset("jms."));
            UsersHelper usersHelper = new UsersHelper();
            usersHelper.setUser(this.getConfiguration().getProperty("storage.system.account"));
            Environment.publish((Object)usersHelper);
            Environment.publish((Object)new UserData(usersHelper::getUser));
            Environment.publish((Object)this.createLocaleManager());
            this.publishLogicalStorage(config.getSubset("db."));
            this.publishAdvancedStorages();
            this.registerEntityCache();
            return;
        }
        Statistics.initializeLoggers();
        this.publishLockManager();
        this.publishExecutorService();
        this.publishTimeService();
        PollingConfiguration.setNewPolling(Boolean.parseBoolean(this.getConfiguration().getProperty("polling.modification.new", "false")));
        Environment.publish((Object)this.createLocaleManager());
        this.publishProfiler(config);
        Environment.publish(AsyncExecutor.class, (Object)((Object)new AsyncExecutorImpl()));
        Environment.publish((Object)this.createRestMetaRegistry());
        Environment.publish((Object)this.createUiMetaRegistry());
        Environment.publish(ExportMetadataProvider.class, (Object)this.createExportMetaRegistry());
        if (extender != null) {
            extender.publishValidationMessagesResourcesEnvironment();
        }
        SetupManager setupManager = null;
        if (ServerApplication.hasArg(args, "cleanup") && this.confirm("All current data  will be lost. Proceed anyway? (y/n)", "Cleanup is aborted. Server will start in normal mode.")) {
            this.cleanupMode = true;
        } else if (ServerApplication.hasArg(args, "cleanup_no_confirm")) {
            this.cleanupMode = true;
        }
        if (this.cleanupMode) {
            setupManager = new SetupManager();
        }
        this.publishJMS(config.getSubset("jms."));
        UsersHelper usersHelper = new UsersHelper();
        usersHelper.setUser(this.getConfiguration().getProperty("storage.system.account"));
        Environment.publish((Object)usersHelper);
        Environment.publish((Object)new UserData(usersHelper::getUser));
        this.publishLogicalStorage(config.getSubset("db."));
        this.publishAdvancedStorages();
        Environment.publish((Object)new SequenceNumberHelper());
        if (extender != null) {
            extender.publishCommonRegistry();
        }
        Environment.publish((Object)this.createAclResourcesEnvironment());
        if (setupManager != null) {
            long timing = System.currentTimeMillis();
            setupManager.doCleanup((Properties)this.configuration);
            MiscUtil.logTiming((long)timing, (String)"cleanup done");
        }
        this.registerAssetsStorage();
        this.publishIndexUsageHandler();
        this.registerEntityCache();
        AclHelper.createAcl();
        ServerApplication.registerDictionariesCache();
        if (extender != null) {
            extender.registerCurrencyRateSuperCache();
        }
        int errorsCount = 0;
        int maxErrorsCount = 10;
        while (errorsCount < maxErrorsCount && !DictionaryCache.get().check()) {
            Thread.sleep(1000L);
            log.error("dictionary cache was not initialized, count = " + ++errorsCount);
        }
        if (errorsCount >= maxErrorsCount) {
            throw new Exception("unable to initialize dictionary cache");
        }
        Environment.publish((Object)this.createRulesEnvironment());
        if (setupManager != null && !this.updateMode) {
            long timing = System.currentTimeMillis();
            setupManager.doSetup((Properties)this.configuration);
            MiscUtil.logTiming((long)timing, (String)"setup done");
        } else {
            LogicalStorage.get().authorizeAsSystem((Properties)this.configuration);
        }
        Environment.publish((Object)this.createNumber2WordsConverterRegistry());
        this.registerStandardServices();
        this.registerJmxBeans();
        Environment.publish(IbusManager.class, (Object)new IbusManager(){

            public void sendAsync(String adapterId, Map<String, Object> data) throws Exception {
                IntegrationBusFacade.get().getRequestReplyAdapter(adapterId).sendAsync(data);
            }

            public Map<String, Object> processSync(String adapterId, Map<String, Object> data) throws Exception {
                IntegrationBusFacade.get().getRequestReplyAdapter(adapterId).processSync(data);
                return Collections.emptyMap();
            }
        });
        this.publishEventBus();
        this.checkUpdateSettings();
        log.info("application initializing END");
    }

    private void publishAppConfig() throws Exception {
        List exts = JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"AppConfiguration");
        if (exts.isEmpty()) {
            throw Xeption.forAdmin((String)"invalid plug-ins configuration, no extensions found for point com.gridnine.xtrip.server@AppConfiguration", (Object[])new Object[0]);
        }
        if (exts.size() > 1) {
            throw Xeption.forAdmin((String)"invalid plug-ins configuration, too many extensions of point com.gridnine.xtrip.server@AppConfiguration", (Object[])new Object[0]);
        }
        Environment.publish(BasicAppConfiguration.class, (Object)((BasicAppConfiguration)JpfUtil.getClass((Extension)((Extension)exts.iterator().next())).newInstance()));
    }

    private void publishIndexUsageHandler() {
        Environment.publish(IndexUsageHandler.class, (Object)((Object)new ServerIndexUsageHandler((Properties)this.configuration)));
    }

    private void checkUpdateSettings() throws IOException {
        Path path;
        List<String> result;
        boolean found;
        if (!"true".equals(System.getProperty("use-update-params-from-boot.properties"))) {
            return;
        }
        EntityContainer usCtr = EntityStorage.get().load(UpdateServerSettings.class, UniqueSettingsRegistry.get().getUidByClassName(UpdateServerSettings.class.getName()));
        EntityContainer ciCtr = EntityStorage.get().load(UrlConnectionInfoSettings.class, UniqueSettingsRegistry.get().getUidByClassName(UrlConnectionInfoSettings.class.getName()));
        if (usCtr != null && !(found = (result = Files.readAllLines(path = Paths.get(Environment.getConfigurationFolder() + File.separator + "boot.properties", new String[0]))).stream().anyMatch(s -> s.startsWith("com.gridnine.xtrip.server.update.url")))) {
            result.add(String.format("com.gridnine.xtrip.server.update.url=%s", ((UpdateServerSettings)usCtr.getEntity()).getUpdateUrl()));
            String userName = null;
            if (ciCtr != null && !TextUtil.isBlank((String)((UrlConnectionInfoSettings)ciCtr.getEntity()).getUserName())) {
                userName = ((UrlConnectionInfoSettings)ciCtr.getEntity()).getUserName();
            }
            if (usCtr != null && !TextUtil.isBlank((String)((UpdateServerSettings)usCtr.getEntity()).getUserName())) {
                userName = ((UpdateServerSettings)usCtr.getEntity()).getUserName();
            }
            if (!TextUtil.isBlank(userName)) {
                result.add(String.format("com.gridnine.xtrip.server.update.username=%s", userName));
            }
            String password = null;
            if (ciCtr != null && !TextUtil.isBlank((String)((UrlConnectionInfoSettings)ciCtr.getEntity()).getPassword())) {
                password = ((UrlConnectionInfoSettings)ciCtr.getEntity()).getPassword();
            }
            if (usCtr != null && !TextUtil.isBlank((String)((UpdateServerSettings)usCtr.getEntity()).getPassword())) {
                password = ((UpdateServerSettings)usCtr.getEntity()).getPassword();
            }
            if (!TextUtil.isBlank(password)) {
                result.add(String.format("com.gridnine.xtrip.server.update.password=%s", password));
            }
            Files.write(path, result, StandardOpenOption.TRUNCATE_EXISTING);
        }
    }

    private UniqueSettingsRegistry createUniqueSettingsRegistry() throws Exception {
        UniqueSettingsRegistry registry = new UniqueSettingsRegistry();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"UniqueSettingsRegistryConfigurator")) {
            log.debug("processing UniqueSettingsRegistryConfigurator from " + ext);
            try {
                Class cls = JpfUtil.getClass((Extension)ext, (String)"class");
                ((UniqueSettingsRegistryConfigurator)cls.newInstance()).configure(registry);
            }
            catch (Exception e) {
                log.error("failed configuring UniqueSettingsRegistry from " + ext, (Throwable)e);
            }
        }
        return registry;
    }

    private ExportMetadataProvider createExportMetaRegistry() {
        ExportMetaRegistry metaRegistry = new ExportMetaRegistry();
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm == null) {
            return metaRegistry;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"ExportModelDescriptors")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                try {
                    ExportedObjectsMetadataXmlParser.updateRegistry((ExportMetaRegistry)metaRegistry, (URL)JpfUtil.getResource((Extension.Parameter)param));
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)("failed configuring meta from " + param), (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        return metaRegistry;
    }

    private void publishLockManager() throws Exception {
        new LockManagerPublisher().publish();
    }

    private void publishLogicalStorage(ExtendedProperties subset) throws Exception {
        String storageUid;
        LogicalStorageRegistry lsr = new LogicalStorageRegistry();
        for (Object ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"LogicalStorageConfigurator")) {
            if (!BasicAppConfiguration.get().isExtensionLegal((Extension)ext)) continue;
            log.debug("configuring logical storage registry from " + ext);
            LogicalStorageConfigurator conf = (LogicalStorageConfigurator)JpfUtil.getClass((Extension)ext).newInstance();
            conf.configure(lsr);
            log.debug("completed configuring logical storage registry from " + ext);
        }
        Environment.publish((Object)lsr);
        HibernatePhysicalStorageRegistry hsr = new HibernatePhysicalStorageRegistry();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"HibernatePhysicalStorageConfigurator")) {
            log.debug("configuring hibernate storage registry from " + ext);
            try {
                HibernatePhysicalStorageConfigurator conf = (HibernatePhysicalStorageConfigurator)JpfUtil.getClass((Extension)ext).newInstance();
                conf.configure(hsr);
                log.debug("completed configuring hibernate storage registry from " + ext);
            }
            catch (Exception e) {
                log.debug("failed configuring hibernate storage registry from " + ext);
            }
        }
        Environment.publish((Object)hsr);
        File storageConfigFile = new File(Environment.getConfigurationFolder(), "storage.xml");
        if (storageConfigFile.isFile()) {
            Element configEl = DocumentBuilderHelper.parse((File)storageConfigFile).getDocumentElement();
            String className = configEl.getAttribute("className");
            XSerializable config = (XSerializable)XHelper.readObject((Element)configEl, (String)"configuration");
            PhysicalStorage ps = (PhysicalStorage)Class.forName(className).getConstructor(config.getClass()).newInstance(config);
            storageUid = ps.getUid();
            lsr.registerPhysicalStorage(ps);
        } else {
            log.info("no storage.xml found in configuration folder, falling back to default storage");
            String driverUid = subset.getProperty("uid");
            storageUid = "hibernate";
            HibernatePhysicalStorageConfiguration config = new HibernatePhysicalStorageConfiguration();
            config.setUid(storageUid);
            boolean found = false;
            for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"DatabaseDriver")) {
                if (!driverUid.equals(ext.getParameter("db-uid").valueAsString())) continue;
                found = true;
                config.setDriverClassName(ext.getParameter("driver-class").valueAsString());
                config.setAdapterClassName(ext.getParameter("adapter-class").valueAsString());
                config.setSqlDialectClassName(ext.getParameter("sql-dialect-class").valueAsString());
                break;
            }
            if (!found) {
                throw new IllegalStateException("no db driver is registered for uid " + driverUid);
            }
            config.setUser(subset.getProperty("user"));
            config.setUrl(subset.getProperty("url"));
            config.setEncodedPassword(subset.getProperty("password"));
            config.setPoolSize(Integer.parseInt(subset.getProperty("poolSize")));
            ExtendedProperties params = subset.getSubset("parameters");
            Map<String, String> cp = config.getParameters();
            Enumeration names = params.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                cp.put(name, params.getProperty(name));
            }
            if (this.cleanupMode) {
                config.getParameters().put("hibernate.hbm2ddl.auto", "create");
            }
            HibernatePhysicalStorage physicalStorage = new HibernatePhysicalStorage(config);
            lsr.registerPhysicalStorage(physicalStorage);
        }
        LogicalStorage logicalStorage = new LogicalStorage(storageUid, this.configuration);
        logicalStorage.setupScheme(this.cleanupMode);
        Environment.publish((Object)logicalStorage);
    }

    private void publishAdvancedStorages() throws Exception {
        File configFile = new File(Environment.getConfigurationFolder(), "adv.xml");
        if (!configFile.isFile()) {
            return;
        }
        LogicalStorageRegistry lsr = LogicalStorageRegistry.get();
        Element configEl = DocumentBuilderHelper.parse((File)configFile).getDocumentElement();
        NodeList nodes = configEl.getChildNodes();
        int count = nodes.getLength();
        for (int i = 0; i < count; ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element storage = (Element)node;
            String className = storage.getAttribute("className");
            XSerializable config = (XSerializable)XHelper.readObject((Element)storage, (String)"configuration");
            PhysicalStorage ps = (PhysicalStorage)Class.forName(className).getConstructor(config.getClass()).newInstance(config);
            lsr.registerPhysicalStorage(ps);
        }
    }

    private void publishExecutorService() {
        Environment.publish(ExecutorServiceFacade.class, (Object)new ExecutorServiceFacadeImpl());
    }

    private void publishTimeService() {
        Environment.publish(TimeService.class, (Object)new TimeService(){

            public long currentTimeMillis() {
                return System.currentTimeMillis();
            }

            public Date currentDate() {
                return new Date();
            }
        });
    }

    private void publishJMS(ExtendedProperties subset) throws Exception {
        new JMSActiveMQPublisher().publish((Properties)subset);
    }

    private void registerAssetsStorage() {
        AssetsCacheConfiguration configuration = new AssetsCacheConfiguration();
        configuration.setUpdatePeriodInSeconds(15);
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"AssetsCacheConfigurator")) {
            log.info("applying cache configurator from " + ext);
            try {
                AssetsCacheConfigurator configurator = (AssetsCacheConfigurator)JpfUtil.getClass((Extension)ext).newInstance();
                configurator.configure(configuration);
            }
            catch (Exception e) {
                log.error("failed configuring cache from " + ext, (Throwable)e);
            }
        }
        AssetsCacheServerManager.publish(new AssetsCacheServerManager.AssetsCacheServerFactory(){

            public AssetsCacheUpdater createUpdater(CacheDataModificationProvider<AssetReference<?>> provider, AssetsCacheConfiguration config, CacheState cacheState, AssetsCacheData cacheData) {
                return new AssetsCacheUpdater(provider, cacheData, cacheState, config);
            }

            public AssetsCacheActualStorage createActualStorage() {
                return new AssetsCacheServerActualStorage();
            }

            @Override
            public AssetsCacheServerModificationsCacheUpdater createUpdater(CacheDataModificationProvider<AssetReference<?>> modificationsProvider, AssetsCacheServerModificationsCache cache, AssetsCacheConfiguration config) {
                return new AssetsCacheServerModificationsCacheUpdater(modificationsProvider, cache, config);
            }

            @Override
            public AssetsCacheServerModificationsCache createModificationsCache(AssetsCacheConfiguration config) {
                return new AssetsCacheServerModificationsCache(config, new File(Environment.getDataFolder(), "assets-modifications/"));
            }

            public CacheDataModificationProvider<AssetReference<?>> createModificationProvider() {
                return new AssetsCacheServerModificationsProvider();
            }

            @Override
            public AssetsCacheServerModificationsCacheCleaner createCleaner(AssetsCacheServerModificationsCache cache) {
                return new AssetsCacheServerModificationsCacheCleaner(cache, 60, 72);
            }

            @Override
            public CacheDataModificationsServerCacheData<AssetReference<?>> createCacheData() {
                return new CacheDataModificationsServerCacheData();
            }

            public CacheState createState() {
                return new CacheState();
            }
        }, configuration);
        log.info("assets storage successfully registered");
    }

    private void registerJmxBeans() {
        log.info("registering jmx beans");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"JmxBean")) {
            log.debug("processing jmx bean from " + ext);
            try {
                JmxBean jmxBean = (JmxBean)JpfUtil.getClass((Extension)ext).newInstance();
                jmxBean.register(mBeanServer);
                log.info("registered jmx bean from " + ext);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed registering jmx bean from " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
        log.info("done registering jmx beans");
    }

    private void processSetupUpdate() throws Exception {
        LinkedHashMap<URL, Boolean> setupFilesUrls = new LinkedHashMap<URL, Boolean>();
        PluginManager pm = PluginManager.lookup((Object)this);
        boolean regionalSetupFileExists = false;
        if (pm != null) {
            for (Extension extension : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"DataUpdateFile")) {
                if (!BasicAppConfiguration.get().isExtensionLegal(extension)) continue;
                String param = extension.getParameter("url").valueAsString();
                URL url = pm.getPluginClassLoader(extension.getDeclaringPluginDescriptor()).getResource(param);
                if (null == url) {
                    throw new Exception("no update resource found, " + param);
                }
                setupFilesUrls.put(url, Boolean.FALSE);
            }
            for (Extension extension : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"SetupFolder")) {
                if (!BasicAppConfiguration.get().isExtensionLegal(extension)) continue;
                Extension.Parameter extParam = extension.getParameter("regionalVariation");
                if (extParam != null) {
                    regionalSetupFileExists = true;
                }
                String param = String.format("%s/update.xml", extension.getParameter("url").valueAsString());
                URL url = pm.getPluginClassLoader(extension.getDeclaringPluginDescriptor()).getResource(param);
                if (null == url) {
                    throw new Exception("no update resource found, " + param);
                }
                setupFilesUrls.put(url, Boolean.TRUE);
            }
        }
        if (!regionalSetupFileExists) {
            setupFilesUrls.put(new URL(String.format("file:///%s/setup/update.xml", Environment.getConfigurationFolder().getCanonicalPath())), Boolean.FALSE);
        }
        for (Map.Entry entry : setupFilesUrls.entrySet()) {
            if (IoUtil.isResourceExists((URL)((URL)entry.getKey()))) {
                if (this.cleanupMode) {
                    SetupUpdateHelper.cleanupDbStructure((URL)entry.getKey());
                    continue;
                }
                SetupUpdateHelper.updateDbStructure((URL)entry.getKey(), (Boolean)entry.getValue());
                continue;
            }
            log.warn(String.format("setup update file \"%s\" does not exist", entry.getKey()));
        }
    }

    private void publishProfiler(ExtendedProperties config) {
        ProfilerState initState = null;
        if (!this.updateMode) {
            try {
                ApplicationProfilingData appData = ProfilingUtils.fromByteArray((byte[])ProfilingUtils.loadApplicationProfilingData((String)"server"));
                if (appData != null) {
                    initState = appData.getProfilerState();
                }
            }
            catch (Throwable e) {
                log.error("unable to load profiler state", e);
            }
        }
        if (initState == null) {
            initState = new ProfilerState();
        }
        Profiler profiler = new Profiler(initState, (Properties)config.getSubset("profiling."));
        profiler.start();
        Environment.publish((Object)profiler);
    }

    private void registerEntityCache() throws Exception {
        AECConfiguration configuration = new AECConfiguration();
        configuration.setUpdatePeriodInSeconds(15);
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"AECConfigurator")) {
            log.info("applying cache configurator from " + ext);
            try {
                AECConfigurator configurator = (AECConfigurator)JpfUtil.getClass((Extension)ext).newInstance();
                configurator.configure(configuration);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed configuring cache from " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
        AECServerManager.publish(new AECServerManager.AECServerFactory(){

            public AECUpdater createUpdater(CacheDataModificationProvider<EntityReference<?>> dataProvider, AECData cacheData, CacheState cacheState, AECConfiguration config) {
                return new AECUpdater(dataProvider, cacheData, cacheState, config){

                    public void check() throws Exception {
                        if (!ServerApplication.this.isApplicationStarted()) {
                            return;
                        }
                        super.check();
                    }
                };
            }

            public CacheState createState() {
                return new CacheState();
            }

            public CacheDataModificationProvider<EntityReference<?>> createModificationProvider() {
                return new AECServerModificationsProvider();
            }

            public AECActualStorage createActualStorage() {
                return new AECServerActualStorage();
            }

            @Override
            public AECServerModificationsCache createModificationsCache(AECConfiguration config) {
                return new AECServerModificationsCache(config, new File(Environment.getDataFolder(), "entity-modifications/"));
            }

            @Override
            public AECServerModificationsCacheCleaner createCleaner(AECServerModificationsCache cache) {
                return new AECServerModificationsCacheCleaner(cache, 10, 2);
            }

            @Override
            public AECServerModificationsCacheUpdater createUpdater(CacheDataModificationProvider<EntityReference<?>> modificationsProvider, AECServerModificationsCache cache, AECConfiguration config) {
                return new AECServerModificationsCacheUpdater(modificationsProvider, cache, config){

                    @Override
                    protected void check() throws Exception {
                        if (!ServerApplication.this.isApplicationStarted()) {
                            return;
                        }
                        super.check();
                    }
                };
            }
        }, configuration);
    }

    private LocaleManager createLocaleManager() {
        LocaleManager localeManager = new LocaleManager();
        PluginManager pluginManager = PluginManager.lookup((Object)this);
        if (Objects.isNull(pluginManager)) {
            return localeManager;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"SupportedLocale")) {
            localeManager.registerSupportedLocale(TextUtil.str2locale((String)ext.getParameter("id").valueAsString()));
        }
        for (Extension extension : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"L10nResources")) {
            Extension.Parameter locationParameter = extension.getParameter("location");
            Extension.Parameter baseFileNameParameter = extension.getParameter("baseFileName");
            URL locationUrl = pluginManager.getPluginClassLoader(locationParameter.getDeclaringPluginDescriptor()).getResource(locationParameter.valueAsString());
            String baseFileName = Optional.ofNullable(baseFileNameParameter).map(Extension.Parameter::valueAsString).orElse(null);
            localeManager.getL10nResourceManager().registerResource(locationUrl, baseFileName);
        }
        Locale loc = TextUtil.str2locale((String)this.configuration.getProperty("defaultLocale"));
        if (loc != null) {
            if (localeManager.isSupportedLocale(loc)) {
                localeManager.setDefaultLocale(loc);
            } else {
                log.warn(String.format("unsupported locale %s provided in configuration as server default locale", loc));
            }
        }
        log.info(String.format("server default locale is %s", localeManager.getDefaultLocale()));
        return localeManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSystemProperties(ExtendedProperties config) throws Exception {
        PluginManager pm = PluginManager.lookup((Object)this);
        if ("true".equals(config.getProperty("midoffice.import-cleanup-enabled"))) {
            System.setProperty("midoffice.import-cleanup-enabled", "true");
        }
        if (pm == null) {
            return;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"SystemProperties")) {
            if (!BasicAppConfiguration.get().isExtensionLegal(ext)) continue;
            URL url = JpfUtil.getResource((Extension)ext, (String)"location");
            if (url == null) {
                throw new IllegalArgumentException("No resource found for id " + ext.getId() + " at location " + ext.getParameter("location").valueAsString() + " in plugin " + ext.getExtendedPluginId());
            }
            log.debug("loading system properties from " + url);
            Properties prop = new Properties();
            try (InputStream in = url.openStream();){
                prop.load(in);
            }
            for (Map.Entry<Object, Object> entry : prop.entrySet()) {
                String old = System.setProperty((String)entry.getKey(), (String)entry.getValue());
                if (old == null) continue;
                log.info(String.format("replaced system property %s, oldValue=%s, newValue=%s", entry.getKey(), old, entry.getValue()));
            }
            log.info("loaded system properties from " + url);
        }
    }

    private MetaRegistry createMetaRegistry() {
        MetaRegistry metaRegistry = new MetaRegistry();
        Environment.publish(XmlEnumItemRenamer.class, (value, className) -> {
            String result = value;
            EnumType enumType = (EnumType)metaRegistry.getEnums().get(className);
            if (enumType == null) {
                return result;
            }
            for (String renamerClass : enumType.getEnumItemRenamers()) {
                EnumItemRenamer renamer = metaRegistry.findEnumItemRenamer(renamerClass);
                if (renamer == null) continue;
                result = renamer.getNewName(result);
            }
            return result;
        });
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm == null) {
            return metaRegistry;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"MetaDescriptors")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                try {
                    metaRegistry.register(JpfUtil.getResource((Extension.Parameter)param));
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)("failed configuring meta from " + param), (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        return metaRegistry;
    }

    private RestMetaRegistry createRestMetaRegistry() {
        RestMetaRegistry result = new RestMetaRegistry();
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm == null) {
            return result;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"RestMetaDescriptors")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                try {
                    result.register(JpfUtil.getResource((Extension.Parameter)param));
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)("failed configuring rest meta from " + param), (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    private UiMetaRegistry createUiMetaRegistry() {
        UiMetaRegistry result = new UiMetaRegistry();
        PluginManager pm = PluginManager.lookup((Object)this);
        if (pm == null) {
            return result;
        }
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"UiMetaDescriptors")) {
            for (Extension.Parameter param : ext.getParameters("location")) {
                try {
                    result.register(JpfUtil.getResource((Extension.Parameter)param));
                }
                catch (Exception e) {
                    throw Xeption.forDeveloper((String)("failed configuring UI meta from " + param), (Throwable)e, (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    private RulesEnvironment createRulesEnvironment() {
        RulesEnvironment result = new RulesEnvironment();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"RulesEnvironmentHook")) {
            if (!BasicAppConfiguration.get().isExtensionLegal(ext)) continue;
            try {
                for (Extension.Parameter param : ext.getParameters("class")) {
                    ((RulesEnvironment.Hook)JpfUtil.getClass((Extension.Parameter)param).newInstance()).environmentInitialized(result);
                }
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed handling hook " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
        return result;
    }

    private Number2WordsConverterRegistry createNumber2WordsConverterRegistry() {
        Number2WordsConverterRegistry registry = new Number2WordsConverterRegistry();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"Number2WordsConverterRegistryConfigurator")) {
            try {
                ((Number2WordsConverterRegistryConfigurator)JpfUtil.getClass((Extension)ext).newInstance()).configure(registry);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed handling configurator " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
        return registry;
    }

    private AclResourcesEnvironment createAclResourcesEnvironment() {
        AclResourcesEnvironment environment = new AclResourcesEnvironment();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"AclResourcesEnvironmentConfigurator")) {
            try {
                ((AclResourcesEnvironmentConfigurator)JpfUtil.getClass((Extension)ext).newInstance()).configure(environment);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed handling configurator " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
        AclPermissionsProvider aclPermissionProvider = (AclPermissionsProvider)ReflectionUtil.createBySystemPropertyName((String)"acl-permissions-provider.className", (Logger)log, StandardAclPermissionsProvider::new);
        Environment.publish(AclPermissionsProvider.class, (Object)aclPermissionProvider);
        AclEntryProvider aclEntryProvider = (AclEntryProvider)ReflectionUtil.createBySystemPropertyName((String)"acl-entry-provider.className", (Logger)log, () -> new StandardAclEntryProvider());
        Environment.publish(AclEntryProvider.class, (Object)aclEntryProvider);
        return environment;
    }

    private boolean confirm(String question, String message) throws Exception {
        int c;
        System.out.println(question);
        do {
            try {
                c = System.in.read();
            }
            catch (IOException ioe) {
                return false;
            }
            if ('y' != (char)c && 'Y' != (char)c) continue;
            return true;
        } while ('n' == (char)c || 'N' == (char)c);
        System.out.println(message);
        return false;
    }

    public void setConfiguration(ExtendedProperties configuration) {
        this.configuration = configuration;
    }

    public ExtendedProperties getConfiguration() {
        return this.configuration;
    }

    public Service getService(String uid) {
        Service result = this.services.get(uid);
        if (result == null) {
            throw new IllegalArgumentException("unknown service UID " + uid);
        }
        return result;
    }

    public Service[] getServiceList() {
        return this.services.values().toArray(new Service[this.services.values().size()]);
    }

    protected void registerStandardServices() {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"Service")) {
            try {
                Service service = (Service)JpfUtil.getClass((Extension)ext).newInstance();
                service.configure(this.configuration);
                this.registerService(service);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed configuring service from " + ext), (Throwable)e, (Object[])new Object[0]);
            }
        }
    }

    public void registerService(Service service) {
        this.services.put(service.getUid(), service);
        log.info("registered service " + service);
    }

    void startApplication() throws Exception {
        long timing = System.currentTimeMillis();
        if (this.updateMode) {
            try {
                this.updateServer();
                MiscUtil.logTiming((long)timing, (String)"server started in update mode");
                log.info("server started in update mode");
            }
            catch (Exception e) {
                log.error("error occured during update", (Throwable)e);
                System.err.println("Error:" + e.getMessage());
                throw e;
            }
            return;
        }
        this.handlePublishers();
        if (!this.updateMode) {
            this.processSetupUpdate();
        }
        this.publishIntegrationBus();
        Environment.publish(this::stopStandardServices);
        for (Service service : this.services.values()) {
            try {
                long serviceTiming = System.currentTimeMillis();
                service.start();
                MiscUtil.logTiming((long)serviceTiming, (String)String.format("service \"%s\" started", service.getUid()));
                log.info(String.format("service \"%s\" started", service.getUid()));
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)("failed starting service " + service.getUid()), (Throwable)e, (Object[])new Object[0]);
            }
        }
        MiscUtil.logTiming((long)timing, (String)"server started");
        log.info("server started");
        this.started.set(true);
    }

    private void publishIntegrationBus() throws Exception {
        String impl = this.configuration.getProperty("ibus.implementation", "standard");
        if ("standard".equalsIgnoreCase(impl)) {
            new StandardIntegrationBusPublisher().publish();
            return;
        }
        throw Xeption.forDeveloper((String)("unsupported integration bus implementation " + impl), (Object[])new Object[0]);
    }

    private void publishEventBus() throws Exception {
        SimpleEventBus eventBus = new SimpleEventBus();
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.server", (String)"EventBusConfigurator")) {
            log.debug("configuring event bus from " + ext);
            EventBusConfigurator conf = (EventBusConfigurator)JpfUtil.getClass((Extension)ext).newInstance();
            conf.configure(eventBus);
            log.debug("completed configuring event bus from " + ext);
        }
        Environment.publish(EventBus.class, (Object)eventBus);
    }

    protected void handlePublishers() throws Exception {
        for (Extension ext : JpfUtil.getConnectedExtensions((String)"com.gridnine.xtrip.common", (String)"Publisher")) {
            log.debug("processing publisher from " + ext);
            Publisher publisher = (Publisher)JpfUtil.getClass((Extension)ext).newInstance();
            publisher.publish();
        }
    }

    private void updateServer() throws Exception {
        String updateUrlStr;
        EntityContainer<UpdateServerSettings> updateServerSettingsContainer = LogicalStorage.get().getEntityStorage().load(UpdateServerSettings.class, UniqueSettingsRegistry.get().getUidByClassName(UpdateServerSettings.class.getName()), new EntityStorageLoadParameters());
        AuthorizationSettings authSettings = null;
        if (updateServerSettingsContainer == null || "true".equals(System.getProperty("use-update-params-from-boot.properties"))) {
            updateUrlStr = this.configuration.getProperty("update.url");
            String userName = this.configuration.getProperty("update.username");
            String password = this.configuration.getProperty("update.password");
            if (!TextUtil.isBlank((String)userName) && !TextUtil.isBlank((String)password)) {
                authSettings = new AuthorizationSettings();
                authSettings.setUserName(userName);
                authSettings.setPassword(password);
            }
        } else {
            updateUrlStr = ((UpdateServerSettings)updateServerSettingsContainer.getEntity()).getUpdateUrl();
            if (!TextUtil.isBlank((String)((UpdateServerSettings)updateServerSettingsContainer.getEntity()).getUserName())) {
                authSettings = new AuthorizationSettings();
                authSettings.setUserName(((UpdateServerSettings)updateServerSettingsContainer.getEntity()).getUserName());
                authSettings.setPassword(((UpdateServerSettings)updateServerSettingsContainer.getEntity()).getPassword());
            }
        }
        if (TextUtil.isBlank((String)updateUrlStr)) {
            log.error("update repository URL is undefined");
            System.out.println("Update repository URL is undefined.");
            System.out.println("Update is aborted. Fix property file.");
            throw new Exception("update failed.");
        }
        File localRepositoryDir = new File(Environment.getDataFolder(), "update-repository/");
        if (!localRepositoryDir.exists() && !localRepositoryDir.mkdirs()) {
            log.error("unable to create local update repository");
            System.out.println("Unable to create local update repository.");
            throw new Exception("update failed.");
        }
        URL localRepository = IoUtil.file2url((File)localRepositoryDir);
        URL remoteRepository = new URL(updateUrlStr);
        UpdateIndexFile localIndexFile = new UpdateIndexFile();
        localIndexFile.readFromXml(new URL(localRepository, "index.xml"));
        UpdateIndexFile remoteIndexFile = new UpdateIndexFile();
        byte[] content = URLConnectionHelper.getContent((URL)new URL(remoteRepository, "index.xml"), (AuthorizationSettings)authSettings);
        if (content == null) {
            log.error(String.format("Unable load index file from remote update repository %s.", remoteRepository.toString()));
            System.out.println(String.format("Unable load index file from remote update repository %s.", remoteRepository.toString()));
            throw new Exception("update failed.");
        }
        remoteIndexFile.readFromStream((InputStream)new ByteArrayInputStream(content));
        if (!MiscUtil.equals((Object)localIndexFile.getCheckSum(), (Object)remoteIndexFile.getCheckSum())) {
            log.info(String.format("found updates at remote server %s", updateUrlStr));
            System.out.println(String.format("Found updates on remote server %s.", updateUrlStr));
            System.out.println("Starting download.");
            ServerRemoteUpdateHelper.synchronizeRepositories(localRepository, remoteRepository, remoteIndexFile, authSettings);
            RemoteUpdateHelper.updateFileSizes((UpdateIndexFile)remoteIndexFile, (File)IoUtil.url2file((URL)localRepository));
            remoteIndexFile.saveToXml(new File(localRepositoryDir, "index.xml"));
            System.out.println("Download done.");
        } else {
            log.info("local update repository is up-to-date");
            System.out.println("Local update repository is up-to-date. Skipping download.");
        }
        log.info("starting update of working directory");
        System.out.print("Starting update of working directory...");
        File pluginsDir = new File(Environment.getRootFolder(), "plugins/");
        File setupDir = new File(Environment.getConfigurationFolder(), "setup/");
        ServerRemoteUpdateHelper.updateServerFromLocalRepository(localRepositoryDir, pluginsDir, setupDir);
        log.info(String.format("server was successfully updated, new checksum is %s", remoteIndexFile.getCheckSum()));
        System.out.println(" done.");
        System.out.println("Server was successfully updated.");
        System.out.println("Please restart server.");
    }

    protected void stopStandardServices() {
        if (this.updateMode) {
            return;
        }
        ArrayList<Service> list = new ArrayList<Service>(this.services.values());
        Collections.reverse(list);
        for (Service service : list) {
            try {
                long serviceTiming = System.currentTimeMillis();
                service.stop();
                MiscUtil.logTiming((long)serviceTiming, (String)String.format("service \"%s\" stopped", service.getUid()));
                log.info(String.format("service \"%s\" stopped", service.getUid()));
            }
            catch (Exception e) {
                log.error("failed stopping service " + service.getUid(), (Throwable)e);
            }
        }
    }

    void stopApplication() throws Exception {
        try {
            if (Environment.isPublished(ShutdownCoordinator.class)) {
                ((ShutdownCoordinator)Environment.getPublished(ShutdownCoordinator.class)).shutdown();
            }
            long timing = System.currentTimeMillis();
            Environment.dispose();
            MiscUtil.logTiming((long)timing, (String)"server stopped");
            log.info("server stopped");
        }
        catch (Exception e) {
            log.error("failed stopping server application", (Throwable)e);
        }
    }

    private void createShutdownCoordinator() throws Exception {
        String clsName = System.getProperty("shutdown-coordinator.className");
        if (clsName != null) {
            ShutdownCoordinator shutdownCoordinator = (ShutdownCoordinator)this.getClass().getClassLoader().loadClass(clsName).newInstance();
            Environment.publish(ShutdownCoordinator.class, (Object)shutdownCoordinator);
        }
    }

    public void dispose() {
    }

    public boolean isApplicationStarted() {
        return this.started.get();
    }

    static {
        DesUtil.setGlobalKey((int[])new int[]{74, 51, 105, 51, 98, 62, 95, 88, 60, 41, 62, 105, 106, 106, 111, 45, 51, 103, 101, 95, 108, 109, 49, 78, 65, 50, 71, 83, 67, 68});
    }
}

