/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.logging.CentralizedLoggingSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.plugin.BaseApplicationPlugin;
import com.gridnine.xtrip.server.ServerApplication;
import com.gridnine.xtrip.server.logging.CentralizedLogAppender;
import com.gridnine.xtrip.server.logging.CentralizedLoggingSystemConnector;
import java.util.Enumeration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.java.plugin.boot.ServiceApplication;
import org.java.plugin.util.ExtendedProperties;
import org.slf4j.LoggerFactory;

public class ServerPlugin
extends BaseApplicationPlugin
implements ServiceApplication {
    protected void configure(ExtendedProperties config, String[] args) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                LoggerFactory.getLogger(((Object)((Object)ServerPlugin.this)).getClass()).error("un-handled error", e);
            }
        });
        boolean centralizedLoggingEnabled = ServerPlugin.isCentralizedLoggingEnabled(config);
        if (centralizedLoggingEnabled) {
            ServerPlugin.adjustRootLogger(config);
            CentralizedLoggingSystemConnector.setApplicationInitialized(false);
            CentralizedLoggingSystemConnector.startOrUpdateConfiguration(null);
        }
        ServerApplication app = new ServerApplication();
        try {
            app.init(config, args);
        }
        catch (Exception e) {
            Environment.dispose();
            throw e;
        }
        Environment.publish((Object)app);
        if (centralizedLoggingEnabled) {
            CentralizedLoggingSystemConnector.setApplicationInitialized(true);
            ServerPlugin.startCentralizedLogging();
        }
    }

    public void startApplication() throws Exception {
        if (!Environment.isPublished(ServerApplication.class)) {
            throw new IllegalStateException("application not initialized");
        }
        ((ServerApplication)Environment.getPublished(ServerApplication.class)).startApplication();
    }

    public void stopApplication() throws Exception {
        if (Environment.isPublished(ServerApplication.class)) {
            ((ServerApplication)Environment.getPublished(ServerApplication.class)).stopApplication();
        }
    }

    private static final void adjustRootLogger(ExtendedProperties config) {
        String levelConfig = config.getProperty("centralizedLoggingLevel");
        Level logLevel = Level.toLevel((String)levelConfig, (Level)Level.ERROR);
        CentralizedLogAppender elkAppender = new CentralizedLogAppender();
        elkAppender.setName("elk-AUTO_ADDED");
        elkAppender.setThreshold((Priority)logLevel);
        Logger rootLogger = Logger.getRootLogger();
        rootLogger.setLevel(logLevel);
        rootLogger.addAppender((Appender)elkAppender);
        Enumeration currentLoggers = LogManager.getCurrentLoggers();
        block0: while (currentLoggers.hasMoreElements()) {
            Logger logger = (Logger)currentLoggers.nextElement();
            if (logger.equals(rootLogger) || logger.getAdditivity()) continue;
            Enumeration appenders = logger.getAllAppenders();
            while (appenders.hasMoreElements()) {
                Appender appender = (Appender)appenders.nextElement();
                if (!(appender instanceof CentralizedLogAppender)) continue;
                continue block0;
            }
            logger.addAppender((Appender)elkAppender);
        }
    }

    private static final boolean isCentralizedLoggingEnabled(ExtendedProperties config) {
        return "true".equals(config.getProperty("centralizedLoggingEnabled"));
    }

    public static final void reAdjustRootLogger() {
        if (!Environment.isPublished(ServerApplication.class)) {
            return;
        }
        ServerApplication app = (ServerApplication)Environment.getPublished(ServerApplication.class);
        ExtendedProperties config = app.getConfiguration();
        if (!ServerPlugin.isCentralizedLoggingEnabled(config)) {
            return;
        }
        ServerPlugin.adjustRootLogger(config);
    }

    private static final void startCentralizedLogging() {
        String loggingSettingsId = "centralized-logging-settings-id";
        EntityContainer ctr = EntityStorage.get().load(CentralizedLoggingSettings.class, loggingSettingsId);
        if (ctr == null) {
            ctr = new EntityContainer(CentralizedLoggingSettings.class, loggingSettingsId);
            CentralizedLoggingSettings settings = (CentralizedLoggingSettings)ctr.getEntity();
            settings.setNetworkSendingEnabled(false);
            settings.setType(SystemSettingsType.OTHER);
            settings.setName("\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438 \u0446\u0435\u043d\u0442\u0440\u0430\u043b\u0438\u0437\u043e\u0432\u0430\u043d\u043d\u043e\u0433\u043e \u043b\u043e\u0433\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f");
            ctr.setCreatedBy("system");
            ctr.setModifiedBy("system");
            ctr.getVersionInfo().setVersionNotes("created automatically");
            EntityStorage.get().save(ctr, true);
        }
        CentralizedLoggingSystemConnector.startOrUpdateConfiguration((CentralizedLoggingSettings)ctr.getEntity());
    }
}

