/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.acl.AclAsset;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class AclAssetData
extends BaseAssetData<AclAsset> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="AclAssetData_modified")
    private Date modified;
    @Lob
    @Column(length=0x40000000)
    private byte[] data;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public AclAsset toAsset(Set<String> preferredProperties) throws Exception {
        AclAsset result = new AclAsset(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("data")) {
            result.setData(this.data);
        }
        return result;
    }

    @Override
    public void fromAsset(AclAsset asset) throws Exception {
        this.setUid(asset.getUid());
        this.data = asset.getData();
        this.modified = asset.getModified();
    }

    public void setData(byte[] value) {
        this.data = value;
    }

    public byte[] getData() {
        return this.data;
    }
}

