/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.security.acl.entry.AclEntry;
import com.gridnine.xtrip.common.security.acl.principal.AclGroup;
import com.gridnine.xtrip.common.security.acl.principal.AclUser;
import com.gridnine.xtrip.common.security.acl.rule.AclRule;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationStartedInterceptor;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AclOperationsLogInterceptor
implements AssetStorageOperationStartedInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AclOperationsLogInterceptor.class);
    private static final String SAVE_ASSET = "SAVE";
    private static final String DELETE_ASSET = "DELETE";

    public double getPriority() {
        return 0.0;
    }

    @Override
    public void beforeSave(SessionCallback ss, BaseAsset data) throws Exception {
        this.printLog(data, SAVE_ASSET);
    }

    @Override
    public void beforeDelete(SessionCallback ss, BaseAsset data) throws Exception {
        this.printLog(data, DELETE_ASSET);
    }

    private String getCommonInformation(String operationType) {
        String currentUser = UserData.get().getCurrentUser();
        return String.format("Operation type: %s; Current user: %s; ", operationType, currentUser);
    }

    private void printLog(BaseAsset data, String operationType) {
        if (data instanceof AclGroup) {
            AclGroup aclGroup = (AclGroup)data;
            String commonInfo = this.getCommonInformation(operationType);
            log.info(commonInfo + String.format("AclGroup, id = %s, name = %s, parentId = %s", aclGroup.getId(), aclGroup.getName(), aclGroup.getParentId()));
        } else if (data instanceof AclUser) {
            AclUser aclUser = (AclUser)data;
            String commonInfo = this.getCommonInformation(operationType);
            String infoMessage = commonInfo + String.format("AclUser, id = %s, name = %s, groupsIds = %s", aclUser.getId(), aclUser.getName(), aclUser.getGroupIds());
            AssetReference assetRef = new AssetReference((BaseAsset)aclUser);
            BaseAsset oldAsset = LogicalStorage.get().getAssetStorage().getLocalOperationContext(assetRef).getOldAsset();
            AclUser aclUserOld = (AclUser)oldAsset;
            if (Objects.nonNull(aclUserOld) && !aclUser.getGroupIds().equals(aclUserOld.getGroupIds())) {
                infoMessage = infoMessage + " oldGroupsIds = " + aclUserOld.getGroupIds();
            }
            log.info(infoMessage);
        } else if (data instanceof UserAccount) {
            UserAccount userAccount = (UserAccount)data;
            String commonInfo = this.getCommonInformation(operationType);
            log.info(commonInfo + String.format("UserAccount, loginName = %s, fullName = %s, notes = %s, activeLastUpdateDate = %s, passwordLastUpdateDate = %s, lastLoginDate = %s", userAccount.getLoginName(), userAccount.getFullName(), userAccount.getNotes(), userAccount.getActiveLastUpdateDate(), userAccount.getPasswordLastUpdateDate(), userAccount.getLastLoginDate()));
        } else if (data instanceof AclEntry) {
            AclEntry aclEntry = (AclEntry)data;
            String commonInfo = this.getCommonInformation(operationType);
            AssetReference assetRef = new AssetReference((BaseAsset)aclEntry);
            BaseAsset oldAsset = LogicalStorage.get().getAssetStorage().getLocalOperationContext(assetRef).getOldAsset();
            AclEntry aclEntryOld = (AclEntry)oldAsset;
            String rules = this.getRulesString(aclEntry.getRules());
            String oldRules = aclEntryOld == null ? "" : this.getRulesString(aclEntryOld.getRules());
            log.info(commonInfo + String.format("AclEntry, resourceId = %s, principalId = %s, rules = [%s]", aclEntry.getResourceId(), aclEntry.getPrincipalId(), rules) + (TextUtil.isSame((String)rules, (String)oldRules, (boolean)true, (boolean)true) ? "" : String.format(" oldRules = [%s]", oldRules)));
        }
    }

    private String getRulesString(Collection<AclRule> rules) {
        return rules.stream().map(r -> String.format("actions = [%s], restrictionGroups = [%s], propertyRestrictionGroups = [%s], fieldRestrictions = [%s]", r.getActions().stream().map(a -> String.format("operationId = %s, permission = %s", a.getOperationId(), a.getPermission())).collect(Collectors.joining("; ")), r.getRestrictionGroups().stream().map(rg -> String.format("type = %s, value = %s", rg.getType(), rg.getValue())).collect(Collectors.joining("; ")), r.getPropertyRestrictionGroups().stream().map(prg -> String.format("type = %s, value = %s", prg.getType(), prg.getValue())).collect(Collectors.joining(", ")), r.getFieldRestrictions().stream().map(prg -> String.format("fieldId = %s", prg.getFieldId())).collect(Collectors.joining(", ")))).collect(Collectors.joining(" | "));
    }
}

