/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.model.tasks.standard.RepairSecondaryStorageTaskSettings;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;

public class AssetDeleteInterceptor
implements AssetStorageOperationCompletedInterceptor {
    private static final String SETTINGS_UID = "REPAIR_SECONDARY_STORAGE_TASK_SETTINGS";

    @Override
    public boolean isSystem() {
        return true;
    }

    public double getPriority() {
        return 0.0;
    }

    @Override
    public void afterSave(SessionCallback ss, BaseAsset data) {
    }

    @Override
    public void afterDelete(SessionCallback ss, BaseAsset data) {
        if (AssetDeleteInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new DeletedObjectReference(data));
    }

    @Override
    public <A extends BaseAsset> void afterSave(SessionCallback ms, Iterable<A> assets) {
    }

    private static boolean ignoreIt(BaseAsset data) {
        if (data instanceof ModifiedObjectReference || data instanceof DeletedObjectReference || data.getClass().getName().equals("com.gridnine.xtrip.common.vip.sync.StorageSyncRecord") || data.getClass().getName().equals("com.gridnine.xtrip.server.gds.sirena2000.storage.SSLSessionEntryAsset") || data.getClass().getName().equals("com.gridnine.xtrip.server.gds.sirena2000.storage.SSLEntryLockAsset")) {
            return true;
        }
        RepairSecondaryStorageTaskSettings settings = AssetDeleteInterceptor.getSettings();
        return settings == null || !settings.isEnableToTrackDeletedObjects();
    }

    private static RepairSecondaryStorageTaskSettings getSettings() {
        EntityContainer etc = EntityStorage.get().load(RepairSecondaryStorageTaskSettings.class, SETTINGS_UID);
        return etc != null ? (RepairSecondaryStorageTaskSettings)etc.getEntity() : null;
    }
}

