/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.cache.common.OperationType;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;

public class AssetModificationInterceptor
implements AssetStorageOperationCompletedInterceptor {
    public double getPriority() {
        return 0.0;
    }

    @Override
    public void afterSave(SessionCallback ss, BaseAsset data) throws Exception {
        if (AssetModificationInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new ModifiedObjectReference(data, GroupsHandlerManager.getGroups((Object)data), OperationType.MODIFIED));
    }

    @Override
    public void afterDelete(SessionCallback ss, BaseAsset data) throws Exception {
        if (AssetModificationInterceptor.ignoreIt(data)) {
            return;
        }
        LogicalStorage.get().getAssetStorage().save(new ModifiedObjectReference(data, GroupsHandlerManager.getGroups((Object)data), OperationType.DELETED));
    }

    @Override
    public <A extends BaseAsset> void afterSave(SessionCallback ms, Iterable<A> assets) throws Exception {
        for (BaseAsset asset : assets) {
            if (AssetModificationInterceptor.ignoreIt(asset)) continue;
            LogicalStorage.get().getAssetStorage().save(new ModifiedObjectReference(asset, GroupsHandlerManager.getGroups((Object)asset), OperationType.MODIFIED));
        }
    }

    private static boolean ignoreIt(BaseAsset data) {
        if (!PollingConfiguration.isNewPolling()) {
            return true;
        }
        if (data instanceof ModifiedObjectReference || data instanceof DeletedObjectReference || data.getClass().getName().equals("com.gridnine.xtrip.common.vip.sync.StorageSyncRecord")) {
            return true;
        }
        return !AssetsCacheManager.get().isCached(data.getClass());
    }
}

