/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.model.cache.common.ContentType;
import com.gridnine.xtrip.common.model.tasks.standard.DeletedObjectReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class DeletedObjectReferenceData
extends BaseAssetData<DeletedObjectReference> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="DeletedObjectReferenceData_modified")
    private Date modified;
    @Column(nullable=false)
    private String refUid;
    @Column(nullable=false)
    private String refType;
    private String refCaption;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="DeletedObjectReferenceData_refDeleted")
    @Column(nullable=false)
    private Date refDeleted;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Index(name="DeletedObjectReferenceData_contentType")
    private ContentType contentType;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(DeletedObjectReference asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.refUid = asset.getRefUid();
        this.refType = asset.getRefType().getName();
        String rc = asset.getRefCaption();
        this.refCaption = rc != null && rc.length() > 255 ? rc.substring(0, 252) + "..." : rc;
        this.refDeleted = asset.getRefDeleted();
        this.contentType = asset.getContentType();
    }

    @Override
    public DeletedObjectReference toAsset(Set<String> preferredProperties) throws Exception {
        DeletedObjectReference result = new DeletedObjectReference(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        result.setRefUid(this.refUid);
        result.setRefType(XHelper.getClass((String)this.refType));
        result.setRefCaption(this.refCaption);
        result.setRefDeleted(this.refDeleted);
        result.setContentType(this.contentType);
        return result;
    }

    public String getRefUid() {
        return this.refUid;
    }

    public void setRefUid(String refUid) {
        this.refUid = refUid;
    }

    public String getRefType() {
        return this.refType;
    }

    public void setRefType(String refType) {
        this.refType = refType;
    }

    public String getRefCaption() {
        return this.refCaption;
    }

    public void setRefCaption(String refCaption) {
        this.refCaption = refCaption;
    }

    public Date getRefModified() {
        return this.refDeleted;
    }

    public void setRefModified(Date refModified) {
        this.refDeleted = refModified;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }
}

