/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.model.assets.DictionaryVersion;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class DictionaryVersionData
extends BaseAssetData<DictionaryVersion> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="DictionaryVersionData_modified")
    private Date modified;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date created = new Date();
    private String createdBy;
    private String modifiedBy;
    private String dataSource;
    @Lob
    private String versionNotes;
    @Index(name="DictionaryVersionData_dictId")
    @Column(nullable=false)
    private String dictId;
    @Index(name="DictionaryVersionData_code")
    @Column(nullable=false)
    private String code;
    @Lob
    @Column(length=0x40000000)
    private byte[] data;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public DictionaryVersion toAsset(Set<String> preferredProperties) throws Exception {
        DictionaryVersion result = new DictionaryVersion(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("created")) {
            result.setCreated(MiscUtil.cloneDate((Date)this.created));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("createdBy")) {
            result.setCreatedBy(this.createdBy);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("modifiedBy")) {
            result.setModifiedBy(this.modifiedBy);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("dataSource")) {
            result.setDataSource(this.dataSource);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("versionNotes")) {
            result.setVersionNotes(this.versionNotes);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("dictId")) {
            result.setDictId(this.dictId);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("code")) {
            result.setCode(this.code);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("data")) {
            result.setData(this.data);
        }
        return result;
    }

    @Override
    public void fromAsset(DictionaryVersion asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.created = asset.getCreated();
        this.createdBy = asset.getCreatedBy();
        this.modifiedBy = asset.getModifiedBy();
        this.dataSource = asset.getDataSource();
        this.versionNotes = asset.getVersionNotes();
        this.dictId = asset.getDictId();
        this.code = asset.getCode();
        this.data = asset.getData();
    }
}

