/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.assets.SysLogItem;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.db.storage.model.DataAggregator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;
import org.xml.sax.InputSource;

@Entity
public class SysLogItemData
extends BaseAssetData<SysLogItem> {
    private static final int MAX = 5000;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="SysLogItemData_modified")
    private Date modified;
    @Enumerated(value=EnumType.STRING)
    @Index(name="SysLogItemData_type")
    private SysLogItem.EventType eventType;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="SysLogItemData_date")
    private Date eventDate;
    @Index(name="SysLogItemData_referenceType")
    private String referenceType;
    @Index(name="SysLogItemData_referenceUid")
    private String referenceUid;
    private String referenceCaption;
    @Index(name="SysLogItemData_user")
    private String eventUser;
    @Index(name="SysLogItemData_tag")
    private String tag;
    @Enumerated(value=EnumType.STRING)
    @Index(name="SysLogItemData_messageType")
    private MessageType messageType;
    @Lob
    @Column(length=0x40000000)
    private byte[] messageData;
    private String valueOld;
    private String valueNew;
    private double metricValue;
    @Lob
    @Column(length=0x40000000)
    @Index(name="SysLogItemData_aggregatedData")
    private String aggregatedData;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    private static String aggregate(SysLogItem asset) {
        String result;
        DataAggregator aggregator = new DataAggregator();
        aggregator.aggregate(asset.getReferenceCaption());
        aggregator.aggregate(asset.getTag());
        aggregator.aggregate(asset.getValueOld());
        aggregator.aggregate(asset.getValueNew());
        if (asset.getMessage() != null) {
            aggregator.aggregate(LocaleManager.get().getL10nResourceManager().getMessage(asset.getMessage().getMessage()));
            aggregator.aggregate(asset.getMessage().getDetails());
        }
        if ((result = aggregator.toString()).length() > 5000) {
            result = SysLogItemData.truncate(result, 5000);
        }
        return result;
    }

    @Override
    public void fromAsset(SysLogItem asset) throws Exception {
        this.setUid(asset.getUid());
        this.aggregatedData = SysLogItemData.aggregate(asset);
        this.modified = asset.getModified();
        this.eventType = asset.getType();
        this.eventDate = asset.getDate();
        this.referenceType = asset.getReferenceType();
        this.referenceUid = asset.getReferenceUid();
        this.referenceCaption = asset.getReferenceCaption();
        this.eventUser = asset.getUser();
        this.tag = asset.getTag();
        if (asset.getMessage() != null) {
            this.messageType = asset.getMessage().getType();
            ByteArrayOutputStream strm = new ByteArrayOutputStream();
            XUtil.serialize((XSerializable)asset.getMessage(), (OutputStream)strm);
            this.messageData = strm.toByteArray();
        } else {
            this.messageType = null;
            this.messageData = new byte[0];
        }
        this.valueOld = asset.getValueOld();
        this.valueNew = asset.getValueNew();
        this.metricValue = asset.getMetricValue();
    }

    @Override
    public SysLogItem toAsset(Set<String> preferredProperties) throws Exception {
        SysLogItem result = new SysLogItem(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("type")) {
            result.setType(this.eventType);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("date")) {
            result.setDate(MiscUtil.cloneDate((Date)this.eventDate));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("referenceType")) {
            result.setReferenceType(this.referenceType);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("referenceUid")) {
            result.setReferenceUid(this.referenceUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("referenceCaption")) {
            result.setReferenceCaption(this.referenceCaption);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("user")) {
            result.setUser(this.eventUser);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("tag")) {
            result.setTag(this.tag);
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains("message")) && this.messageData != null && this.messageData.length > 0) {
            Message message = new Message();
            message.fromXML(DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)new ByteArrayInputStream(this.messageData))).getDocumentElement());
            result.setMessage(message);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("valueOld")) {
            result.setValueOld(this.valueOld);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("valueNew")) {
            result.setValueNew(this.valueNew);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("metricValue")) {
            result.setMetricValue(this.metricValue);
        }
        return result;
    }

    public byte[] getMessageData() {
        return this.messageData;
    }

    public void setMessageData(byte[] messageData) {
        this.messageData = messageData;
    }

    public static String truncate(String str, int size) {
        int p;
        int len = str.length();
        String result = size < len ? ((p = str.lastIndexOf(" ", size)) > 0 ? str.substring(0, p) : "") : str;
        return result;
    }

    public static enum Property {
        messageData;

    }
}

