/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.assets;

import com.gridnine.xtrip.common.model.assets.TemporalObject;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class TemporalObjectData
extends BaseAssetData<TemporalObject> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="TemporalObjectData_modified")
    private Date modified;
    @Index(name="TemporalObjectData_referenceUid")
    private String referenceUid;
    @Index(name="TemporalObjectData_referenceType")
    private String referenceType;
    @Index(name="TemporalObjectData_tag")
    private String tag;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="TemporalObjectData_expired")
    private Date expired;
    @Lob
    @Column(length=0x40000000)
    private byte[] data;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(TemporalObject asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.referenceUid = asset.getReferenceUid();
        this.referenceType = asset.getReferenceType();
        this.tag = asset.getTag();
        this.expired = asset.getExpired();
        this.data = asset.getData();
    }

    @Override
    public TemporalObject toAsset(Set<String> preferredProperties) throws Exception {
        TemporalObject result = new TemporalObject(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("referenceUid")) {
            result.setReferenceUid(this.referenceUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("referenceType")) {
            result.setReferenceType(this.referenceType);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("tag")) {
            result.setTag(this.tag);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("expired")) {
            result.setExpired(MiscUtil.cloneDate((Date)this.expired));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("data")) {
            result.setData(this.data);
        }
        return result;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public static enum Property {
        data;

    }
}

