/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.async;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.async.AsyncCommand;
import com.gridnine.xtrip.common.async.AsyncCommandOption;
import com.gridnine.xtrip.common.async.AsyncExecutor;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.AsyncCommandInfo;
import com.gridnine.xtrip.common.service.ExecutorServiceFacade;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Date;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncExecutorImpl
extends AsyncExecutor {
    private static final Logger log = LoggerFactory.getLogger(AsyncExecutorImpl.class);
    private static final String METRICS_KEY = "profiling.async";
    private static final String RUN_KEY = "profiling.async.local";
    private static final FastDateFormat DATE_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss.SSS");

    public void execute(String owner, AsyncCommand command, AsyncCommandOption ... options) {
        AbstractCollection enumOptions;
        if (TextUtil.isBlank((String)owner)) {
            throw new IllegalArgumentException("empty owner");
        }
        AbstractCollection abstractCollection = enumOptions = null == options || options.length == 0 ? null : Arrays.stream(options).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(AsyncCommandOption.class)));
        if (enumOptions != null && enumOptions.contains(AsyncCommandOption.LOCAL)) {
            AsyncExecutorImpl.local(owner, command, (EnumSet<AsyncCommandOption>)enumOptions);
            return;
        }
        AsyncCommandInfo info = new AsyncCommandInfo();
        info.setOwner(owner);
        try {
            info.setData(GZIPUtil.gzip((byte[])MiscUtil.serialize((Serializable)command)));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        info.setOptions((EnumSet)enumOptions);
        info.setNode(Environment.getApplicationId());
        AssetsStorage.get().save((BaseAsset)info);
    }

    private static String getId(String owner) {
        return TextUtil.nonBlank((String)owner) ? owner : "(no name)";
    }

    private static void local(String owner, AsyncCommand command, EnumSet<AsyncCommandOption> options) {
        String currentUser = LogicalStorage.get().getUser();
        Locale currentLocale = LocaleManager.get().getCurrentLocale();
        ExecutorServiceFacade.get().execute(() -> {
            long runStartTime = System.currentTimeMillis();
            try {
                boolean rerun = false;
                try {
                    try {
                        LogicalStorage.get().setUser(currentUser);
                        if (currentLocale != null) {
                            LocaleManager.get().setCurrentLocale(currentLocale);
                        }
                        String currentThreadName = Thread.currentThread().getName();
                        String id = AsyncExecutorImpl.getId(owner);
                        Thread.currentThread().setName(String.format("async-local-id:[%s]-thread:[%s]-start:[%s]", id, Long.toString(Thread.currentThread().getId()), DATE_FORMAT.format(new Date())));
                        try {
                            boolean fail;
                            block15: {
                                fail = false;
                                try {
                                    command.run();
                                }
                                catch (Throwable t) {
                                    fail = true;
                                    LoggerFactory.getLogger(AsyncExecutorImpl.class).error("unable to execute async command locally (" + String.valueOf(owner) + ")", t);
                                    IncidentsLog.reportException((String)("unable to execute async command locally (" + String.valueOf(owner) + ")"), (Throwable)t);
                                    if (options == null || !options.contains(AsyncCommandOption.RERUN_ON_EXCEPTION) || options.contains(AsyncCommandOption.STRICTLY_SINGLE_RUN)) break block15;
                                    rerun = true;
                                }
                            }
                            Metrics.get().timingAndEvent(RUN_KEY + (fail ? ".unhandled" : ".processed"), runStartTime);
                            String graphiteId = Metrics.cleanKeyPart(id);
                            Metrics.get().timingAndEvent("profiling.async.local.id." + graphiteId + (fail ? ".unhandled" : ".processed"), runStartTime);
                        }
                        finally {
                            Thread.currentThread().setName(currentThreadName);
                        }
                    }
                    finally {
                        Metrics.get().timingAndEvent("profiling.async.local.all", runStartTime);
                    }
                }
                finally {
                    if (rerun) {
                        AsyncExecutorImpl.local(owner, command, options);
                    }
                }
            }
            catch (Throwable t) {
                log.error("an unexpected error has occurred while execute async command (" + String.valueOf(owner) + ")", t);
                IncidentsLog.reportException((String)("an unexpected error has occurred while execute async command (" + String.valueOf(owner) + ")"), (Throwable)t);
                Metrics.get().timingAndEvent("profiling.async.local.fail", runStartTime);
                Metrics.get().timingAndEvent("profiling.async.local.id." + Metrics.cleanKeyPart(AsyncExecutorImpl.getId(owner)) + ".fail", runStartTime);
            }
        });
    }

    public static AsyncExecutor getTest() {
        return new AsyncExecutor(){

            public void execute(String owner, AsyncCommand command, AsyncCommandOption ... options) {
                AbstractCollection enumOptions;
                if (TextUtil.isBlank((String)owner)) {
                    throw new IllegalArgumentException("empty owner");
                }
                AbstractCollection abstractCollection = enumOptions = null == options || options.length == 0 ? null : Arrays.stream(options).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(AsyncCommandOption.class)));
                if (null == enumOptions || !enumOptions.contains(AsyncCommandOption.LOCAL)) {
                    try {
                        MiscUtil.serialize((Serializable)command);
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                }
                AsyncExecutorImpl.local(owner, command, (EnumSet)enumOptions);
            }
        };
    }
}

