/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.auth;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.assets.UserAccount;
import com.gridnine.xtrip.common.rpc.ServiceException;
import com.gridnine.xtrip.common.util.AuthUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.io.Serializable;
import java.security.GeneralSecurityException;
import java.util.Date;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthHelper {
    private static final Logger log = LoggerFactory.getLogger(AuthHelper.class);

    public static String extractUserLoginFromToken(Serializable tokenObj) {
        String[] arr = AuthUtil.decryptToken((Serializable)tokenObj);
        if (arr == null) {
            throw new RuntimeException("Cannot get login name");
        }
        return arr[0];
    }

    public static boolean validateAuthToken(Serializable tokenObj) throws ServiceException {
        return AuthHelper.validateAuthToken(tokenObj, false);
    }

    public static boolean validateAuthToken(Serializable tokenObj, boolean skipAclUserCheck) throws ServiceException {
        return AuthHelper.validateAuthToken(AuthHelper.getUserInfo(tokenObj), skipAclUserCheck);
    }

    public static boolean validateAuthToken(UserInfo user) throws ServiceException {
        return AuthHelper.validateAuthToken(user, false);
    }

    public static boolean validateAuthToken(UserInfo user, boolean skipAclUserCheck) throws ServiceException {
        try {
            LogicalStorage.get().authorize(user.getLogin(), user.getPassword().toCharArray(), skipAclUserCheck);
            log.debug("auth token validated, user=" + user.getLogin());
            return true;
        }
        catch (GeneralSecurityException gse) {
            log.warn("auth token invalid, user=" + user.getLogin());
            return false;
        }
        catch (Exception e) {
            log.error("token validation failed", (Throwable)e);
            throw new ServiceException("token validation failed");
        }
    }

    public static UserInfo getUserInfo(Serializable tokenObj) {
        String[] decryptToken = AuthUtil.decryptToken((Serializable)tokenObj);
        if (Objects.isNull(decryptToken)) {
            throw new IllegalArgumentException("bad token");
        }
        return new UserInfo(decryptToken[0], decryptToken[1]);
    }

    public static void updateLastLoginDate(String userName) {
        UserAccount userAccount = (UserAccount)AssetsStorage.get().find(UserAccount.class, UserAccount.Property.loginName.name(), (Object)userName);
        if (userAccount == null) {
            return;
        }
        userAccount.setLastLoginDate(new Date());
        AssetsStorage.get().save((BaseAsset)userAccount);
    }

    private static class UserInfo {
        private final String login;
        private final String password;

        public UserInfo(String login, String password) {
            this.login = login;
            this.password = password;
        }

        public String getLogin() {
            return this.login;
        }

        public String getPassword() {
            return this.password;
        }
    }
}

