/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.asset.StandardAssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.db.DbInterceptor;
import com.gridnine.xtrip.server.jms.JMSFacade;
import java.util.HashSet;
import java.util.Set;

public class AssetsCacheDBOperationsInterceptor
implements DbInterceptor {
    private static final ThreadLocal<Set<ModificationData<AssetReference<?>>>> pool = new ThreadLocal();

    @Override
    public double getPriority() {
        return 11.0;
    }

    @Override
    public void afterLoad(Object data, Object loadContext) {
    }

    @Override
    public void afterDelete(Object data) {
    }

    @Override
    public void beforeSave(Object data) {
    }

    @Override
    public void afterBeginUnitOfWork() {
    }

    @Override
    public void beforeCommit() {
    }

    @Override
    public void commitFailed() {
        if (pool.get() != null) {
            pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSucceded() {
        if (pool.get() == null) {
            return;
        }
        StandardAssetsCacheManager manager = this.getManager();
        if (manager == null) {
            pool.remove();
            return;
        }
        try {
            for (ModificationData<AssetReference<?>> item : pool.get()) {
                if (!manager.isCached(((AssetReference)item.getItem()).getType())) continue;
                manager.invalidate(item);
                ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("assets-cache", item);
            }
        }
        finally {
            pool.remove();
        }
    }

    @Override
    public void afterCancelUnitOfWork() {
        if (pool.get() != null) {
            pool.remove();
        }
    }

    void add(BaseAsset value) {
        this.add(new ModificationData((XSerializable)new AssetReference(value), GroupsHandlerManager.getGroups((Object)value)));
    }

    void add(ModificationData<AssetReference<?>> value) {
        if (this.getManager() == null) {
            return;
        }
        Set<ModificationData<AssetReference<?>>> set = pool.get();
        if (set == null) {
            set = new HashSet();
            pool.set(set);
        }
        set.add(value);
    }

    StandardAssetsCacheManager getManager() {
        return (StandardAssetsCacheManager)(Environment.isPublished(AssetsCacheManager.class) && StandardAssetsCacheManager.class.isAssignableFrom(((AssetsCacheManager)Environment.getPublished(AssetsCacheManager.class)).getClass()) ? (AssetsCacheManager)Environment.getPublished(AssetsCacheManager.class) : null);
    }
}

