/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.asset.DeletedAssetReference;
import com.gridnine.xtrip.common.model.cache.asset.StandardAssetsCacheManager;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheDBOperationsInterceptor;
import com.gridnine.xtrip.server.db.DbInterceptor;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.AssetStorageOperationCompletedInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetsCacheOperationCompletedInterceptor
implements AssetStorageOperationCompletedInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 11.0;
    }

    private AssetsCacheDBOperationsInterceptor getDbInterceptor() {
        if (!Environment.isPublished(LogicalStorageRegistry.class)) {
            this.log.warn(String.format("%s is not registered", LogicalStorageRegistry.class.getName()));
            return null;
        }
        for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
            if (!(item instanceof AssetsCacheDBOperationsInterceptor)) continue;
            return (AssetsCacheDBOperationsInterceptor)item;
        }
        this.log.error(String.format("%s is not registered", AssetsCacheDBOperationsInterceptor.class.getName()));
        return null;
    }

    @Override
    public void afterSave(SessionCallback ss, BaseAsset data) throws Exception {
        if (AssetsStorage.get() == null || this.getDbInterceptor() == null || this.getManager() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
    }

    @Override
    public void afterDelete(SessionCallback ss, BaseAsset data) throws Exception {
        if (AssetsStorage.get() == null || this.getDbInterceptor() == null || this.getManager() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
        if (this.getManager().isCached(data.getClass())) {
            AssetsStorage.get().save((BaseAsset)new DeletedAssetReference(data));
        }
    }

    @Override
    public <A extends BaseAsset> void afterSave(SessionCallback ms, Iterable<A> assets) throws Exception {
        if (AssetsStorage.get() == null || this.getDbInterceptor() == null || this.getManager() == null) {
            return;
        }
        for (BaseAsset asset : assets) {
            this.getDbInterceptor().add(asset);
        }
    }

    StandardAssetsCacheManager getManager() {
        return (StandardAssetsCacheManager)(Environment.isPublished(AssetsCacheManager.class) && StandardAssetsCacheManager.class.isAssignableFrom(((AssetsCacheManager)Environment.getPublished(AssetsCacheManager.class)).getClass()) ? (AssetsCacheManager)Environment.getPublished(AssetsCacheManager.class) : null);
    }
}

