/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheActualStorage;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.ArrayList;
import java.util.List;

public class AssetsCacheServerActualStorage
implements AssetsCacheActualStorage {
    public <A extends BaseAsset> SearchResult<A> search(Class<A> cls, SearchQuery query) throws Throwable {
        return LogicalStorage.get().getAssetStorage().search(cls, query);
    }

    public <A extends BaseAsset> ProjectionResult search(Class<A> cls, ProjectionQuery query) throws Throwable {
        return LogicalStorage.get().getAssetStorage().search(cls, query);
    }

    public <A extends BaseAsset> A save(A asset) throws Throwable {
        LogicalStorage.get().getAssetStorage().save(asset);
        return asset;
    }

    public <A extends BaseAsset> A save(A asset, boolean ignoreInterceptors) throws Throwable {
        LogicalStorage.get().getAssetStorage().save(asset, ignoreInterceptors);
        return asset;
    }

    public <A extends BaseAsset> List<A> save(Iterable<A> assets) throws Throwable {
        return this.save(assets, false);
    }

    public <A extends BaseAsset> A load(Class<A> cls, String uid) throws Throwable {
        if (cls == null || uid == null) {
            return null;
        }
        return LogicalStorage.get().getAssetStorage().load(cls, uid);
    }

    public <A extends BaseAsset> List<A> save(Iterable<A> assets, boolean ignoreInterceptors) throws Throwable {
        LogicalStorage.get().getAssetStorage().save(assets, ignoreInterceptors);
        ArrayList<BaseAsset> result = new ArrayList<BaseAsset>();
        for (BaseAsset asset : assets) {
            result.add(asset);
        }
        return result;
    }

    public <A extends BaseAsset> void delete(A asset) throws Throwable {
        LogicalStorage.get().getAssetStorage().delete(asset);
    }

    public <A extends BaseAsset> void delete(A asset, boolean ignoreInterceptors) throws Throwable {
        LogicalStorage.get().getAssetStorage().delete(asset, ignoreInterceptors);
    }

    public <A extends BaseAsset> SearchResult<A> find(Class<A> cls, String propertyName, Object value) throws Throwable {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)propertyName, (Object)value));
        return LogicalStorage.get().getAssetStorage().search(cls, query);
    }
}

