/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.asset.cache.AssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheActualStorage;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheConfiguration;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheData;
import com.gridnine.xtrip.common.model.cache.asset.AssetsCacheUpdater;
import com.gridnine.xtrip.common.model.cache.asset.CachedAssetsStorage;
import com.gridnine.xtrip.common.model.cache.asset.StandardAssetsCacheManager;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCache;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCacheCleaner;
import com.gridnine.xtrip.server.cache.asset.AssetsCacheServerModificationsCacheUpdater;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheData;
import java.util.Collection;
import java.util.Date;

public class AssetsCacheServerManager
extends StandardAssetsCacheManager
implements Disposable {
    private final AssetsCacheServerModificationsCacheUpdater cacheUpdater;
    private final AssetsCacheServerModificationsCache cache;
    private final AssetsCacheServerModificationsCacheCleaner cacheCleaner;

    private AssetsCacheServerManager(AssetsCacheUpdater cacheUpdaterValue, AssetsCacheData cacheData, CachedAssetsStorage cachedStorage, CacheState cacheState, AssetsCacheServerModificationsCache modificationsCache, AssetsCacheServerModificationsCacheUpdater modificationsCacheUpdater, AssetsCacheServerModificationsCacheCleaner modificationsCacheCleaner, AssetsCacheConfiguration config) {
        super(cachedStorage, cacheUpdaterValue, cacheData, config);
        this.cache = modificationsCache;
        this.cacheUpdater = modificationsCacheUpdater;
        this.cacheCleaner = modificationsCacheCleaner;
    }

    public static void publish(AssetsCacheServerFactory factory, AssetsCacheConfiguration config) {
        CacheState cacheState = new CacheState();
        AssetsCacheActualStorage actualStorage = factory.createActualStorage();
        AssetsCacheData cacheData = new AssetsCacheData();
        CachedAssetsStorage storage = new CachedAssetsStorage(actualStorage, config, cacheData, cacheState);
        Environment.publish(AssetsStorage.class, (Object)storage);
        AssetsCacheServerModificationsCache modificationsCache = factory.createModificationsCache(config);
        AssetsCacheServerModificationsCacheUpdater modificationsCacheUpdater = factory.createUpdater(factory.createModificationProvider(), modificationsCache, config);
        AssetsCacheServerModificationsCacheCleaner cleaner = factory.createCleaner(modificationsCache);
        Environment.publish(AssetsCacheServerModificationsCache.class, (Object)modificationsCache);
        AssetsCacheUpdater cacheUpdater = factory.createUpdater(modificationsCache, config, cacheState, cacheData);
        Environment.publish(AssetsCacheManager.class, (Object)((Object)new AssetsCacheServerManager(cacheUpdater, cacheData, storage, cacheState, modificationsCache, modificationsCacheUpdater, cleaner, config)));
    }

    public void invalidate(Collection<ModificationData<AssetReference<?>>> refs) {
        for (ModificationData<AssetReference<?>> data : refs) {
            this.cache.registerUpdatedEntity(data, new Date());
        }
        super.invalidate(refs);
    }

    public void dispose() {
        this.cacheUpdater.dispose();
        this.cacheCleaner.dispose();
        super.dispose();
    }

    public void reset() {
        super.reset();
        this.cache.reset();
    }

    public static interface AssetsCacheServerFactory
    extends StandardAssetsCacheManager.AssetsCacheFactory {
        public CacheDataModificationsServerCacheData<AssetReference<?>> createCacheData();

        public AssetsCacheServerModificationsCache createModificationsCache(AssetsCacheConfiguration var1);

        public AssetsCacheServerModificationsCacheUpdater createUpdater(CacheDataModificationProvider<AssetReference<?>> var1, AssetsCacheServerModificationsCache var2, AssetsCacheConfiguration var3);

        public AssetsCacheServerModificationsCacheCleaner createCleaner(AssetsCacheServerModificationsCache var1);
    }
}

