/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.asset.DeletedAssetReference;
import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.cache.common.AssetReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModification;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;

public class AssetsCacheServerModificationsProvider
implements CacheDataModificationProvider<AssetReference<?>> {
    public CacheDataModification<AssetReference<?>> getModifications(Date timeStamp, Collection<String> classes) throws Exception {
        CacheDataModification result = new CacheDataModification();
        if (classes == null || classes.size() == 0) {
            return result;
        }
        HashSet<String> classNames = new HashSet<String>(classes);
        classNames.add(DeletedAssetReference.class.getName());
        Date date = new Date();
        result.setTimeStamp(date);
        if (!PollingConfiguration.isNewPolling()) {
            for (String className : classes) {
                SearchQuery query = new SearchQuery();
                if (timeStamp != null) {
                    query.getCriteria().getCriterions().add(SearchCriterion.ne((String)"modified", null));
                    query.getCriteria().getCriterions().add(SearchCriterion.ge((String)"modified", (Object)timeStamp));
                }
                for (BaseAsset item : LogicalStorage.get().getAssetStorage().search(XHelper.getClass((String)className), query).getData()) {
                    if (item instanceof DeletedAssetReference) {
                        DeletedAssetReference ref = (DeletedAssetReference)item;
                        result.getUpdatedReferences().put(new ModificationData((XSerializable)new AssetReference(ref.getAssetUid(), XHelper.getClass((String)ref.getAssetClassName()), ref.getAssetCaption()), (String[])null), item.getModified() == null ? date : item.getModified());
                        continue;
                    }
                    result.getUpdatedReferences().put(new ModificationData((XSerializable)new AssetReference(item.getUid(), item.getClass(), item.toString()), GroupsHandlerManager.getGroups((Object)item)), item.getModified() == null ? date : item.getModified());
                }
            }
        } else {
            SearchQuery query = new SearchQuery();
            if (timeStamp != null) {
                query.getCriteria().getCriterions().add(SearchCriterion.ge((String)"refModified", (Object)timeStamp));
            }
            SearchCriterion[] types = new SearchCriterion[classes.size()];
            int i = 0;
            for (String className : classes) {
                types[i++] = SearchCriterion.eq((String)"refType", (Object)className);
            }
            query.getCriteria().getCriterions().add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[0]));
            for (ModifiedObjectReference item : LogicalStorage.get().getAssetStorage().search(ModifiedObjectReference.class, query).getData()) {
                result.getUpdatedReferences().put(new ModificationData((XSerializable)new AssetReference(item.getRefUid(), item.getRefType(), item.getRefCaption()), item.getGroups()), item.getRefModified() == null ? date : item.getRefModified());
            }
        }
        return result;
    }
}

