/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.model.cache.asset.DeletedAssetReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class DeletedAssetReferenceData
extends BaseAssetData<DeletedAssetReference> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="DeletedAssetReferenceData_modified")
    private Date modified;
    @Column(nullable=false)
    private String assetUid;
    @Column(nullable=false)
    private String assetClassName;
    private String assetCaption;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(DeletedAssetReference asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.assetUid = asset.getAssetUid();
        this.assetClassName = asset.getAssetClassName();
        this.assetCaption = asset.getAssetCaption();
    }

    @Override
    public DeletedAssetReference toAsset(Set<String> preferredProperties) {
        DeletedAssetReference result = new DeletedAssetReference(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        result.setAssetUid(this.assetUid);
        result.setAssetClassName(this.assetClassName);
        result.setAssetCaption(this.assetCaption);
        return result;
    }
}

