/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.asset;

import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.cache.common.ContentType;
import com.gridnine.xtrip.common.model.cache.common.OperationType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class ModifiedObjectReferenceData
extends BaseAssetData<ModifiedObjectReference> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ModifiedObjectReferenceData_modified")
    private Date modified;
    @Column(nullable=false)
    private String refUid;
    @Column(nullable=false)
    private String refType;
    private String refCaption;
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="ModifiedObjectReferenceData_refModified")
    @Column(nullable=false)
    private Date refModified;
    @Lob
    @Column(length=0x40000000)
    @Index(name="ModifiedObjectReferenceData_groups")
    private String groups;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    @Index(name="ModifiedObjectReferenceData_contentType")
    private ContentType contentType;
    @Column(nullable=false)
    @Enumerated(value=EnumType.STRING)
    private OperationType operationType;

    @Override
    public Date getModified() {
        return this.modified;
    }

    @Override
    public void setModified(Date date) {
        this.modified = date;
    }

    @Override
    public void fromAsset(ModifiedObjectReference asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.refUid = asset.getRefUid();
        this.refType = asset.getRefType().getName();
        this.refCaption = asset.getRefCaption();
        this.refModified = asset.getRefModified();
        this.contentType = asset.getContentType();
        this.operationType = asset.getOperationType();
        this.setGroups(asset.getGroups());
    }

    @Override
    public ModifiedObjectReference toAsset(Set<String> preferredProperties) throws Exception {
        ModifiedObjectReference result = new ModifiedObjectReference(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        result.setRefUid(this.refUid);
        result.setRefType(XHelper.getClass((String)this.refType));
        result.setRefCaption(this.refCaption);
        result.setRefModified(this.refModified);
        result.setGroups(this.getGroups());
        result.setContentType(this.contentType);
        result.setOperationType(this.operationType);
        return result;
    }

    public String getRefUid() {
        return this.refUid;
    }

    public void setRefUid(String refUid) {
        this.refUid = refUid;
    }

    public String getRefType() {
        return this.refType;
    }

    public void setRefType(String refType) {
        this.refType = refType;
    }

    public String getRefCaption() {
        return this.refCaption;
    }

    public void setRefCaption(String refCaption) {
        this.refCaption = refCaption;
    }

    public Date getRefModified() {
        return this.refModified;
    }

    public void setRefModified(Date refModified) {
        this.refModified = refModified;
    }

    public void setGroups(Collection<String> value) {
        if (value == null) {
            this.groups = null;
            return;
        }
        if (value.isEmpty()) {
            this.groups = "";
            return;
        }
        StringBuilder buf = new StringBuilder();
        for (String item : value) {
            buf.append('|');
            buf.append(item);
        }
        buf.append('|');
        this.groups = buf.toString();
    }

    public Collection<String> getGroups() {
        return ModifiedObjectReferenceData.getGroups(this.groups);
    }

    public static Collection<String> getGroups(String groups) {
        if (groups == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (!TextUtil.isBlank((String)groups)) {
            for (String item : groups.split("\\|")) {
                if (TextUtil.isBlank((String)item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public void setContentType(ContentType contentType) {
        this.contentType = contentType;
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(OperationType operationType) {
        this.operationType = operationType;
    }
}

