/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.common;

import com.gridnine.xtrip.common.model.cache.common.CacheDataModification;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.ContentType;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.util.Identity;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheData;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheDataEntry;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheDataStorage;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheFileDataStorage;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheModifiedObjectReferenceDataStorage;
import com.gridnine.xtrip.server.db.PollingConfiguration;
import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDataModificationsServerCache<A extends XSerializable & XSSerializable>
implements CacheDataModificationProvider<A> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final CacheDataModificationsServerCacheData<ModificationData<A>> data;
    private final CacheDataModificationsServerCacheDataStorage<ModificationData<A>> storage;
    private final TypeInfoProvider<A> provider;
    public static final int maxRecordsCount = 10000;
    private final ReadWriteLock sync = new ReentrantReadWriteLock();

    public CacheDataModificationsServerCache(File storeDir, TypeInfoProvider<A> typeProvider) {
        this.provider = typeProvider;
        this.data = new CacheDataModificationsServerCacheData();
        this.storage = !PollingConfiguration.isNewPolling() ? new CacheDataModificationsServerCacheFileDataStorage(storeDir) : new CacheDataModificationsServerCacheModifiedObjectReferenceDataStorage(typeProvider);
        try {
            CacheDataModificationsServerCacheData<ModificationData<A>> data2 = this.storage.read();
            this.data.setMetadata(data2.getMetadata());
            this.data.getReferences().putAll(data2.getReferences());
            for (Map.Entry<String, CacheDataModificationsServerCacheDataEntry<ModificationData<A>>> entry : this.data.getReferences().entrySet()) {
                if (entry.getValue().getReference() == null || entry.getValue().getReference().getItem() == null) {
                    this.log.warn(String.format("Cached reference is null (key=%s). Cache will be cleared.", entry.getKey()));
                    this.reset();
                } else {
                    String prev = entry.getValue().getPrevious();
                    if (prev == null || this.data.getReferences().get(prev) != null) continue;
                    this.log.warn(String.format("Cached entry broken (key=%s). Cache will be cleared.", entry.getKey()));
                    this.reset();
                }
                break;
            }
        }
        catch (Exception e) {
            this.log.error("unable to read data", (Throwable)e);
            this.reset();
        }
        if (this.getLastChecked() == null) {
            this.updateLastCheckDate(new Date());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheDataModification<A> getModifications(Date timeStamp, Collection<String> classNames) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("BEGIN: method = getModifications, timeStamp = " + timeStamp);
        }
        CacheDataModification result = new CacheDataModification();
        Lock lock = this.sync.readLock();
        lock.lock();
        try {
            if (this.data.getMetadata().getFirstChecked().after(timeStamp)) {
                if (this.log.isDebugEnabled()) {
                    this.log.warn(String.format("requested timestamp %s is before than first actualization date %s", timeStamp, this.data.getMetadata().getFirstChecked()));
                }
                result.setTimeStamp(null);
                CacheDataModification cacheDataModification = result;
                return cacheDataModification;
            }
            result.setTimeStamp(new Date(this.data.getMetadata().getLastChecked().getTime() - 1000L));
            if (this.log.isDebugEnabled()) {
                this.log.debug("timestamp is set to " + this.data.getMetadata().getLastChecked());
            }
            String uid = this.data.getMetadata().getLast();
            while (uid != null) {
                CacheDataModificationsServerCacheDataEntry<ModificationData<A>> entry = this.data.getReferences().get(uid);
                if (entry == null) {
                    this.log.error(String.format("logic error: entry for uid %s can not be found", uid));
                    result.getUpdatedReferences().clear();
                    result.setTimeStamp(null);
                    CacheDataModification cacheDataModification = result;
                    return cacheDataModification;
                }
                if (entry.getModified().before(timeStamp)) {
                    break;
                }
                if (classNames.contains(this.provider.getReferencedObjectType(entry.getReference().getItem()).getName())) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(String.format("entry %s is added to modification list", entry.getReference()));
                    }
                    result.getUpdatedReferences().put(entry.getReference(), entry.getModified());
                }
                uid = entry.getPrevious();
            }
        }
        finally {
            lock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("END: method = getModifications");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateLastCheckDate(Date modifiedDate) {
        Lock lock = this.sync.writeLock();
        lock.lock();
        try {
            this.data.getMetadata().setLastChecked(modifiedDate);
            try {
                this.storage.saveMetadata(this.data.getMetadata());
            }
            catch (Exception e) {
                this.log.error("unable to update data", (Throwable)e);
                this.reset();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerUpdatedEntity(ModificationData<A> md, Date modifiedDate) {
        if (md == null || md.getItem() == null) {
            this.reset();
            throw new IllegalArgumentException("Reference is null");
        }
        XSerializable item = md.getItem();
        if (!this.provider.isCached(this.provider.getReferencedObjectType(item))) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("registering update entity: type = %s, uid = %s", MiscUtil.getSimpleClassName(this.provider.getReferencedObjectType(item)), ((Identity)item).getUid()));
        }
        Lock lock = this.sync.writeLock();
        lock.lock();
        try {
            if (this.data.getMetadata().getFirst() == null || this.data.getMetadata().getLast() == null) {
                this.initialize(md, modifiedDate);
                return;
            }
            String guid = this.data.getMetadata().getLast();
            String prevEntryUid = null;
            String nextEntryUid = null;
            while (guid != null) {
                CacheDataModificationsServerCacheDataEntry<ModificationData<A>> entry = this.data.getReferences().get(guid);
                if (entry == null) {
                    this.log.error(String.format("logic error: entry for uid %s can not be found", ((Identity)item).getUid()));
                    this.initialize(md, modifiedDate);
                    return;
                }
                if (entry.getReference().getUid().equals(((Identity)item).getUid()) && !entry.getModified().before(modifiedDate)) {
                    return;
                }
                if (!entry.getModified().after(modifiedDate)) {
                    prevEntryUid = guid;
                    break;
                }
                if (guid.equals(this.data.getMetadata().getFirst())) break;
                nextEntryUid = guid;
                guid = entry.getPrevious();
            }
            HashMap updated = new HashMap();
            CacheDataModificationsServerCacheDataEntry<ModificationData<A>> newEntry = new CacheDataModificationsServerCacheDataEntry<ModificationData<A>>(md, prevEntryUid, modifiedDate);
            String newGuid = UUIDGenerator.generate((boolean)true).toString();
            this.data.getReferences().put(newGuid, newEntry);
            updated.put(newGuid, newEntry);
            if (null == prevEntryUid) {
                this.data.getMetadata().setFirst(newGuid);
            }
            if (nextEntryUid != null) {
                CacheDataModificationsServerCacheDataEntry<ModificationData<A>> nextEntry = this.data.getReferences().get(nextEntryUid);
                nextEntry.setPrevious(newGuid);
                updated.put(nextEntryUid, nextEntry);
            } else {
                this.data.getMetadata().setLast(newGuid);
            }
            try {
                this.storage.saveMetadata(this.data.getMetadata());
                this.storage.saveReferences(updated);
            }
            catch (Exception e) {
                this.log.error("unable to update data", (Throwable)e);
                this.reset();
            }
        }
        finally {
            lock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("registration completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initialize(ModificationData<A> md, Date modifiedDate) {
        if (md == null || md.getItem() == null) {
            this.reset();
            throw new IllegalArgumentException("Reference is null");
        }
        Lock lock = this.sync.writeLock();
        lock.lock();
        try {
            this.data.getReferences().clear();
            String guid = UUIDGenerator.generate((boolean)true).toString();
            this.data.getMetadata().setFirst(guid);
            this.data.getMetadata().setLast(guid);
            this.data.getReferences().put(guid, new CacheDataModificationsServerCacheDataEntry<ModificationData<A>>(md, null, modifiedDate));
            this.storage.clearAll();
            try {
                this.storage.saveMetadata(this.data.getMetadata());
                this.storage.saveReferences(this.data.getReferences());
                if (this.log.isDebugEnabled()) {
                    this.log.debug(String.format("cache initialized: lastChecked = %s, referencesCount = %s, firstCheck = %s", this.data.getMetadata().getLastChecked(), Integer.toString(this.data.getReferences().size()), this.data.getMetadata().getFirstChecked()));
                }
            }
            catch (Exception e) {
                this.log.error("unable to save data", (Throwable)e);
                this.reset();
            }
        }
        finally {
            lock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cleanup(Date limit) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("cleanup requested");
        }
        Lock lock = this.sync.writeLock();
        lock.lock();
        try {
            if (this.data.getMetadata().getLast() == null || this.data.getReferences().get(this.data.getMetadata().getLast()).getModified().before(limit)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("cache has no data or all data is invalid");
                }
                this.reset();
                return;
            }
            CacheDataModificationsServerCacheDataEntry<ModificationData<A>> entry = this.data.getReferences().get(this.data.getMetadata().getLast());
            String guid = null;
            String firstGuid = this.data.getMetadata().getLast();
            int recordsCount = 0;
            while ((guid = entry.getPrevious()) != null && !(entry = this.data.getReferences().get(guid)).getModified().before(limit) && ++recordsCount <= 10000) {
                firstGuid = guid;
            }
            if (guid == null || guid.equals(this.data.getMetadata().getFirst())) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("all data is valid");
                }
                return;
            }
            this.data.getMetadata().setFirst(firstGuid);
            HashMap updated = new HashMap();
            CacheDataModificationsServerCacheDataEntry<ModificationData<A>> firstEntry = this.data.getReferences().get(firstGuid);
            firstEntry.setPrevious(null);
            updated.put(firstGuid, firstEntry);
            HashSet<String> toDelete = new HashSet<String>();
            toDelete.add(guid);
            this.data.getReferences().remove(guid);
            while ((guid = entry == null ? null : entry.getPrevious()) != null) {
                toDelete.add(guid);
                entry = this.data.getReferences().remove(guid);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug(String.format("got %s items to delete", Integer.toString(toDelete.size())));
            }
            try {
                this.storage.saveMetadata(this.data.getMetadata());
                this.storage.saveReferences(updated);
                this.storage.deleteReferences(toDelete);
            }
            catch (Exception e) {
                this.log.error("unable to save data", (Throwable)e);
                this.reset();
            }
        }
        finally {
            lock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("cleaned up");
        }
    }

    public void reset() {
        Lock lock = this.sync.writeLock();
        lock.lock();
        try {
            this.data.getReferences().clear();
            this.data.getMetadata().setFirst(null);
            this.data.getMetadata().setLast(null);
            this.data.getMetadata().setLastChecked(new Date());
            this.data.getMetadata().setFirstChecked(new Date());
            this.storage.clearAll();
        }
        finally {
            lock.unlock();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("reset completed");
        }
    }

    Date getLastChecked() {
        Lock lock = this.sync.readLock();
        lock.lock();
        try {
            Date date = this.data.getMetadata().getLastChecked();
            return date;
        }
        finally {
            lock.unlock();
        }
    }

    public static interface TypeInfoProvider<A extends XSerializable> {
        public Class<?> getReferencedObjectType(A var1);

        public boolean isCached(Class<?> var1);

        public A createReference(String var1, Class<?> var2, String var3);

        public ContentType getContentType();
    }
}

