/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.common;

import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCache;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDataModificationsServerCacheCleaner<A extends XSerializable & XSSerializable> {
    final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private volatile boolean disposed;
    private final CacheDataModificationsServerCache<A> cache;
    private final int actualPeriod;
    private final String key;

    public CacheDataModificationsServerCacheCleaner(CacheDataModificationsServerCache<A> modificationCache, int checkPeriodInMinutes, int actualPeriodInHours, String checkThreadName, String profilingKey) {
        this.cache = modificationCache;
        this.actualPeriod = actualPeriodInHours;
        this.key = profilingKey;
        if (checkPeriodInMinutes <= 0) {
            this.log.info("period is 0, timer was not started");
            this.timer = null;
            return;
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    CacheDataModificationsServerCacheCleaner.this.clean();
                }
                catch (Throwable e) {
                    CacheDataModificationsServerCacheCleaner.this.log.error("failed updating entity cache", e);
                }
            }
        };
        this.timer = new Timer(checkThreadName, true);
        this.timer.schedule(task, 1000L, 60000L * (long)checkPeriodInMinutes);
        this.log.info("timer scheduled with period " + checkPeriodInMinutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clean() throws Exception {
        this.log.debug("started cleanup");
        if (this.disposed) {
            this.log.warn("cleaner is disposed");
            return;
        }
        CacheDataModificationsServerCacheCleaner cacheDataModificationsServerCacheCleaner = this;
        synchronized (cacheDataModificationsServerCacheCleaner) {
            try {
                long startTime = System.currentTimeMillis();
                this.cache.cleanup(new Date(System.currentTimeMillis() - (long)this.actualPeriod * 3600L * 1000L));
                CacheHelper.profileCacheOperation((String)this.key, (long)startTime);
                this.log.debug(String.format("cleanup finished, timing: %s ms", Long.toString(System.currentTimeMillis() - startTime)));
            }
            finally {
                this.notify();
            }
        }
    }

    public void dispose() {
        this.disposed = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.log.info("disposed");
    }
}

