/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.common;

import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheData;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheDataEntry;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheDataStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;

class CacheDataModificationsServerCacheFileDataStorage<A extends XSerializable & XSSerializable>
implements CacheDataModificationsServerCacheDataStorage<A> {
    private final File dir;
    MetadataStorage metaData;
    ReferencesStorage<A> refStorage;

    CacheDataModificationsServerCacheFileDataStorage(File storeDirectory) {
        this.dir = storeDirectory;
        if (this.dir == null) {
            this.metaData = null;
            this.refStorage = null;
            return;
        }
        this.metaData = new MetadataStorage(new File(this.dir, "metadata.dat"));
        this.refStorage = new ReferencesStorage(new File(this.dir, "refs/"));
    }

    @Override
    public CacheDataModificationsServerCacheData read() throws Exception {
        CacheDataModificationsServerCacheData result = new CacheDataModificationsServerCacheData();
        result.setMetadata(this.readMetadata());
        result.getReferences().putAll(this.readAllReferences());
        return result;
    }

    private CacheDataModificationsServerCacheData.Metadata readMetadata() throws Exception {
        if (this.dir == null) {
            return new CacheDataModificationsServerCacheData.Metadata();
        }
        return this.metaData.load();
    }

    @Override
    public void saveMetadata(CacheDataModificationsServerCacheData.Metadata data) throws Exception {
        if (this.dir != null) {
            this.metaData.save(data);
        }
    }

    private Map<String, CacheDataModificationsServerCacheDataEntry<A>> readAllReferences() throws Exception {
        if (this.dir == null) {
            return Collections.emptyMap();
        }
        return this.refStorage.getAll();
    }

    @Override
    public void deleteReferences(Collection<String> guids) throws Exception {
        if (this.dir != null) {
            this.refStorage.delete(guids);
        }
    }

    @Override
    public void saveReferences(Map<String, CacheDataModificationsServerCacheDataEntry<A>> data) throws Exception {
        if (this.dir != null) {
            this.refStorage.save(data);
        }
    }

    @Override
    public void clearAll() {
        if (this.dir != null) {
            IoUtil.deleteFile((File)this.dir);
        }
    }

    static class MetadataStorage {
        private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss-SSS", Locale.ENGLISH);
        private final File propFile;
        private static final String LAST_FIELD_NAME = "last";
        private static final String FIRST_FIELD_NAME = "first";
        private static final String LAST_CHECKED_FIELD_NAME = "last_checked";
        private static final String FIRST_CHECKED_FIELD_NAME = "first_checked";

        MetadataStorage(File file) {
            this.propFile = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CacheDataModificationsServerCacheData.Metadata load() throws Exception {
            CacheDataModificationsServerCacheData.Metadata data = new CacheDataModificationsServerCacheData.Metadata();
            data.setLastChecked(new Date());
            data.setFirstChecked(new Date());
            data.setFirst(null);
            data.setLast(null);
            Properties props = new Properties();
            if (!this.propFile.exists()) {
                return data;
            }
            try (FileInputStream fis = new FileInputStream(this.propFile);){
                props.load(fis);
                data.setLast(props.getProperty(LAST_FIELD_NAME));
                data.setFirst(props.getProperty(FIRST_FIELD_NAME));
                String checkedStr = props.getProperty(LAST_CHECKED_FIELD_NAME);
                if (!TextUtil.isBlank((String)checkedStr)) {
                    data.setLastChecked(this.sdf.parse(checkedStr));
                }
                if (!TextUtil.isBlank((String)(checkedStr = props.getProperty(FIRST_CHECKED_FIELD_NAME)))) {
                    data.setFirstChecked(this.sdf.parse(checkedStr));
                }
            }
            return data;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(CacheDataModificationsServerCacheData.Metadata data) throws Exception {
            if (!this.propFile.getParentFile().exists() && !this.propFile.getParentFile().mkdirs()) {
                throw new Exception("unable to create directory " + this.propFile.getParentFile());
            }
            Properties props = new Properties();
            if (!TextUtil.isBlank((String)data.getFirst())) {
                props.setProperty(FIRST_FIELD_NAME, data.getFirst());
            }
            if (!TextUtil.isBlank((String)data.getLast())) {
                props.setProperty(LAST_FIELD_NAME, data.getLast());
            }
            if (data.getLastChecked() != null) {
                props.setProperty(LAST_CHECKED_FIELD_NAME, this.sdf.format(data.getLastChecked()));
            }
            if (data.getFirstChecked() != null) {
                props.setProperty(FIRST_CHECKED_FIELD_NAME, this.sdf.format(data.getFirstChecked()));
            }
            try (FileOutputStream fos = new FileOutputStream(this.propFile);){
                props.store(fos, "DONT MODIFY");
            }
        }
    }

    static class ReferencesStorage<A extends XSerializable & XSSerializable> {
        final transient Logger log = LoggerFactory.getLogger(this.getClass());
        private final File refDir;

        ReferencesStorage(File directory) {
            this.refDir = directory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Map<String, CacheDataModificationsServerCacheDataEntry<A>> getAll() throws Exception {
            if (!this.refDir.exists()) {
                return Collections.emptyMap();
            }
            HashMap<String, CacheDataModificationsServerCacheDataEntry<A>> result = new HashMap<String, CacheDataModificationsServerCacheDataEntry<A>>();
            result.clear();
            for (File file : this.refDir.listFiles()) {
                String guid = file.getName();
                try (FileInputStream fis = new FileInputStream(file);){
                    Element root = DocumentBuilderHelper.parse((InputStream)fis).getDocumentElement();
                    CacheDataModificationsServerCacheDataEntry entry = new CacheDataModificationsServerCacheDataEntry();
                    entry.fromXML(root);
                    result.put(guid, entry);
                }
            }
            return result;
        }

        void delete(Collection<String> guids) throws Exception {
            if (!this.refDir.exists()) {
                return;
            }
            for (String item : guids) {
                File file = new File(this.refDir, item);
                if (file.delete()) continue;
                throw new Exception("unable to delete file " + file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void save(Map<String, CacheDataModificationsServerCacheDataEntry<A>> data) throws Exception {
            if (!this.refDir.exists() && !this.refDir.mkdirs()) {
                throw new Exception("unable to create directory " + this.refDir);
            }
            for (Map.Entry<String, CacheDataModificationsServerCacheDataEntry<A>> item : data.entrySet()) {
                try (FileOutputStream fos = new FileOutputStream(new File(this.refDir, item.getKey()));){
                    XSUtil.serialize((XSSerializable)item.getValue(), (OutputStream)fos);
                }
            }
        }
    }
}

