/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.common;

import com.gridnine.xtrip.common.model.cache.asset.ModifiedObjectReference;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.search.SortOrder;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCache;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheData;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheDataEntry;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCacheDataStorage;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CacheDataModificationsServerCacheModifiedObjectReferenceDataStorage<B extends XSerializable & XSSerializable, A extends ModificationData<B>>
implements CacheDataModificationsServerCacheDataStorage<A> {
    private final CacheDataModificationsServerCache.TypeInfoProvider<B> typeProvider;

    public CacheDataModificationsServerCacheModifiedObjectReferenceDataStorage(CacheDataModificationsServerCache.TypeInfoProvider<B> typeProvider) {
        this.typeProvider = typeProvider;
    }

    @Override
    public CacheDataModificationsServerCacheData read() {
        CacheDataModificationsServerCacheData result = new CacheDataModificationsServerCacheData();
        CacheDataModificationsServerCacheData.Metadata metadata = new CacheDataModificationsServerCacheData.Metadata();
        metadata.setFirstChecked(new Date());
        metadata.setLastChecked(new Date());
        result.setMetadata(metadata);
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ModifiedObjectReference.Property.contentType.name(), (Object)this.typeProvider.getContentType()));
        query.getCriteria().getOrders().put(ModifiedObjectReference.Property.refModified.name(), SortOrder.DESC);
        query.setLimit(10000);
        SearchResult<ModifiedObjectReference> data = LogicalStorage.get().getAssetStorage().search(ModifiedObjectReference.class, query);
        metadata.setFirst(!data.getData().isEmpty() ? ((ModifiedObjectReference)data.getData().get(data.getData().size() - 1)).getUid() : null);
        metadata.setLast(!data.getData().isEmpty() ? ((ModifiedObjectReference)data.getData().get(0)).getUid() : null);
        ConcurrentHashMap refs = result.getReferences();
        CacheDataModificationsServerCacheDataEntry<ModificationData> nextEntry = null;
        for (ModifiedObjectReference modifiedRef : data.getData()) {
            String uid = modifiedRef.getUid();
            B ref = this.typeProvider.createReference(uid, modifiedRef.getRefType(), modifiedRef.getRefCaption());
            ModificationData reference = new ModificationData((XSerializable)ref, modifiedRef.getGroups());
            CacheDataModificationsServerCacheDataEntry<ModificationData> entry = new CacheDataModificationsServerCacheDataEntry<ModificationData>();
            entry.setModified(modifiedRef.getRefModified());
            entry.setReference(reference);
            refs.put(uid, entry);
            if (nextEntry != null) {
                nextEntry.setPrevious(uid);
            }
            nextEntry = entry;
        }
        return result;
    }

    @Override
    public void saveMetadata(CacheDataModificationsServerCacheData.Metadata data) {
    }

    @Override
    public void deleteReferences(Collection<String> guids) {
    }

    @Override
    public void saveReferences(Map<String, CacheDataModificationsServerCacheDataEntry<A>> data) {
    }

    @Override
    public void clearAll() {
    }
}

