/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.common;

import com.gridnine.xtrip.common.model.cache.common.CacheDataModification;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheHelper;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.cache.common.CacheDataModificationsServerCache;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheDataModificationsServerCacheUpdater<A extends XSerializable & XSSerializable> {
    final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final Timer timer;
    private volatile boolean disposed;
    private final CacheDataModificationProvider<A> mp;
    private final CacheDataModificationsServerCache<A> cache;
    final Collection<String> classNames;
    final String key;

    public CacheDataModificationsServerCacheUpdater(CacheDataModificationProvider<A> modificationsProvider, CacheDataModificationsServerCache<A> modificatonsCache, int updatePeriodInSeconds, Collection<String> cachedClassNames, String checkThreadName, String profilingKey) {
        this.key = profilingKey;
        this.mp = modificationsProvider;
        this.cache = modificatonsCache;
        this.classNames = cachedClassNames;
        if (updatePeriodInSeconds <= 0) {
            this.log.info("delay is 0, timer was not started");
            this.timer = null;
            return;
        }
        if (this.cache.getLastChecked() != null && TimeUnit.MILLISECONDS.toHours(System.currentTimeMillis() - this.cache.getLastChecked().getTime()) > 1L) {
            this.cache.reset();
        }
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    CacheDataModificationsServerCacheUpdater.this.check();
                }
                catch (Throwable e) {
                    CacheDataModificationsServerCacheUpdater.this.log.error("failed updating entity cache", e);
                }
            }
        };
        this.timer = new Timer(checkThreadName, true);
        this.timer.schedule(task, 1000L, 1000L * (long)updatePeriodInSeconds);
        this.log.info("timer scheduled with period " + updatePeriodInSeconds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void check() throws Exception {
        this.log.debug("started check");
        if (this.disposed) {
            this.log.warn("updater is disposed");
            return;
        }
        Date currentDate = new Date();
        CacheDataModificationsServerCacheUpdater cacheDataModificationsServerCacheUpdater = this;
        synchronized (cacheDataModificationsServerCacheUpdater) {
            try {
                if (currentDate.before(this.cache.getLastChecked())) {
                    this.log.debug(String.format("current check timestamp %s is greater than request date %s", this.cache.getLastChecked(), currentDate));
                    return;
                }
                long startTime = System.currentTimeMillis();
                this.update(currentDate);
                CacheHelper.profileCacheOperation((String)this.key, (long)startTime);
                this.log.debug(String.format("check finished, timing: %s ms", Long.toString(System.currentTimeMillis() - startTime)));
            }
            finally {
                this.notify();
            }
        }
    }

    private void update(Date currentDate) throws Exception {
        if (this.log.isDebugEnabled()) {
            this.log.debug(String.format("starting update: last check is %s, classes are %s", this.cache.getLastChecked(), this.classNames));
        }
        CacheDataModification items = this.mp.getModifications(this.cache.getLastChecked(), this.classNames);
        for (Map.Entry item : items.getUpdatedReferences().entrySet()) {
            this.cache.registerUpdatedEntity((ModificationData)item.getKey(), item.getValue() == null ? null : new Date(((Date)item.getValue()).getTime() + 1000L));
        }
        Date timestamp = items.getTimeStamp();
        if (null == timestamp) {
            timestamp = new Date();
        }
        this.cache.updateLastCheckDate(new Date(timestamp.getTime() - 1000L));
        if (this.log.isDebugEnabled()) {
            this.log.debug("timestamp is set to " + items.getTimeStamp());
            this.log.debug("update completed");
        }
    }

    public void dispose() {
        this.disposed = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.log.info("disposed");
    }
}

