/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.entity.advanced;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.advanced.GroupsHandlerManager;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECManager;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.db.DbInterceptor;
import com.gridnine.xtrip.server.jms.JMSFacade;
import java.util.HashSet;
import java.util.Set;

public class AECDbOperationsInterceptor
implements DbInterceptor {
    private static final ThreadLocal<Set<ModificationData<EntityReference<?>>>> pool = new ThreadLocal();

    @Override
    public double getPriority() {
        return 11.0;
    }

    @Override
    public void afterLoad(Object data, Object loadContext) {
    }

    @Override
    public void afterDelete(Object data) {
    }

    @Override
    public void beforeSave(Object data) {
    }

    @Override
    public void afterBeginUnitOfWork() {
    }

    @Override
    public void beforeCommit() {
    }

    @Override
    public void commitFailed() {
        if (pool.get() != null) {
            pool.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitSucceded() {
        if (pool.get() == null) {
            return;
        }
        AECManager manager = this.getManager();
        if (manager == null) {
            pool.remove();
            return;
        }
        try {
            for (ModificationData<EntityReference<?>> item : pool.get()) {
                if (!manager.isCached(((EntityReference)item.getItem()).getType())) continue;
                manager.invalidate(item);
                ((JMSFacade)Environment.getPublished(JMSFacade.class)).publishMessageAsync("entity-cache", item);
            }
        }
        finally {
            pool.remove();
        }
    }

    @Override
    public void afterCancelUnitOfWork() {
        if (pool.get() != null) {
            pool.remove();
        }
    }

    void add(EntityContainer<?> value) {
        this.add(new ModificationData((XSerializable)value.toReference(), GroupsHandlerManager.getGroups((Object)value.getEntity())));
    }

    void add(ModificationData<EntityReference<?>> value) {
        if (this.getManager() == null) {
            return;
        }
        Set<ModificationData<EntityReference<?>>> set = pool.get();
        if (set == null) {
            set = new HashSet();
            pool.set(set);
        }
        set.add(value);
    }

    AECManager getManager() {
        return (AECManager)(Environment.isPublished(EntityCacheManager.class) && AECManager.class.isAssignableFrom(((EntityCacheManager)Environment.getPublished(EntityCacheManager.class)).getClass()) ? (EntityCacheManager)Environment.getPublished(EntityCacheManager.class) : null);
    }
}

