/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.entity.advanced;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.server.cache.entity.advanced.AECDbOperationsInterceptor;
import com.gridnine.xtrip.server.db.DbInterceptor;
import com.gridnine.xtrip.server.db.SessionCallback;
import com.gridnine.xtrip.server.db.storage.common.LogicalStorageRegistry;
import com.gridnine.xtrip.server.db.storage.model.BaseIndexData;
import com.gridnine.xtrip.server.db.storage.model.EntityOperationContextData;
import com.gridnine.xtrip.server.db.storage.model.EntityStorageOperationCompletedInterceptor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AECOperationCompletedInterceptor
implements EntityStorageOperationCompletedInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    public double getPriority() {
        return 11.0;
    }

    @Override
    public <E extends BaseEntity> void afterSave(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes, boolean withCheckPoint, EntityOperationContextData context) throws Exception {
        if (EntityStorage.get() == null || this.getDbInterceptor() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
    }

    @Override
    public <E extends BaseEntity> void afterDelete(SessionCallback ss, EntityContainer<E> data, EntityOperationContextData context) throws Exception {
        if (EntityStorage.get() == null || this.getDbInterceptor() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
    }

    @Override
    public <E extends BaseEntity> void afterRollback(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes) throws Exception {
        if (EntityStorage.get() == null || this.getDbInterceptor() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
    }

    @Override
    public <E extends BaseEntity> void afterRestore(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes) throws Exception {
        if (EntityStorage.get() == null || this.getDbInterceptor() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
    }

    @Override
    public <E extends BaseEntity> void afterIndexUpdate(SessionCallback ss, EntityContainer<E> data, List<BaseIndexData<E, EntityIndex<E>>> indexes) throws Exception {
        if (EntityStorage.get() == null || this.getDbInterceptor() == null) {
            return;
        }
        this.getDbInterceptor().add(data);
    }

    private AECDbOperationsInterceptor getDbInterceptor() {
        if (!Environment.isPublished(LogicalStorageRegistry.class)) {
            this.log.warn(String.format("%s is not registered", LogicalStorageRegistry.class.getName()));
            return null;
        }
        for (DbInterceptor item : LogicalStorageRegistry.get().getDbInterceptors()) {
            if (!(item instanceof AECDbOperationsInterceptor)) continue;
            return (AECDbOperationsInterceptor)item;
        }
        this.log.error(String.format("%s is not registered", AECDbOperationsInterceptor.class.getName()));
        return null;
    }
}

