/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.entity.advanced;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.NestedEntityReference;
import com.gridnine.xtrip.common.model.cache.common.ReferenceActualizationResult;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECActualStorage;
import com.gridnine.xtrip.common.model.entity.parameters.BaseEntityStorageParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageActualizeParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageDeleteParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageIsAvailableParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageLoadParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageRollbackParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSearchParameters;
import com.gridnine.xtrip.common.search.ProjectionQuery;
import com.gridnine.xtrip.common.search.ProjectionResult;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.threadactivity.ThreadActivityLog;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;

public class AECServerActualStorage
implements AECActualStorage {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity, I extends EntityIndex<E>> ProjectionResult search(Class<I> cls, ProjectionQuery query, EntityStorageSearchParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            ProjectionResult projectionResult = LogicalStorage.get().getEntityStorage().search(cls, query, parameters);
            return projectionResult;
        }
        finally {
            AECServerActualStorage.reportDbQuery("searchProjection", start, parameters, null, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity, I extends EntityIndex<E>> SearchResult<I> search(Class<I> cls, SearchQuery query, EntityStorageSearchParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            SearchResult<I> searchResult = LogicalStorage.get().getEntityStorage().search(cls, query, parameters);
            return searchResult;
        }
        finally {
            AECServerActualStorage.reportDbQuery("search", start, parameters, null, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> EntityContainer<E> save(EntityContainer<E> etc, boolean withCheckPoint, EntityStorageSaveParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            LogicalStorage.get().getEntityStorage().save(etc, withCheckPoint, parameters);
            EntityContainer<E> entityContainer = etc;
            return entityContainer;
        }
        finally {
            AECServerActualStorage.reportDbQuery("save", start, parameters, etc.getUid(), etc.getEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> EntityContainer<E> rollback(EntityContainer<E> etc, int versionNumber, EntityStorageRollbackParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            LogicalStorage.get().getEntityStorage().rollback(etc, versionNumber, parameters);
            EntityContainer<E> entityContainer = etc;
            return entityContainer;
        }
        finally {
            AECServerActualStorage.reportDbQuery("rollback", start, parameters, etc.getUid(), etc.getEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> EntityContainer<E> load(Class<E> cls, String uid, Integer versionNumber) throws Exception {
        long start = System.currentTimeMillis();
        try {
            EntityContainer<E> entityContainer = LogicalStorage.get().getEntityStorage().load(cls, uid, versionNumber, new EntityStorageLoadParameters());
            return entityContainer;
        }
        finally {
            AECServerActualStorage.reportDbQuery("loadVersion", start, null, uid, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> EntityContainer<E> load(EntityReference<E> ref, EntityStorageLoadParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            EntityContainer<E> entityContainer = LogicalStorage.get().getEntityStorage().load(ref, parameters);
            return entityContainer;
        }
        finally {
            AECServerActualStorage.reportDbQuery("load", start, parameters, ref.getUid(), ref.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> boolean isAvailable(Class<E> cls, String uid, EntityStorageIsAvailableParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            boolean bl = LogicalStorage.get().getEntityStorage().isAvailable(cls, uid, parameters);
            return bl;
        }
        finally {
            AECServerActualStorage.reportDbQuery("isAvailable", start, parameters, uid, cls);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void delete(EntityReference<E> ref, EntityStorageDeleteParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            EntityContainer<E> ctr = this.load(ref, new EntityStorageLoadParameters());
            if (ctr != null) {
                this.delete(ctr, parameters);
            }
        }
        finally {
            AECServerActualStorage.reportDbQuery("deleteReference", start, parameters, ref.getUid(), ref.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> ReferenceActualizationResult<E> actualizeReference(EntityReference<E> ref, EntityStorageActualizeParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            ReferenceActualizationResult<E> referenceActualizationResult = LogicalStorage.get().getEntityStorage().actualizeReference(ref, parameters);
            return referenceActualizationResult;
        }
        finally {
            AECServerActualStorage.reportDbQuery("actualizeReference", start, parameters, ref.getUid(), ref.getType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity, T extends BaseEntity> ReferenceActualizationResult<T> actualizeNestedReference(NestedEntityReference<E, T> ref, EntityStorageActualizeParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            ReferenceActualizationResult<T> referenceActualizationResult = LogicalStorage.get().getEntityStorage().actualizeNestedReference(ref, parameters);
            return referenceActualizationResult;
        }
        finally {
            AECServerActualStorage.reportDbQuery("actualizeNestedReference", start, parameters, ref.getNestedEntityUid(), ref.getNestedEntityType());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends BaseEntity> void delete(EntityContainer<E> etc, EntityStorageDeleteParameters parameters) throws Exception {
        long start = System.currentTimeMillis();
        try {
            LogicalStorage.get().getEntityStorage().delete(etc, parameters);
        }
        finally {
            AECServerActualStorage.reportDbQuery("deleteContainer", start, parameters, etc.getUid(), etc.getEntityType());
        }
    }

    private static void reportDbQuery(String operation, long start, BaseEntityStorageParameters<?> parameters, String uid, Class<?> type) {
        if (ThreadActivityLog.isEnabled() && System.currentTimeMillis() - start > ThreadActivityLog.getMinDuration()) {
            StringBuilder sb = new StringBuilder();
            sb.append("db.query ");
            sb.append(operation);
            sb.append(" @");
            if (parameters != null && parameters.getContext() != null && Boolean.TRUE.equals(parameters.getContext().get("irrelevance-tolerant-query"))) {
                sb.append("slave");
            } else {
                sb.append("master");
            }
            sb.append(" (");
            sb.append(System.currentTimeMillis() - start);
            sb.append(" ms)\ndetails: uid=");
            sb.append(uid);
            sb.append(", type=");
            sb.append(MiscUtil.getSimpleClassName(type));
            ThreadActivityLog.reportStackTrace((String)sb.toString());
        }
    }
}

