/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.entity.advanced;

import com.gridnine.xtrip.common.Disposable;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.cache.common.CacheDataModificationProvider;
import com.gridnine.xtrip.common.model.cache.common.CacheState;
import com.gridnine.xtrip.common.model.cache.common.ModificationData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECActualStorage;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECConfiguration;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECData;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECManager;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AECUpdater;
import com.gridnine.xtrip.common.model.cache.entity.advanced.AdvancedCachedEntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.cache.EntityCacheManager;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsCache;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsCacheCleaner;
import com.gridnine.xtrip.server.cache.entity.advanced.AECServerModificationsCacheUpdater;
import com.gridnine.xtrip.server.cache.entity.advanced.EntityStorageWrapper;
import java.util.Date;
import org.apache.commons.lang.StringUtils;

public class AECServerManager
extends AECManager
implements Disposable {
    private final AECServerModificationsCacheUpdater cacheUpdater;
    private final AECServerModificationsCache cache;
    private final AECServerModificationsCacheCleaner cacheCleaner;

    private AECServerManager(AECUpdater cacheUpdaterValue, AECData cacheData, AdvancedCachedEntityStorage cachedStorage, CacheState cacheState, AECConfiguration cacheConfig, AECServerModificationsCache modificationsCache, AECServerModificationsCacheUpdater modificationsCacheUpdater, AECServerModificationsCacheCleaner modificationsCacheCleaner) {
        super(cacheUpdaterValue, cacheData, cachedStorage, cacheState, cacheConfig);
        this.cache = modificationsCache;
        this.cacheUpdater = modificationsCacheUpdater;
        this.cacheCleaner = modificationsCacheCleaner;
    }

    public static void publish(AECServerFactory factory, AECConfiguration config) throws Exception {
        CacheState cacheState = factory.createState();
        AECActualStorage actualStorage = factory.createActualStorage();
        AECData cacheData = new AECData(config);
        AdvancedCachedEntityStorage storage = new AdvancedCachedEntityStorage(cacheData, actualStorage, cacheState, config);
        if (!Environment.isPublished(EntityStorage.class)) {
            AdvancedCachedEntityStorage entityStorage = storage;
            String wrapperClassName = System.getProperty(EntityStorageWrapper.class.getName() + ".className");
            if (!StringUtils.isBlank((String)wrapperClassName)) {
                EntityStorageWrapper wrapper = (EntityStorageWrapper)Class.forName(wrapperClassName).newInstance();
                entityStorage = wrapper.wrap((EntityStorage)entityStorage);
            }
            Environment.publish(EntityStorage.class, (Object)entityStorage);
        }
        AECServerModificationsCache modificationsCache = factory.createModificationsCache(config);
        AECServerModificationsCacheUpdater modificationsCacheUpdater = factory.createUpdater(factory.createModificationProvider(), modificationsCache, config);
        AECServerModificationsCacheCleaner cleaner = factory.createCleaner(modificationsCache);
        Environment.publish(AECServerModificationsCache.class, (Object)modificationsCache);
        AECUpdater cacheUpdater = factory.createUpdater(modificationsCache, cacheData, cacheState, config);
        Environment.publish(EntityCacheManager.class, (Object)((Object)new AECServerManager(cacheUpdater, cacheData, storage, cacheState, config, modificationsCache, modificationsCacheUpdater, cleaner)));
    }

    public void invalidate(ModificationData<EntityReference<?>> ref) {
        this.cache.registerUpdatedEntity(ref, new Date());
        super.invalidate(ref);
    }

    public void dispose() {
        this.cacheUpdater.dispose();
        this.cacheCleaner.dispose();
        super.dispose();
    }

    public void reset() {
        super.reset();
        this.cache.reset();
    }

    public static interface AECServerFactory
    extends AECManager.AECFactory {
        public AECServerModificationsCache createModificationsCache(AECConfiguration var1);

        public AECServerModificationsCacheUpdater createUpdater(CacheDataModificationProvider<EntityReference<?>> var1, AECServerModificationsCache var2, AECConfiguration var3);

        public AECServerModificationsCacheCleaner createCleaner(AECServerModificationsCache var1);
    }
}

