/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.object;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.cache.object.Cache;
import com.gridnine.xtrip.server.cache.object.CacheService;
import com.gridnine.xtrip.server.cache.object.KeyBuilder;
import com.gridnine.xtrip.server.cache.object.SharedCache;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CacheFactory {
    private static final Logger LOG = LoggerFactory.getLogger(CacheFactory.class);

    public static <K, V extends Serializable> Cache<K, V> create(String category, KeyBuilder<K> keyBuilder) {
        if (!Environment.isPublished(CacheService.class)) {
            return null;
        }
        CacheService cacheService = (CacheService)Environment.getPublished(CacheService.class);
        if (cacheService == null) {
            return null;
        }
        SharedCache result = new SharedCache(category, cacheService, keyBuilder);
        LOG.info("created shared cache for category " + category);
        return result;
    }

    private CacheFactory() {
    }
}

