/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.cache.object;

import com.gridnine.xtrip.server.cache.object.Cache;
import com.gridnine.xtrip.server.cache.object.CacheService;
import com.gridnine.xtrip.server.cache.object.KeyBuilder;
import com.gridnine.xtrip.server.metrics.Metrics;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SharedCache<K, V extends Serializable>
implements Cache<K, V> {
    private final transient Logger log = LoggerFactory.getLogger(this.getClass());
    private final String category;
    private final CacheService service;
    private final KeyBuilder<K> keyBuilder;

    SharedCache(String ctg, CacheService ccs, KeyBuilder<K> builder) {
        this.category = ctg;
        this.service = ccs;
        this.keyBuilder = builder;
    }

    @Override
    public byte[] buildKey(K key) {
        try {
            return this.keyBuilder.build(this.category, key);
        }
        catch (Throwable t) {
            this.log.error("failed building key", t);
            return null;
        }
    }

    @Override
    public void put(byte[] key, V value, int timeoutInSeconds) {
        if (key == null || timeoutInSeconds <= 0) {
            return;
        }
        long timing = System.currentTimeMillis();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(value);
            oos.flush();
            this.service.put(key, baos.toByteArray(), timeoutInSeconds);
            Metrics.get().timingAndEvent("profiling.cache." + this.category + ".put", timing);
        }
        catch (Throwable t) {
            this.log.error("failed putting into cache", t);
        }
    }

    @Override
    public V get(byte[] key) {
        byte[] resultData;
        if (key == null) {
            return null;
        }
        long timing = System.currentTimeMillis();
        try {
            resultData = this.service.get(key);
        }
        catch (Throwable t) {
            this.log.error("failed retrieving from cache", t);
            Metrics.get().timingAndEvent("profiling.cache." + this.category + ".fail", timing);
            return null;
        }
        if (resultData == null || resultData.length == 0) {
            Metrics.get().timingAndEvent("profiling.cache." + this.category + ".miss", timing);
            return null;
        }
        try {
            Serializable result = (Serializable)new ObjectInputStream(new ByteArrayInputStream(resultData)).readObject();
            Metrics.get().timingAndEvent("profiling.cache." + this.category + ".hit", timing);
            return (V)result;
        }
        catch (ClassCastException cce) {
            this.log.error("class cast exception when deserializing object - " + cce);
        }
        catch (Exception e) {
            this.log.error("failed deserializing object - " + e);
        }
        Metrics.get().timingAndEvent("profiling.cache." + this.category + ".fail", timing);
        return null;
    }

    @Override
    public void remove(byte[] key) {
        if (key == null) {
            return;
        }
        long timing = System.currentTimeMillis();
        try {
            this.service.remove(key);
            Metrics.get().timingAndEvent("profiling.cache." + this.category + ".remove", timing);
        }
        catch (Throwable t) {
            this.log.error("failed removing from cache", t);
        }
    }

    @Override
    public String getCategory() {
        return this.category;
    }
}

