/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.sql.DataSource;

public class JdbcStorage {
    private final DataSource dataSource;
    private boolean autoCommit = true;
    private int queryTimeout = 180;

    public JdbcStorage(DataSource ds) {
        this.dataSource = ds;
    }

    public void setAutoCommit(boolean value) {
        this.autoCommit = value;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int timeoutInSeconds) {
        this.queryTimeout = timeoutInSeconds;
    }

    public Connection openConnection() throws SQLException {
        Connection result = this.dataSource.getConnection();
        result.setAutoCommit(this.autoCommit);
        return result;
    }

    public int executeUpdate(StatementSupplier statementSupplier) throws SQLException {
        try (JdbcResource res = new JdbcResource();){
            res.cnn = this.openConnection();
            res.st = statementSupplier.create(res.cnn);
            ((PreparedStatement)res.st).setQueryTimeout(this.getQueryTimeout());
            int result = ((PreparedStatement)res.st).executeUpdate();
            if (!res.cnn.getAutoCommit()) {
                res.cnn.commit();
            }
            int n = result;
            return n;
        }
    }

    public void executeQuery(StatementSupplier statementSupplier, RowProcessor processor) throws SQLException {
        try (JdbcResource res = new JdbcResource();){
            res.cnn = this.openConnection();
            res.st = statementSupplier.create(res.cnn);
            ((PreparedStatement)res.st).setQueryTimeout(this.getQueryTimeout());
            res.rs = ((PreparedStatement)res.st).executeQuery();
            int row = 1;
            while (res.rs.next()) {
                processor.process(res.rs, row);
                ++row;
            }
        }
    }

    public Stream<Object[]> executeQuery(StatementSupplier statementSupplier) throws SQLException {
        JdbcResource<PreparedStatement> res = new JdbcResource<PreparedStatement>();
        try {
            res.cnn = this.openConnection();
            res.st = statementSupplier.create(res.cnn);
            ((PreparedStatement)res.st).setQueryTimeout(this.getQueryTimeout());
            res.rs = ((PreparedStatement)res.st).executeQuery();
        }
        catch (SQLException e) {
            res.close();
            throw e;
        }
        return JdbcStorage.getStream(res);
    }

    static Stream<Object[]> getStream(final JdbcResource<PreparedStatement> res) {
        return (Stream)StreamSupport.stream(Spliterators.spliteratorUnknownSize(new Iterator<Object[]>(){
            private int columnCount;
            {
                try {
                    this.columnCount = res.rs.getMetaData().getColumnCount();
                }
                catch (SQLException e) {
                    res.close();
                    throw new RuntimeException("failed getting columns count from resultset", e);
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    return res.rs.next();
                }
                catch (SQLException e) {
                    res.close();
                    throw new RuntimeException("failed moving forward resultset", e);
                }
            }

            @Override
            public Object[] next() {
                Object[] result = new Object[this.columnCount];
                for (int i = 0; i < this.columnCount; ++i) {
                    try {
                        result[i] = res.rs.getObject(i + 1);
                        continue;
                    }
                    catch (SQLException e) {
                        res.close();
                        throw new RuntimeException("failed retrieving value of column " + (i + 1), e);
                    }
                }
                return result;
            }
        }, 0), false).onClose(res::close);
    }

    public static void close(Connection cnn, Statement st) {
        JdbcStorage.close(cnn, st, null);
    }

    public static void close(Connection cnn, Statement st, ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (cnn != null) {
            try {
                cnn.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    static class JdbcResource<S extends Statement>
    implements AutoCloseable {
        Connection cnn;
        S st;
        ResultSet rs;

        JdbcResource() {
        }

        @Override
        public void close() {
            JdbcStorage.close(this.cnn, this.st, this.rs);
        }
    }

    @FunctionalInterface
    public static interface RowProcessor {
        public void process(ResultSet var1, int var2) throws SQLException;
    }

    @FunctionalInterface
    public static interface StatementSupplier {
        public PreparedStatement create(Connection var1) throws SQLException;
    }
}

