/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db;

import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.db.JdbcStorage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class JdbcTransaction
implements AutoCloseable {
    private final Connection connection;
    private final boolean autoCommitOld;
    private boolean commited;
    private boolean rolled;
    private int queryTimeout;
    private final List<JdbcStorage.JdbcResource<PreparedStatement>> jdbcResources = new ArrayList<JdbcStorage.JdbcResource<PreparedStatement>>();

    public JdbcTransaction(Connection connection) {
        this(connection, 180);
    }

    public JdbcTransaction(Connection connection, int queryTimeoutMs) {
        try {
            this.connection = connection;
            this.autoCommitOld = connection.getAutoCommit();
            this.connection.setAutoCommit(false);
            this.queryTimeout = queryTimeoutMs;
        }
        catch (SQLException e) {
            throw Xeption.forDeveloper((String)"init", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public Stream<Object[]> executeQuery(JdbcStorage.StatementSupplier statementSupplier) throws SQLException {
        JdbcStorage.JdbcResource<PreparedStatement> res = new JdbcStorage.JdbcResource<PreparedStatement>();
        res.st = statementSupplier.create(this.connection);
        ((PreparedStatement)res.st).setQueryTimeout(this.getQueryTimeout());
        res.rs = ((PreparedStatement)res.st).executeQuery();
        this.jdbcResources.add(res);
        return JdbcStorage.getStream(res);
    }

    public int executeUpdate(JdbcStorage.StatementSupplier statementSupplier) throws SQLException {
        JdbcStorage.JdbcResource res = new JdbcStorage.JdbcResource();
        res.st = statementSupplier.create(this.connection);
        ((PreparedStatement)res.st).setQueryTimeout(this.getQueryTimeout());
        this.jdbcResources.add(res);
        return ((PreparedStatement)res.st).executeUpdate();
    }

    public void executeQuery(JdbcStorage.StatementSupplier statementSupplier, JdbcStorage.RowProcessor processor) throws SQLException {
        JdbcStorage.JdbcResource res = new JdbcStorage.JdbcResource();
        res.st = statementSupplier.create(this.connection);
        ((PreparedStatement)res.st).setQueryTimeout(this.getQueryTimeout());
        res.rs = ((PreparedStatement)res.st).executeQuery();
        this.jdbcResources.add(res);
        int row = 1;
        while (res.rs.next()) {
            processor.process(res.rs, row++);
        }
    }

    public void commit() throws SQLException {
        this.check();
        this.connection.commit();
        this.commited = true;
    }

    private void check() {
        if (this.rolled || this.commited) {
            throw Xeption.forDeveloper((String)"Wrong status, rolled={0}, commited={1}", (Object[])new Object[]{this.rolled, this.commited});
        }
    }

    public void rollback() throws SQLException {
        this.check();
        if (!this.commited) {
            this.connection.rollback();
            this.rolled = true;
        }
    }

    @Override
    public void close() throws SQLException {
        if (!this.commited) {
            this.connection.rollback();
        }
        this.jdbcResources.forEach(JdbcStorage.JdbcResource::close);
        this.connection.setAutoCommit(this.autoCommitOld);
        if (!this.connection.isClosed()) {
            this.connection.close();
        }
    }

    public void setQueryTimeout(int timeoutInSeconds) {
        this.queryTimeout = timeoutInSeconds;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }
}

