/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.db;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleConnectionProvider
implements ConnectionProvider {
    private static final Logger log = LoggerFactory.getLogger(SimpleConnectionProvider.class);
    private boolean autocommit;
    private Integer isolation;
    private String url;
    private Properties connectionProps;

    public void configure(Properties props) throws HibernateException {
        String driverClass = props.getProperty("hibernate.connection.driver_class");
        log.info("Using simple no-pooling connection provider");
        this.autocommit = PropertiesHelper.getBoolean((String)"hibernate.connection.autocommit", (Properties)props);
        log.debug("auto-commit mode: " + this.autocommit);
        this.isolation = PropertiesHelper.getInteger((String)"hibernate.connection.isolation", (Properties)props);
        if (this.isolation != null) {
            log.debug("JDBC isolation level: " + Environment.isolationLevelToString((int)this.isolation));
        }
        if (driverClass == null) {
            log.warn("no JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName((String)driverClass);
                }
                catch (ClassNotFoundException cnfe2) {
                    String msg = "JDBC Driver class not found: " + driverClass;
                    log.error(msg, (Throwable)cnfe2);
                    throw new HibernateException(msg, (Throwable)cnfe2);
                }
            }
        }
        this.url = props.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            log.error(msg);
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderFactory.getConnectionProperties((Properties)props);
        log.debug("using driver: " + driverClass + " at URL: " + this.url);
        if (log.isDebugEnabled()) {
            log.debug("connection properties: " + this.connectionProps);
        } else if (log.isInfoEnabled()) {
            log.info("connection properties: " + PropertiesHelper.maskOut((Properties)this.connectionProps, (String)"password"));
        }
    }

    public Connection getConnection() throws SQLException {
        Connection result = DriverManager.getConnection(this.url, this.connectionProps);
        if (this.isolation != null) {
            result.setTransactionIsolation(this.isolation);
        }
        if (result.getAutoCommit() != this.autocommit) {
            result.setAutoCommit(this.autocommit);
        }
        if (log.isDebugEnabled()) {
            log.debug("JDBC connection created: url=" + this.url);
        }
        return result;
    }

    public void closeConnection(Connection conn) throws SQLException {
        if (conn.isClosed()) {
            return;
        }
        conn.close();
        log.debug("JDBC connection closed: url=" + this.url);
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

